/*
 * Copyright 2016-2023 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.galleon.cli.cmd.state.configuration;

import java.util.List;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.GalleonCLICommandCompleter;
import org.jboss.galleon.cli.HelpDescriptions;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.state.AbstractFPProvisionedCommand;

/**
 *
 * @author jdenise@redhat.com
 */
public abstract class AbstractProvisionedDefaultConfigCommand extends AbstractFPProvisionedCommand {

    public static class ProvisionedConfigCompleter extends AbstractCompleter implements GalleonCLICommandCompleter {

        @Override
        public String getCoreCompleterClassName(PmSession session) {
            return "org.jboss.galleon.cli.cmd.state.configuration.core.CoreProvisionedConfigCompleter";
        }

        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            return completerInvocation.getPmSession().getState().completionContent(this, completerInvocation);
        }

    }

    public static class TargetedFPCompleter extends AbstractCompleter implements GalleonCLICommandCompleter {

        @Override
        public String getCoreCompleterClassName(PmSession session) {
            return "org.jboss.galleon.cli.cmd.state.configuration.core.CoreAbstractProvisionedDefaultConfigCommand$TargetedFPContentCompleter";
        }

        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            return completerInvocation.getPmSession().getState().completionContent(this, completerInvocation);
        }

    }

    @Argument(required = false, description = HelpDescriptions.CONFIGURATION_FULL_NAME,
            completer = ProvisionedConfigCompleter.class)
    private String configuration;

    @Option(completer = TargetedFPCompleter.class,
            description = HelpDescriptions.CONFIGURATION_ORIGIN)
    private String origin;

    public String getConfiguration() {
        return configuration;
    }

    public abstract boolean isIncludedConfigs();

    /**
     * @return the origin
     */
    public String getOrigin() {
        return origin;
    }
}
