/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.io.Resource;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.ProvisioningCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;

@CommandDefinition(name="provision", description="(Re)Provisions the installation according to the specification provided in an XML file", activator=NoStateCommandActivator.class)
public class ProvisionSpecCommand
extends ProvisioningCommand {
    @Argument(description="File describing the desired provisioned state.", required=true)
    private Resource specArg;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        if (this.specArg == null) {
            throw new CommandExecutionException("Missing required file path argument.");
        }
        Resource specResource = this.specArg.resolve(session.getAeshContext().getCurrentWorkingDirectory()).get(0);
        Path provisioningFile = Paths.get(specResource.getAbsolutePath(), new String[0]);
        if (!Files.exists(provisioningFile, new LinkOption[0])) {
            throw new CommandExecutionException("Failed to locate provisioning file " + provisioningFile.toAbsolutePath());
        }
        try {
            this.getManager(session).provision(provisioningFile);
        }
        catch (ProvisioningException e) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.provisioningFailed(), e);
        }
    }
}

