/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.featurepack;

import java.io.File;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.universe.FeaturePackLocation;

@CommandDefinition(name="import", description="import a feature-pack")
public class ImportCommand
extends PmSessionCommand {
    @Argument(required=true)
    private File path;
    @Option(name="install-in-universe", hasValue=true, required=false, description="Add feature-pack to universe. Optional, it is installed by default.")
    private Boolean install;

    @Override
    protected void runCommand(PmCommandInvocation commandInvocation) throws CommandExecutionException {
        try {
            FeaturePackLocation fpl = commandInvocation.getPmSession().getLayoutFactory().addLocal(this.path.toPath(), this.install == null ? true : this.install);
            commandInvocation.println(fpl + " imported.");
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.importFeaturePackFailed(), ex);
        }
    }
}

