/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.featurepack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.featurepack.AbstractFeaturePackCommand;
import org.jboss.galleon.cli.cmd.state.StateInfoUtil;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.FeaturePackLocation;

@CommandDefinition(name="info", description="info on a feature-pack")
public class InfoCommand
extends AbstractFeaturePackCommand {
    public static final String PATCH_FOR = "Patch for ";
    @Option(completer=InfoTypeCompleter.class)
    private String type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runCommand(PmCommandInvocation commandInvocation) throws CommandExecutionException {
        if (this.fpl != null && this.file != null) {
            throw new CommandExecutionException("File and location can't be both set");
        }
        if (this.fpl == null && this.file == null) {
            throw new CommandExecutionException("File or location must be set");
        }
        PmSession session = commandInvocation.getPmSession();
        FeaturePackLayout product = null;
        ArrayList<FeaturePackLocation> dependencies = new ArrayList<FeaturePackLocation>();
        ProvisioningConfig provisioning = null;
        try (ProvisioningLayout<FeaturePackLayout> layout = null;){
            try {
                if (this.fpl != null) {
                    FeaturePackLocation loc = session.getResolvedLocation(this.fpl);
                    FeaturePackConfig featurePackConfig = FeaturePackConfig.forLocation(loc);
                    provisioning = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(featurePackConfig)).build();
                    layout = session.getLayoutFactory().newConfigLayout(provisioning);
                } else {
                    layout = session.getLayoutFactory().newConfigLayout(this.file.toPath(), true);
                }
            }
            catch (ProvisioningException ex) {
                throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.infoFailed(), ex);
            }
            for (FeaturePackLayout featurePackLayout : layout.getOrderedFeaturePacks()) {
                boolean isProduct = true;
                for (FeaturePackLayout fpLayout2 : layout.getOrderedFeaturePacks()) {
                    if (!fpLayout2.getSpec().hasTransitiveDep(featurePackLayout.getFPID().getProducer()) && fpLayout2.getSpec().getFeaturePackDep(featurePackLayout.getFPID().getProducer()) == null) continue;
                    isProduct = false;
                    break;
                }
                if (isProduct) {
                    product = featurePackLayout;
                    continue;
                }
                dependencies.add(session.getExposedLocation(featurePackLayout.getFPID().getLocation()));
            }
            if (product == null) {
                throw new CommandExecutionException("No feature-pack found");
            }
            StateInfoUtil.printFeaturePack(commandInvocation, product.getFPID().getLocation());
            FeaturePackLocation.FPID patchFor = product.getSpec().getPatchFor();
            if (patchFor != null) {
                commandInvocation.println(PATCH_FOR + patchFor);
            }
            try {
                if (this.type != null) {
                    switch (this.type) {
                        case "all": {
                            this.displayDependencies(commandInvocation, dependencies);
                            this.displayConfigs(commandInvocation, product);
                            this.displayOptions(commandInvocation, layout);
                            break;
                        }
                        case "configs": {
                            this.displayConfigs(commandInvocation, product);
                            break;
                        }
                        case "dependencies": {
                            this.displayDependencies(commandInvocation, dependencies);
                            break;
                        }
                        case "options": {
                            this.displayOptions(commandInvocation, layout);
                            break;
                        }
                        default: {
                            throw new CommandExecutionException(CliErrors.invalidInfoType());
                        }
                    }
                }
            }
            catch (ProvisioningException provisioningException) {
                throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.infoFailed(), provisioningException);
            }
        }
    }

    private void displayDependencies(PmCommandInvocation commandInvocation, List<FeaturePackLocation> dependencies) throws CommandExecutionException {
        String str = StateInfoUtil.buildDependencies(dependencies, null);
        if (str != null) {
            commandInvocation.println(str);
        }
    }

    private void displayConfigs(PmCommandInvocation commandInvocation, FeaturePackLayout product) {
        HashMap<String, List<ConfigInfo>> configs = new HashMap<String, List<ConfigInfo>>();
        for (ConfigModel m : product.getSpec().getDefinedConfigs()) {
            String model = m.getModel();
            ArrayList<ConfigInfo> names = (ArrayList<ConfigInfo>)configs.get(model);
            if (names == null) {
                names = new ArrayList<ConfigInfo>();
                configs.put(model, names);
            }
            if (m.getName() == null) continue;
            names.add(new ConfigInfo(model, m.getName()));
        }
        String str = StateInfoUtil.buildConfigs(configs);
        if (str != null) {
            commandInvocation.println(str);
        }
    }

    private void displayOptions(PmCommandInvocation commandInvocation, ProvisioningLayout layout) throws ProvisioningException {
        String str = StateInfoUtil.buildOptions(PluginResolver.resolvePlugins(layout));
        if (str != null) {
            commandInvocation.println(str);
        }
    }

    public class InfoTypeCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            return Arrays.asList("all", "configs", "dependencies", "options");
        }
    }
}

