/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.filesystem;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.filesystem.FileAndNodeCompleter;
import org.jboss.galleon.cli.cmd.state.StateInfoUtil;
import org.jboss.galleon.cli.model.FeatureContainer;

@CommandDefinition(name="ls", description="show the current [dir] or [fp node]")
public class LsCommand
extends PmSessionCommand {
    @Argument(completer=FileAndNodeCompleter.class)
    private String path;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        boolean fp;
        boolean bl = fp = session.getPmSession().getCurrentPath() != null;
        if (this.path == null || this.path.isEmpty()) {
            this.path = fp ? session.getPmSession().getCurrentPath() : session.getAeshContext().getCurrentWorkingDirectory().getAbsolutePath();
        }
        if (fp) {
            FeatureContainer container = session.getPmSession().getContainer();
            if (!this.path.startsWith("/")) {
                this.path = session.getPmSession().getCurrentPath() + this.path;
            }
            try {
                StateInfoUtil.printContentPath(session, container, this.path);
            }
            catch (Exception ex) {
                throw new CommandExecutionException(session.getPmSession(), CliErrors.displayContentFailed(), ex);
            }
        } else {
            Path res = Paths.get(this.path, new String[0]);
            if (Files.isDirectory(res, new LinkOption[0])) {
                try {
                    this.displayDirectory(res, session);
                }
                catch (IOException ex) {
                    throw new CommandExecutionException(session.getPmSession(), CliErrors.displayContentFailed(), ex);
                }
            } else if (Files.isRegularFile(res, new LinkOption[0])) {
                this.displayFile(res, session);
            } else if (!Files.exists(res, new LinkOption[0])) {
                session.getShell().writeln("ls: cannot access " + res.toString() + ": No such file or directory");
            }
        }
    }

    private void displayDirectory(Path input, PmCommandInvocation shell) throws IOException {
        Files.list(input).forEach(p -> shell.println(p.getFileName().toString()));
    }

    private void displayFile(Path input, PmCommandInvocation shell) {
        shell.println(input.getFileName().toString());
    }
}

