/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.mvn;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.config.mvn.MavenRemoteRepository;

@CommandDefinition(name="add-repository", description="Add a maven repo")
public class MavenAddRepository
extends PmSessionCommand {
    @Option(description="Maven remote repository URL", required=true)
    private String url;
    @Option(description="Maven remote repository type, \"default\" by default", required=false, defaultValue={"default"})
    private String type;
    @Option(description="Maven remote repository name", required=true)
    private String name;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        try {
            session.getPmSession().getPmConfiguration().getMavenConfig().addRemoteRepository(new MavenRemoteRepository(this.name, this.type, this.url));
        }
        catch (IOException | XMLStreamException | ProvisioningException ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.addRepositoryFailed(), ex);
        }
    }
}

