/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.pkg;

import java.io.IOException;
import java.util.Set;
import org.aesh.command.CommandDefinition;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.state.pkg.AbstractProvisionedPackageCommand;
import org.jboss.galleon.cli.cmd.state.pkg.PackagesUtil;
import org.jboss.galleon.cli.cmd.state.pkg.ProvisionedPackageCommandActivator;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.FeaturePackConfig;

@CommandDefinition(name="remove-excluded", description="Remove an already excluded package", activator=ProvisionedPackageCommandActivator.class)
public class StateRemoveExcludedPackageCommand
extends AbstractProvisionedPackageCommand {
    @Override
    protected void runCommand(PmCommandInvocation invoc, State session, FeaturePackConfig config) throws IOException, ProvisioningException, CommandExecutionException {
        try {
            session.removeExcludedPackage(invoc.getPmSession(), PackagesUtil.getExcludedPackages(invoc.getPmSession(), config, this.getPackage()));
        }
        catch (Exception ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.removeFailed(), ex);
        }
    }

    @Override
    protected Set<String> getTargetedPackages(FeaturePackConfig cf) {
        return cf.getExcludedPackages();
    }
}

