/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.diff;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.diff.FileSystemMerge;
import org.jboss.galleon.diff.ProvisioningDiffResult;

public class TheirsStrategy
extends FileSystemMerge {
    public TheirsStrategy(MessageWriter messageWriter, Path stagedInstallation, Path customizedInstallation) {
        super(messageWriter, stagedInstallation, customizedInstallation);
    }

    @Override
    public void executeUpdate(ProvisioningDiffResult result) throws IOException {
        for (Path addedPath : result.getAddedFiles()) {
            Path target = this.resolveStagePath(addedPath);
            Path src = this.resolveOriginPath(addedPath);
            if (Files.exists(target, new LinkOption[0])) continue;
            try {
                if (Files.isDirectory(src, new LinkOption[0])) {
                    Files.createDirectories(target, new FileAttribute[0]);
                } else {
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(src, target, new CopyOption[0]);
                }
                this.messageWriter.verbose("File %s has been copied to %s", src, target);
            }
            catch (IOException ioex) {
                throw new RuntimeException("Couldn't copy file " + src, ioex);
            }
        }
        this.patchFiles(result.getUnifiedDiffs());
    }

    @Override
    public void patchFailure(Path path) {
    }
}

