/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.nio.file.Path;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.state.ProvisionedPackage;

public class PackageRuntime
implements ProvisionedPackage {
    private final FeaturePackRuntime fp;
    private final PackageSpec spec;
    private final Path layoutDir;

    static Builder builder(PackageSpec spec, Path dir) {
        return new Builder(spec, dir);
    }

    private PackageRuntime(Builder builder, FeaturePackRuntime fp) {
        this.fp = fp;
        this.spec = builder.spec;
        this.layoutDir = builder.dir;
    }

    public FeaturePackRuntime getFeaturePackRuntime() {
        return this.fp;
    }

    public PackageSpec getSpec() {
        return this.spec;
    }

    @Override
    public String getName() {
        return this.spec.getName();
    }

    public Path getResource(String ... path) throws ProvisioningDescriptionException {
        if (path.length == 0) {
            throw new IllegalArgumentException("Resource path is null");
        }
        if (path.length == 1) {
            return this.layoutDir.resolve(path[0]);
        }
        Path p = this.layoutDir;
        for (String name : path) {
            p = p.resolve(name);
        }
        return p;
    }

    public Path getContentDir() {
        return this.layoutDir.resolve("content");
    }

    static class Builder {
        final Path dir;
        final PackageSpec spec;

        private Builder(PackageSpec spec, Path dir) {
            this.dir = dir;
            this.spec = spec;
        }

        PackageRuntime build(FeaturePackRuntime fp) {
            return new PackageRuntime(this, fp);
        }
    }
}

