/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigItem;
import org.jboss.galleon.config.ConfigItemContainer;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.PackageConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayoutFactory;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.runtime.ConfigModelStack;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.FpStack;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ResolvedConfig;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.ResolvedFeatureGroupConfig;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageDepsSpec;
import org.jboss.galleon.spec.SpecId;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;

public class ProvisioningRuntimeBuilder {
    public static final FeaturePackLayoutFactory<FeaturePackRuntimeBuilder> FP_RT_FACTORY = new FeaturePackLayoutFactory<FeaturePackRuntimeBuilder>(){

        @Override
        public FeaturePackRuntimeBuilder newFeaturePack(FeaturePackLocation fpl, FeaturePackSpec spec, Path fpDir, int type) {
            return new FeaturePackRuntimeBuilder(fpl.getFPID(), spec, fpDir, type);
        }
    };
    final long startTime;
    String encoding;
    ProvisioningConfig config;
    ProvisioningLayout<FeaturePackRuntimeBuilder> layout;
    Map<String, String> pluginOptions = Collections.emptyMap();
    private final MessageWriter messageWriter;
    List<ConfigModelStack> anonymousConfigs = Collections.emptyList();
    Map<String, ConfigModelStack> nameOnlyConfigs = Collections.emptyMap();
    Map<String, ConfigModelStack> modelOnlyConfigs = Collections.emptyMap();
    Map<String, Map<String, ConfigModelStack>> namedModelConfigs = Collections.emptyMap();
    private List<ConfigModel> modelOnlyConfigSpecs = Collections.emptyList();
    private List<FeaturePackLocation.FPID> modelOnlyFPIDs = Collections.emptyList();
    private FeaturePackRuntimeBuilder thisOrigin;
    private FeaturePackRuntimeBuilder currentOrigin;
    private ConfigModelStack configStack;
    private FpStack fpConfigStack;
    private ResolvedFeature parentFeature;

    public static ProvisioningRuntimeBuilder newInstance() {
        return ProvisioningRuntimeBuilder.newInstance(DefaultMessageWriter.getDefaultInstance());
    }

    public static ProvisioningRuntimeBuilder newInstance(MessageWriter messageWriter) {
        return new ProvisioningRuntimeBuilder(messageWriter);
    }

    private ProvisioningRuntimeBuilder(MessageWriter messageWriter) {
        this.startTime = System.currentTimeMillis();
        this.messageWriter = messageWriter;
    }

    public ProvisioningRuntimeBuilder setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public ProvisioningRuntimeBuilder initRtLayout(ProvisioningLayout<FeaturePackRuntimeBuilder> configLayout) throws ProvisioningException {
        this.layout = configLayout;
        return this;
    }

    public ProvisioningRuntimeBuilder initLayout(ProvisioningLayout<?> configLayout) throws ProvisioningException {
        this.layout = configLayout.transform(FP_RT_FACTORY);
        return this;
    }

    public ProvisioningRuntimeBuilder initLayout(ProvisioningLayoutFactory layoutFactory, ProvisioningConfig config) throws ProvisioningException {
        this.layout = layoutFactory.newConfigLayout(config, FP_RT_FACTORY);
        return this;
    }

    public ProvisioningRuntime build() throws ProvisioningException {
        try {
            ProvisioningRuntime provisioningRuntime = this.doBuild();
            return provisioningRuntime;
        }
        catch (Error | RuntimeException | ProvisioningException e) {
            throw e;
        }
        finally {
            this.layout.close();
        }
    }

    private ProvisioningRuntime doBuild() throws ProvisioningException {
        this.config = this.layout.getConfig();
        this.fpConfigStack = new FpStack(this.config);
        List<Object> fpConfigResolvers = Collections.emptyList();
        if (this.config.hasDefinedConfigs()) {
            List<ConfigModel> definedConfigs = this.config.getDefinedConfigs();
            for (int i = definedConfigs.size() - 1; i >= 0; --i) {
                ConfigModel config = definedConfigs.get(i);
                if (this.fpConfigStack.isFilteredOut(null, config.getId(), true)) continue;
                this.configStack = this.getConfigStack(config.getId());
                this.configStack.pushConfig(config);
                fpConfigResolvers = CollectionUtils.add(fpConfigResolvers, this.configStack);
            }
        }
        Collection<FeaturePackConfig> fpConfigs = this.config.getFeaturePackDeps();
        boolean extendedStackLevel = false;
        if (this.config.hasTransitiveDeps()) {
            for (FeaturePackConfig fpConfig : this.config.getTransitiveDeps()) {
                extendedStackLevel |= this.fpConfigStack.push(fpConfig, extendedStackLevel);
            }
        }
        for (FeaturePackConfig fpConfig : fpConfigs) {
            extendedStackLevel |= this.fpConfigStack.push(fpConfig, extendedStackLevel);
        }
        while (this.fpConfigStack.hasNext()) {
            this.processFpConfig(this.fpConfigStack.next());
        }
        if (extendedStackLevel) {
            this.fpConfigStack.popLevel();
        }
        for (int i = fpConfigResolvers.size() - 1; i >= 0; --i) {
            ConfigModelStack configResolver = (ConfigModelStack)fpConfigResolvers.get(i);
            ConfigModel config = configResolver.popConfig();
            if (config.getId().isModelOnly()) {
                this.recordModelOnlyConfig(null, config);
                continue;
            }
            this.processConfig(configResolver, config);
        }
        this.mergeModelOnlyConfigs();
        return new ProvisioningRuntime(this, this.messageWriter);
    }

    private void mergeModelOnlyConfigs() throws ProvisioningException {
        if (!this.modelOnlyConfigSpecs.isEmpty()) {
            for (int i = 0; i < this.modelOnlyConfigSpecs.size(); ++i) {
                ConfigModel modelOnlySpec = this.modelOnlyConfigSpecs.get(i);
                if (!this.namedModelConfigs.containsKey(modelOnlySpec.getModel())) continue;
                this.fpConfigStack.activateConfigStack(i);
                FeaturePackLocation.FPID fpid = this.modelOnlyFPIDs.get(i);
                this.thisOrigin = fpid == null ? null : this.getFpBuilder(fpid.getProducer());
                this.setOrigin(this.thisOrigin);
                this.processConfig(this.getConfigStack(modelOnlySpec.getId()), modelOnlySpec);
            }
        }
        if (this.modelOnlyConfigs.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ConfigModelStack> entry : this.modelOnlyConfigs.entrySet()) {
            Map<String, ConfigModelStack> targetConfigs = this.namedModelConfigs.get(entry.getKey());
            if (targetConfigs == null) continue;
            for (Map.Entry<String, ConfigModelStack> targetConfig : targetConfigs.entrySet()) {
                targetConfig.getValue().merge(entry.getValue());
            }
        }
        this.modelOnlyConfigs = Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFpConfig(FeaturePackConfig fpConfig) throws ProvisioningException {
        this.thisOrigin = this.getFpBuilder(fpConfig.getLocation().getProducer());
        FeaturePackRuntimeBuilder parentFp = this.setOrigin(this.thisOrigin);
        try {
            List<Object> fpConfigStacks = Collections.emptyList();
            if (fpConfig.hasDefinedConfigs()) {
                FeaturePackLocation.ProducerSpec producer = this.currentOrigin.getFPID().getProducer();
                List<ConfigModel> definedConfigs = fpConfig.getDefinedConfigs();
                for (int i = definedConfigs.size() - 1; i >= 0; --i) {
                    ConfigModel config = definedConfigs.get(i);
                    if (this.fpConfigStack.isFilteredOut(producer, config.getId(), true)) continue;
                    this.configStack = this.getConfigStack(config.getId());
                    this.configStack.pushConfig(config);
                    fpConfigStacks = CollectionUtils.add(fpConfigStacks, this.configStack);
                }
                this.configStack = null;
            }
            boolean extendedStackLevel = false;
            if (!fpConfig.isTransitive()) {
                List<ConfigModelStack> specConfigStacks = Collections.emptyList();
                FeaturePackSpec currentSpec = this.currentOrigin.spec;
                if (currentSpec.hasDefinedConfigs()) {
                    Iterator<FeaturePackConfig> producer = this.currentOrigin.getFPID().getProducer();
                    List<ConfigModel> definedConfigs = currentSpec.getDefinedConfigs();
                    for (int i = definedConfigs.size() - 1; i >= 0; --i) {
                        ConfigModel config = definedConfigs.get(i);
                        if (this.fpConfigStack.isFilteredOut((FeaturePackLocation.ProducerSpec)((Object)producer), config.getId(), false)) continue;
                        this.configStack = this.getConfigStack(config.getId());
                        this.configStack.pushConfig(config);
                        specConfigStacks = CollectionUtils.add(specConfigStacks, this.configStack);
                    }
                    this.configStack = null;
                }
                if (currentSpec.hasFeaturePackDeps()) {
                    if (currentSpec.hasTransitiveDeps()) {
                        for (FeaturePackConfig fpDep : currentSpec.getTransitiveDeps()) {
                            extendedStackLevel |= this.fpConfigStack.push(fpDep, extendedStackLevel);
                        }
                    }
                    for (FeaturePackConfig fpDep : currentSpec.getFeaturePackDeps()) {
                        extendedStackLevel |= this.fpConfigStack.push(fpDep, extendedStackLevel);
                    }
                    if (extendedStackLevel) {
                        while (this.fpConfigStack.hasNext()) {
                            this.processFpConfig(this.fpConfigStack.next());
                        }
                    }
                }
                if (!specConfigStacks.isEmpty()) {
                    for (int i = specConfigStacks.size() - 1; i >= 0; --i) {
                        ConfigModelStack configStack = (ConfigModelStack)specConfigStacks.get(i);
                        ConfigModel config = configStack.popConfig();
                        if (config.getId().isModelOnly()) {
                            this.recordModelOnlyConfig(fpConfig.getLocation().getFPID(), config);
                            continue;
                        }
                        this.processConfig(configStack, config);
                    }
                }
                if (fpConfig.isInheritPackages() && currentSpec.hasDefaultPackages()) {
                    for (String packageName : currentSpec.getDefaultPackageNames()) {
                        if (this.fpConfigStack.isPackageFilteredOut(this.currentOrigin.producer, packageName, false)) continue;
                        this.resolvePackage(packageName);
                    }
                }
            }
            if (fpConfig.hasIncludedPackages()) {
                for (PackageConfig pkgConfig : fpConfig.getIncludedPackages()) {
                    if (this.fpConfigStack.isPackageFilteredOut(this.currentOrigin.producer, pkgConfig.getName(), true)) continue;
                    this.resolvePackage(pkgConfig.getName());
                }
            }
            if (!fpConfigStacks.isEmpty()) {
                for (int i = fpConfigStacks.size() - 1; i >= 0; --i) {
                    ConfigModelStack configStack = (ConfigModelStack)fpConfigStacks.get(i);
                    ConfigModel config = configStack.popConfig();
                    if (config.getId().isModelOnly()) {
                        this.recordModelOnlyConfig(fpConfig.getLocation().getFPID(), config);
                        continue;
                    }
                    this.processConfig(configStack, config);
                }
            }
            if (extendedStackLevel) {
                this.fpConfigStack.popLevel();
            }
        }
        finally {
            this.thisOrigin = parentFp;
            this.setOrigin(parentFp);
        }
    }

    private void recordModelOnlyConfig(FeaturePackLocation.FPID fpid, ConfigModel config) {
        this.modelOnlyConfigSpecs = CollectionUtils.add(this.modelOnlyConfigSpecs, config);
        this.modelOnlyFPIDs = CollectionUtils.add(this.modelOnlyFPIDs, fpid);
        this.fpConfigStack.recordStack();
    }

    private void processConfig(ConfigModelStack configStack, ConfigModel config) throws ProvisioningException {
        this.configStack = configStack;
        configStack.overwriteProps(config.getProperties());
        configStack.overwriteConfigDeps(config.getConfigDeps());
        try {
            if (config.hasPackageDeps()) {
                this.processPackageDeps(config);
            }
            this.processConfigItemContainer(config);
            this.configStack = null;
        }
        catch (ProvisioningException e) {
            throw new ProvisioningException(Errors.failedToResolveConfigSpec(config.getModel(), config.getName()), e);
        }
    }

    private ConfigModelStack getConfigStack(ConfigId id) throws ProvisioningException {
        if (id.getModel() == null) {
            if (id.getName() == null) {
                ConfigModelStack configStack = new ConfigModelStack(id, this);
                this.anonymousConfigs = CollectionUtils.add(this.anonymousConfigs, configStack);
                return configStack;
            }
            ConfigModelStack configStack = this.nameOnlyConfigs.get(id.getName());
            if (configStack == null) {
                configStack = new ConfigModelStack(id, this);
                this.nameOnlyConfigs = CollectionUtils.putLinked(this.nameOnlyConfigs, id.getName(), configStack);
            }
            return configStack;
        }
        if (id.getName() == null) {
            ConfigModelStack configStack = this.modelOnlyConfigs.get(id.getModel());
            if (configStack == null) {
                configStack = new ConfigModelStack(id, this);
                this.modelOnlyConfigs = CollectionUtils.putLinked(this.modelOnlyConfigs, id.getModel(), configStack);
            }
            return configStack;
        }
        Map<String, ConfigModelStack> namedConfigs = this.namedModelConfigs.get(id.getModel());
        if (namedConfigs == null) {
            ConfigModelStack configStack = new ConfigModelStack(id, this);
            namedConfigs = Collections.singletonMap(id.getName(), configStack);
            this.namedModelConfigs = CollectionUtils.putLinked(this.namedModelConfigs, id.getModel(), namedConfigs);
            return configStack;
        }
        ConfigModelStack configStack = namedConfigs.get(id.getName());
        if (configStack != null) {
            return configStack;
        }
        if (namedConfigs.size() == 1) {
            namedConfigs = new LinkedHashMap<String, ConfigModelStack>(namedConfigs);
            if (this.namedModelConfigs.size() == 1) {
                this.namedModelConfigs = new LinkedHashMap<String, Map<String, ConfigModelStack>>(this.namedModelConfigs);
            }
            this.namedModelConfigs.put(id.getModel(), namedConfigs);
        }
        configStack = new ConfigModelStack(id, this);
        namedConfigs.put(id.getName(), configStack);
        return configStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFeatureGroup(FeatureGroupSupport includedFg) throws ProvisioningException {
        boolean pushed = this.configStack.pushGroup(includedFg);
        FeaturePackRuntimeBuilder originalOrigin = this.currentOrigin;
        try {
            FeatureGroup originalFg = this.getFeatureGroupSpec(includedFg.getName());
            if (originalFg.hasPackageDeps()) {
                this.processPackageDeps(originalFg);
            }
            if (!pushed) {
                return;
            }
            this.processConfigItemContainer(originalFg);
        }
        finally {
            this.currentOrigin = originalOrigin;
        }
        this.configStack.popGroup();
        if (includedFg.hasItems()) {
            this.processConfigItemContainer(includedFg);
        }
    }

    private FeaturePackRuntimeBuilder setOrigin(String origin) throws ProvisioningException {
        return origin == null ? this.currentOrigin : this.setOrigin(this.getOrigin(origin));
    }

    FeaturePackRuntimeBuilder setOrigin(FeaturePackRuntimeBuilder origin) {
        FeaturePackRuntimeBuilder prevOrigin = this.currentOrigin;
        this.currentOrigin = origin;
        return prevOrigin;
    }

    FeaturePackRuntimeBuilder getOrigin(String depName) throws ProvisioningException {
        if ("this".equals(depName)) {
            if (this.thisOrigin == null) {
                throw new ProvisioningException("Feature-pack reference 'this' cannot be used in the current context.");
            }
            return this.thisOrigin;
        }
        FeaturePackLocation fpl = this.currentOrigin == null ? this.config.getFeaturePackDep(depName).getLocation() : this.currentOrigin.spec.getFeaturePackDep(depName).getLocation();
        return this.getFpBuilder(fpl.getProducer());
    }

    private FeaturePackRuntimeBuilder setThisOrigin(FeaturePackRuntimeBuilder origin) {
        FeaturePackRuntimeBuilder prevOrigin = this.thisOrigin;
        this.thisOrigin = origin;
        return prevOrigin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResolvedFeatureGroupConfig resolveFeatureGroupConfig(FeatureGroupSupport fg) throws ProvisioningException {
        FeaturePackLocation.ProducerSpec fgOrigin = null;
        if (!fg.isConfig()) {
            FeaturePackRuntimeBuilder originalOrigin = this.currentOrigin;
            this.getFeatureGroupSpec(fg.getName());
            fgOrigin = this.currentOrigin.producer;
            this.currentOrigin = originalOrigin;
        }
        ResolvedFeatureGroupConfig resolvedFgc = new ResolvedFeatureGroupConfig(this.configStack, fg, fgOrigin);
        resolvedFgc.inheritFeatures = fg.isInheritFeatures();
        if (fg.hasExcludedSpecs()) {
            resolvedFgc.excludedSpecs = this.resolveSpecIds(resolvedFgc.excludedSpecs, fg.getExcludedSpecs());
        }
        if (fg.hasIncludedSpecs()) {
            resolvedFgc.includedSpecs = this.resolveSpecIds(resolvedFgc.includedSpecs, fg.getIncludedSpecs());
        }
        if (fg.hasExcludedFeatures()) {
            resolvedFgc.excludedFeatures = this.resolveExcludedIds(resolvedFgc.excludedFeatures, fg.getExcludedFeatures());
        }
        if (fg.hasIncludedFeatures()) {
            resolvedFgc.includedFeatures = this.resolveIncludedIds(resolvedFgc.includedFeatures, fg.getIncludedFeatures());
        }
        if (fg.hasExternalFeatureGroups()) {
            FeaturePackRuntimeBuilder originalOrigin = this.currentOrigin;
            for (Map.Entry<String, FeatureGroup> entry : fg.getExternalFeatureGroups().entrySet()) {
                FeatureGroup extFg = entry.getValue();
                this.setOrigin(entry.getKey());
                try {
                    if (extFg.hasExcludedSpecs()) {
                        resolvedFgc.excludedSpecs = this.resolveSpecIds(resolvedFgc.excludedSpecs, extFg.getExcludedSpecs());
                    }
                    if (extFg.hasIncludedSpecs()) {
                        resolvedFgc.includedSpecs = this.resolveSpecIds(resolvedFgc.includedSpecs, extFg.getIncludedSpecs());
                    }
                    if (extFg.hasExcludedFeatures()) {
                        resolvedFgc.excludedFeatures = this.resolveExcludedIds(resolvedFgc.excludedFeatures, extFg.getExcludedFeatures());
                    }
                    if (!extFg.hasIncludedFeatures()) continue;
                    resolvedFgc.includedFeatures = this.resolveIncludedIds(resolvedFgc.includedFeatures, extFg.getIncludedFeatures());
                }
                finally {
                    this.setOrigin(originalOrigin);
                }
            }
        }
        return resolvedFgc;
    }

    void processIncludedFeatures(ResolvedFeatureGroupConfig pushedFgConfig) throws ProvisioningException {
        if (pushedFgConfig.includedFeatures.isEmpty()) {
            return;
        }
        for (Map.Entry<ResolvedFeatureId, FeatureConfig> feature : pushedFgConfig.includedFeatures.entrySet()) {
            ResolvedFeatureId includedId;
            FeatureConfig includedFc = feature.getValue();
            if (includedFc == null || !includedFc.hasParams() || pushedFgConfig.configStack.isFilteredOut(includedId.specId, includedId = feature.getKey())) continue;
            if (!pushedFgConfig.configStack.includes(includedId)) {
                throw new ProvisioningException(Errors.featureNotInScope(includedId, pushedFgConfig.fg.getId() == null ? "'anonymous'" : pushedFgConfig.fg.getId().toString(), this.currentOrigin == null ? null : this.currentOrigin.producer.getLocation().getFPID()));
            }
            this.resolveFeature(pushedFgConfig.configStack, includedFc);
        }
    }

    private Map<ResolvedFeatureId, FeatureConfig> resolveIncludedIds(Map<ResolvedFeatureId, FeatureConfig> includedFeatures, Map<FeatureId, FeatureConfig> features) throws ProvisioningException {
        for (Map.Entry<FeatureId, FeatureConfig> included : features.entrySet()) {
            FeatureConfig fc = new FeatureConfig(included.getValue());
            ResolvedFeatureSpec resolvedSpec = this.getFeatureSpec(fc.getSpecId().getName());
            if (this.parentFeature != null) {
                includedFeatures = CollectionUtils.put(includedFeatures, resolvedSpec.resolveIdFromForeignKey(this.parentFeature.id, fc.getParentRef(), fc.getParams()), fc);
                continue;
            }
            includedFeatures = CollectionUtils.put(includedFeatures, resolvedSpec.resolveFeatureId(fc.getParams()), fc);
        }
        return includedFeatures;
    }

    private Set<ResolvedFeatureId> resolveExcludedIds(Set<ResolvedFeatureId> resolvedIds, Map<FeatureId, String> features) throws ProvisioningException {
        for (Map.Entry<FeatureId, String> excluded : features.entrySet()) {
            FeatureId excludedId = excluded.getKey();
            ResolvedFeatureSpec resolvedSpec = this.getFeatureSpec(excludedId.getSpec().getName());
            if (this.parentFeature != null) {
                resolvedIds = CollectionUtils.add(resolvedIds, resolvedSpec.resolveIdFromForeignKey(this.parentFeature.id, excluded.getValue(), excludedId.getParams()));
                continue;
            }
            resolvedIds = CollectionUtils.add(resolvedIds, resolvedSpec.resolveFeatureId(excludedId.getParams()));
        }
        return resolvedIds;
    }

    private Set<ResolvedSpecId> resolveSpecIds(Set<ResolvedSpecId> resolvedIds, Set<SpecId> specs) throws ProvisioningException {
        for (SpecId specId : specs) {
            resolvedIds = CollectionUtils.add(resolvedIds, this.getFeatureSpec((String)specId.getName()).id);
        }
        return resolvedIds;
    }

    private void processConfigItemContainer(ConfigItemContainer ciContainer) throws ProvisioningException {
        if (!ciContainer.hasItems()) {
            return;
        }
        FeaturePackRuntimeBuilder prevFpOrigin = ciContainer.isResetFeaturePackOrigin() ? this.setThisOrigin(this.currentOrigin) : null;
        for (ConfigItem item : ciContainer.getItems()) {
            FeaturePackRuntimeBuilder originalFp = this.setOrigin(item.getOrigin());
            try {
                if (item.isGroup()) {
                    FeatureGroup nestedFg = (FeatureGroup)item;
                    this.processFeatureGroup(nestedFg);
                    continue;
                }
                this.resolveFeature(this.configStack, (FeatureConfig)item);
            }
            catch (ProvisioningException e) {
                if (this.currentOrigin == null) {
                    throw e;
                }
                throw new ProvisioningException(item.isGroup() ? Errors.failedToProcess(this.currentOrigin.producer.getLocation().getFPID(), ((FeatureGroup)item).getName()) : Errors.failedToProcess(this.currentOrigin.producer.getLocation().getFPID(), (FeatureConfig)item), e);
            }
            finally {
                this.setOrigin(originalFp);
            }
        }
        if (prevFpOrigin != null) {
            this.setThisOrigin(prevFpOrigin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveFeature(ConfigModelStack configStack, FeatureConfig fc) throws ProvisioningException {
        FeaturePackRuntimeBuilder originalOrigin = this.currentOrigin;
        ResolvedFeatureSpec spec = this.getFeatureSpec(fc.getSpecId().getName(), true);
        ResolvedFeature originalParent = this.parentFeature;
        try {
            ResolvedFeatureId resolvedId;
            ResolvedFeatureId resolvedFeatureId = resolvedId = this.parentFeature == null ? spec.resolveFeatureId(fc.getParams()) : spec.resolveIdFromForeignKey(this.parentFeature.id, fc.getParentRef(), fc.getParams());
            if (configStack.isFilteredOut(spec.id, resolvedId)) {
                return;
            }
            this.parentFeature = this.resolveFeatureDepsAndRefs(configStack, spec, resolvedId, spec.resolveNonIdParams(this.parentFeature == null ? null : this.parentFeature.id, fc.getParentRef(), fc.getParams()), fc.getFeatureDeps());
            if (fc.hasUnsetParams()) {
                this.parentFeature.unsetAllParams(fc.getUnsetParams(), true);
            }
            if (fc.hasResetParams()) {
                this.parentFeature.resetAllParams(fc.getResetParams());
            }
        }
        finally {
            this.currentOrigin = originalOrigin;
        }
        this.processConfigItemContainer(fc);
        this.parentFeature = originalParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolvedFeature resolveFeatureDepsAndRefs(ConfigModelStack configStack, ResolvedFeatureSpec spec, ResolvedFeatureId resolvedId, Map<String, Object> resolvedParams, Collection<FeatureDependencySpec> featureDeps) throws ProvisioningException {
        if (spec.xmlSpec.hasPackageDeps()) {
            this.processPackageDeps(spec.xmlSpec);
        }
        ResolvedFeature resolvedFeature = configStack.includeFeature(resolvedId, spec, resolvedParams, this.resolveFeatureDeps(configStack, featureDeps, spec));
        if (spec.xmlSpec.hasFeatureRefs()) {
            ResolvedFeature myParent = this.parentFeature;
            this.parentFeature = resolvedFeature;
            for (FeatureReferenceSpec refSpec : spec.xmlSpec.getFeatureRefs()) {
                if (!refSpec.isInclude()) continue;
                FeaturePackRuntimeBuilder originalFp = this.setOrigin(refSpec.getOrigin());
                try {
                    ResolvedFeatureSpec refResolvedSpec = this.getFeatureSpec(refSpec.getFeature().getName());
                    List<ResolvedFeatureId> refIds = spec.resolveRefId(this.parentFeature, refSpec, refResolvedSpec);
                    if (refIds.isEmpty()) continue;
                    for (ResolvedFeatureId refId : refIds) {
                        if (configStack.includes(refId) || configStack.isFilteredOut(refId.specId, refId)) continue;
                        this.resolveFeatureDepsAndRefs(configStack, refResolvedSpec, refId, Collections.emptyMap(), Collections.emptyList());
                    }
                }
                finally {
                    this.setOrigin(originalFp);
                }
            }
            this.parentFeature = myParent;
        }
        return resolvedFeature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ResolvedFeatureId, FeatureDependencySpec> resolveFeatureDeps(ConfigModelStack configStack, Collection<FeatureDependencySpec> featureDeps, ResolvedFeatureSpec spec) throws ProvisioningException {
        Map<ResolvedFeatureId, FeatureDependencySpec> resolvedDeps = spec.resolveFeatureDeps(this, featureDeps);
        if (!resolvedDeps.isEmpty()) {
            for (Map.Entry<ResolvedFeatureId, FeatureDependencySpec> dep : resolvedDeps.entrySet()) {
                ResolvedFeatureId depId;
                if (!dep.getValue().isInclude() || configStack.includes(depId = dep.getKey()) || configStack.isFilteredOut(depId.specId, depId)) continue;
                FeatureDependencySpec depSpec = dep.getValue();
                FeaturePackRuntimeBuilder originalFp = this.setOrigin(depSpec.getOrigin());
                try {
                    this.resolveFeatureDepsAndRefs(configStack, this.getFeatureSpec(depId.getSpecId().getName()), depId, Collections.emptyMap(), Collections.emptyList());
                }
                finally {
                    this.setOrigin(originalFp);
                }
            }
        }
        return resolvedDeps;
    }

    FeaturePackRuntimeBuilder getFpBuilder(FeaturePackLocation.ProducerSpec producer) throws ProvisioningException {
        return this.layout.getFeaturePack(producer);
    }

    private void resolvePackage(String pkgName) throws ProvisioningException {
        if (!this.resolvePackage(this.currentOrigin, pkgName, Collections.emptySet())) {
            throw new ProvisioningDescriptionException(Errors.packageNotFound(this.currentOrigin.producer.getLocation().getFPID(), pkgName));
        }
    }

    private boolean resolvePackage(FeaturePackRuntimeBuilder origin, String name, Set<FeaturePackLocation.ProducerSpec> visited) throws ProvisioningException {
        FeaturePackDepsConfig fpDeps;
        if (origin != null) {
            if (origin.resolvePackage(name, this)) {
                return true;
            }
            fpDeps = origin.spec;
            visited = CollectionUtils.add(visited, origin.producer);
        } else {
            fpDeps = this.config;
        }
        if (!fpDeps.hasFeaturePackDeps()) {
            return false;
        }
        for (FeaturePackConfig fpDep : fpDeps.getFeaturePackDeps()) {
            if (visited.contains(fpDep.getLocation().getProducer()) || !this.resolvePackage(this.getFpBuilder(fpDep.getLocation().getProducer()), name, visited)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPackageDeps(PackageDepsSpec pkgDeps) throws ProvisioningException {
        if (pkgDeps.hasLocalPackageDeps()) {
            for (PackageDependencySpec dep : pkgDeps.getLocalPackageDeps()) {
                if (this.fpConfigStack.isPackageExcluded(this.currentOrigin.producer, dep.getName())) {
                    if (dep.isOptional()) continue;
                    throw new ProvisioningDescriptionException(Errors.unsatisfiedPackageDependency(this.currentOrigin.producer.getLocation().getFPID(), dep.getName()));
                }
                try {
                    this.resolvePackage(dep.getName());
                }
                catch (ProvisioningDescriptionException e) {
                    if (dep.isOptional()) continue;
                    throw e;
                }
            }
        }
        if (!pkgDeps.hasExternalPackageDeps()) {
            return;
        }
        for (String origin : pkgDeps.getPackageOrigins()) {
            FeaturePackRuntimeBuilder originalFp = this.setOrigin(origin);
            try {
                for (PackageDependencySpec pkgDep : pkgDeps.getExternalPackageDeps(origin)) {
                    if (this.fpConfigStack.isPackageExcluded(this.currentOrigin.producer, pkgDep.getName())) {
                        if (pkgDep.isOptional()) continue;
                        throw new ProvisioningDescriptionException(Errors.unsatisfiedPackageDependency(this.currentOrigin.producer.getLocation().getFPID(), pkgDep.getName()));
                    }
                    try {
                        this.resolvePackage(pkgDep.getName());
                    }
                    catch (ProvisioningDescriptionException e) {
                        if (pkgDep.isOptional()) continue;
                        throw e;
                    }
                }
            }
            finally {
                this.setOrigin(originalFp);
            }
        }
    }

    List<ProvisionedConfig> getResolvedConfigs() throws ProvisioningException {
        int configsTotal = this.anonymousConfigs.size() + this.nameOnlyConfigs.size() + this.namedModelConfigs.size();
        if (configsTotal == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProvisionedConfig> configList = new ArrayList<ProvisionedConfig>(configsTotal);
        if (!this.anonymousConfigs.isEmpty()) {
            for (ConfigModelStack configModelStack : this.anonymousConfigs) {
                this.orderConfig(configModelStack, configList, Collections.emptySet());
            }
        }
        if (!this.nameOnlyConfigs.isEmpty()) {
            for (ConfigModelStack configModelStack : this.nameOnlyConfigs.values()) {
                if (this.contains(configList, configModelStack.id)) continue;
                this.orderConfig(configModelStack, configList, Collections.emptySet());
            }
        }
        if (!this.namedModelConfigs.isEmpty()) {
            for (Map.Entry entry : this.namedModelConfigs.entrySet()) {
                for (ConfigModelStack config : ((Map)entry.getValue()).values()) {
                    if (this.contains(configList, config.id)) continue;
                    this.orderConfig(config, configList, Collections.emptySet());
                }
            }
        }
        return configList.size() > 0 ? Collections.unmodifiableList(configList) : configList;
    }

    private void orderConfig(ConfigModelStack config, List<ProvisionedConfig> configList, Set<ConfigId> scheduledIds) throws ProvisioningException {
        if (!config.hasConfigDeps()) {
            configList.add(ResolvedConfig.build(config));
            return;
        }
        if (!config.id.isAnonymous()) {
            scheduledIds = CollectionUtils.add(scheduledIds, config.id);
        }
        for (ConfigId depId : config.getConfigDeps().values()) {
            ConfigModelStack configStack;
            if (scheduledIds.contains(depId) || this.contains(configList, depId)) continue;
            if (depId.isModelOnly()) {
                Map<String, ConfigModelStack> configs = this.namedModelConfigs.get(depId.getModel());
                if (configs == null) {
                    throw new ProvisioningDescriptionException("Config " + config.id + " has unsatisfied dependency on config " + depId);
                }
                for (ConfigModelStack dep : configs.values()) {
                    if (this.contains(configList, dep.id)) continue;
                    this.orderConfig(dep, configList, scheduledIds);
                }
                continue;
            }
            if (depId.getModel() == null) {
                configStack = this.nameOnlyConfigs.get(depId.getName());
            } else {
                Map<String, ConfigModelStack> configs = this.namedModelConfigs.get(depId.getModel());
                if (configs == null) {
                    throw new ProvisioningDescriptionException("Config " + config.id + " has unsatisfied dependency on config " + depId);
                }
                configStack = configs.get(depId.getName());
            }
            if (configStack == null) {
                throw new ProvisioningDescriptionException("Config " + config.id + " has unsatisfied dependency on config " + depId);
            }
            if (this.contains(configList, configStack.id)) continue;
            this.orderConfig(configStack, configList, scheduledIds);
        }
        scheduledIds = CollectionUtils.remove(scheduledIds, config.id);
        configList.add(ResolvedConfig.build(config));
    }

    private boolean contains(List<ProvisionedConfig> configList, ConfigId depId) {
        int i = 0;
        while (i < configList.size()) {
            if (!((ResolvedConfig)configList.get((int)i++)).id.equals(depId)) continue;
            return true;
        }
        return false;
    }

    public ProvisioningRuntimeBuilder setOption(String name, String param) {
        this.pluginOptions = CollectionUtils.put(this.pluginOptions, name, param);
        return this;
    }

    public ProvisioningRuntimeBuilder addOptions(Map<String, String> options) {
        this.pluginOptions = CollectionUtils.putAll(this.pluginOptions, options);
        return this;
    }

    private FeatureGroup getFeatureGroupSpec(String name) throws ProvisioningException {
        FeatureGroup fg = this.getFeatureGroupSpec(this.currentOrigin, name, Collections.emptySet());
        if (fg == null) {
            throw new ProvisioningDescriptionException("Failed to locate feature group '" + name + "' in " + (this.currentOrigin == null ? "the provisioning configuration" : this.currentOrigin.producer + " and its dependencies"));
        }
        return fg;
    }

    private FeatureGroup getFeatureGroupSpec(FeaturePackRuntimeBuilder origin, String name, Set<FeaturePackLocation.ProducerSpec> visitedProducers) throws ProvisioningException {
        FeaturePackDepsConfig fpDeps;
        if (origin != null) {
            FeatureGroup fg = origin.getFeatureGroupSpec(name);
            if (fg != null) {
                this.currentOrigin = origin;
                return fg;
            }
            fpDeps = origin.spec;
            visitedProducers = CollectionUtils.add(visitedProducers, origin.producer);
        } else {
            fpDeps = this.config;
        }
        if (!fpDeps.hasFeaturePackDeps()) {
            return null;
        }
        for (FeaturePackConfig fpDep : fpDeps.getFeaturePackDeps()) {
            FeatureGroup fg;
            if (visitedProducers.contains(fpDep.getLocation().getProducer()) || (fg = this.getFeatureGroupSpec(this.getFpBuilder(fpDep.getLocation().getProducer()), name, visitedProducers)) == null) continue;
            return fg;
        }
        return null;
    }

    private ResolvedFeatureSpec getFeatureSpec(String name) throws ProvisioningException {
        return this.getFeatureSpec(name, false);
    }

    private ResolvedFeatureSpec getFeatureSpec(String name, boolean switchOrigin) throws ProvisioningException {
        return this.getFeatureSpec(this.currentOrigin, name, switchOrigin);
    }

    ResolvedFeatureSpec getFeatureSpec(FeaturePackRuntimeBuilder origin, String name) throws ProvisioningException {
        return this.getFeatureSpec(origin, name, false);
    }

    private ResolvedFeatureSpec getFeatureSpec(FeaturePackRuntimeBuilder origin, String name, boolean switchOrigin) throws ProvisioningException {
        ResolvedFeatureSpec resolvedSpec = this.getFeatureSpec(origin, name, Collections.emptySet(), switchOrigin);
        if (resolvedSpec == null) {
            if (origin == null) {
                throw new ProvisioningDescriptionException("Failed to locate feature spec '" + name + "' in the installed feature-packs.");
            }
            throw new ProvisioningDescriptionException("Failed to locate feature spec '" + name + "' in " + origin.producer + " and its dependencies.");
        }
        return resolvedSpec;
    }

    private ResolvedFeatureSpec getFeatureSpec(FeaturePackRuntimeBuilder origin, String name, Set<FeaturePackLocation.ProducerSpec> visitedProducers, boolean switchOrigin) throws ProvisioningException {
        FeaturePackDepsConfig fpDeps;
        if (origin != null) {
            ResolvedFeatureSpec fs = origin.getFeatureSpec(name);
            if (fs != null) {
                if (switchOrigin) {
                    this.currentOrigin = origin;
                }
                return fs;
            }
            fpDeps = origin.spec;
            visitedProducers = CollectionUtils.add(visitedProducers, origin.producer);
        } else {
            fpDeps = this.config;
        }
        if (!fpDeps.hasFeaturePackDeps()) {
            return null;
        }
        for (FeaturePackConfig fpDep : fpDeps.getFeaturePackDeps()) {
            ResolvedFeatureSpec fs;
            FeaturePackLocation fpl = fpDep.getLocation();
            if (visitedProducers.contains(fpl.getProducer()) || (fs = this.getFeatureSpec(this.getFpBuilder(fpl.getProducer()), name, visitedProducers, switchOrigin)) == null) continue;
            return fs;
        }
        return null;
    }
}

