/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.galleon1;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Producer;
import org.jboss.galleon.util.CollectionUtils;

public class LegacyGalleon1Universe
implements Universe<LegacyGalleon1Producer> {
    private static final String ZIP = "zip";
    private static UniverseSpec universeSource;
    final RepositoryArtifactResolver artifactResolver;
    private Map<String, LegacyGalleon1Producer> producers = Collections.emptyMap();

    public static UniverseSpec getUniverseSpec() {
        if (universeSource == null) {
            universeSource = new UniverseSpec("galleon1", null);
        }
        return universeSource;
    }

    public static ArtifactCoords toArtifactCoords(FeaturePackLocation fpl) throws ProvisioningException {
        String producer = fpl.getProducerName();
        int colon = producer.indexOf(58);
        if (colon <= 0) {
            throw new ProvisioningException("Failed to determine group and artifact IDs for " + fpl);
        }
        return ArtifactCoords.newInstance(producer.substring(0, colon), producer.substring(colon + 1), fpl.getBuild(), ZIP);
    }

    public static FeaturePackLocation toFpl(ArtifactCoords.Gav gav) {
        String version = gav.getVersion();
        if (version == null) {
            return new FeaturePackLocation(new UniverseSpec("galleon1", null), gav.getGroupId() + ':' + gav.getArtifactId(), null, null, version);
        }
        int i = version.indexOf(46);
        return new FeaturePackLocation(new UniverseSpec("galleon1", null), gav.getGroupId() + ':' + gav.getArtifactId(), i > 0 ? version.substring(0, i) : version, null, version);
    }

    public static FeaturePackLocation.FPID newFPID(String producer, String channel, String build) {
        return new FeaturePackLocation(LegacyGalleon1Universe.getUniverseSpec(), producer, channel, null, build).getFPID();
    }

    public static FeaturePackLocation.ProducerSpec newProducer(String producer) {
        return new FeaturePackLocation(new UniverseSpec("galleon1", null), producer, null, null, null).getProducer();
    }

    public LegacyGalleon1Universe(RepositoryArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    @Override
    public String getFactoryId() {
        return "galleon1";
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public boolean hasProducer(String producerName) throws ProvisioningException {
        return true;
    }

    @Override
    public LegacyGalleon1Producer getProducer(String producerName) throws ProvisioningException {
        LegacyGalleon1Producer producer = this.producers.get(producerName);
        if (producer == null) {
            producer = new LegacyGalleon1Producer(this, producerName);
            this.producers = CollectionUtils.put(this.producers, producerName, producer);
        }
        return producer;
    }

    @Override
    public Collection<LegacyGalleon1Producer> getProducers() throws ProvisioningException {
        return this.producers.values();
    }
}

