/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ProvisionedStateXmlParser20;
import org.jboss.galleon.xml.util.ElementNode;

public class ProvisionedConfigXmlWriter
extends BaseXmlWriter<ProvisionedConfig> {
    private static final ProvisionedConfigXmlWriter INSTANCE = new ProvisionedConfigXmlWriter();

    public static ProvisionedConfigXmlWriter getInstance() {
        return INSTANCE;
    }

    private ProvisionedConfigXmlWriter() {
    }

    @Override
    protected ElementNode toElement(ProvisionedConfig config) throws XMLStreamException {
        ElementNode configE = ProvisionedConfigXmlWriter.addElement(null, ProvisionedStateXmlParser20.Element.CONFIG);
        if (config.getName() != null) {
            ProvisionedConfigXmlWriter.addAttribute(configE, ProvisionedStateXmlParser20.Attribute.NAME, config.getName());
        }
        if (config.getModel() != null) {
            ProvisionedConfigXmlWriter.addAttribute(configE, ProvisionedStateXmlParser20.Attribute.MODEL, config.getModel());
        }
        if (config.hasProperties()) {
            ElementNode propsE = ProvisionedConfigXmlWriter.addElement(configE, ProvisionedStateXmlParser20.Element.PROPS);
            for (Map.Entry<String, String> entry : config.getProperties().entrySet()) {
                ElementNode propE = ProvisionedConfigXmlWriter.addElement(propsE, ProvisionedStateXmlParser20.Element.PROP);
                ProvisionedConfigXmlWriter.addAttribute(propE, ProvisionedStateXmlParser20.Attribute.NAME, entry.getKey());
                ProvisionedConfigXmlWriter.addAttribute(propE, ProvisionedStateXmlParser20.Attribute.VALUE, entry.getValue());
            }
        }
        if (config.hasFeatures()) {
            try {
                config.handle(new XmlConfigHandler(configE));
            }
            catch (ProvisioningException e) {
                throw new XMLStreamException("Failed to marshal ProvisionedConfig", e);
            }
        }
        return configE;
    }

    private static class XmlConfigHandler
    implements ProvisionedConfigHandler {
        private final ElementNode parent;
        private ElementNode fpElement;
        private ElementNode specElement;

        XmlConfigHandler(ElementNode parent) {
            this.parent = parent;
        }

        @Override
        public void nextFeaturePack(FeaturePackLocation.FPID fpid) {
            this.fpElement = BaseXmlWriter.addElement(this.parent, ProvisionedStateXmlParser20.Element.FEATURE_PACK);
            BaseXmlWriter.addAttribute(this.fpElement, ProvisionedStateXmlParser20.Attribute.LOCATION, fpid.toString());
        }

        @Override
        public void nextSpec(ResolvedFeatureSpec spec) {
            this.specElement = BaseXmlWriter.addElement(this.fpElement, ProvisionedStateXmlParser20.Element.SPEC);
            BaseXmlWriter.addAttribute(this.specElement, ProvisionedStateXmlParser20.Attribute.NAME, spec.getId().getName());
        }

        @Override
        public void nextFeature(ProvisionedFeature feature) throws ProvisioningException {
            ElementNode featureE = BaseXmlWriter.addElement(this.specElement, ProvisionedStateXmlParser20.Element.FEATURE);
            if (feature.hasId()) {
                BaseXmlWriter.addAttribute(featureE, ProvisionedStateXmlParser20.Attribute.ID, feature.getId().toString());
            }
            if (feature.hasParams()) {
                for (String param : feature.getParamNames()) {
                    ElementNode paramE = BaseXmlWriter.addElement(featureE, ProvisionedStateXmlParser20.Element.PARAM);
                    BaseXmlWriter.addAttribute(paramE, ProvisionedStateXmlParser20.Attribute.NAME, param);
                    BaseXmlWriter.addAttribute(paramE, ProvisionedStateXmlParser20.Attribute.VALUE, feature.getConfigParam(param));
                }
            }
        }
    }
}

