/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.state.FeaturePack;
import org.jboss.galleon.state.FeaturePackPackage;
import org.jboss.galleon.state.FeaturePackSet;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ProvisionedConfigXmlWriter;
import org.jboss.galleon.xml.ProvisionedStateXmlParser20;
import org.jboss.galleon.xml.util.ElementNode;

public class ProvisionedStateXmlWriter
extends BaseXmlWriter<FeaturePackSet<?>> {
    private static final ProvisionedStateXmlWriter INSTANCE = new ProvisionedStateXmlWriter();

    public static ProvisionedStateXmlWriter getInstance() {
        return INSTANCE;
    }

    private ProvisionedStateXmlWriter() {
    }

    @Override
    protected ElementNode toElement(FeaturePackSet<?> provisionedState) throws XMLStreamException {
        ElementNode pkg = ProvisionedStateXmlWriter.addElement(null, ProvisionedStateXmlParser20.Element.INSTALLATION);
        if (provisionedState.hasFeaturePacks()) {
            for (FeaturePack fp : provisionedState.getFeaturePacks()) {
                ElementNode fpElement = ProvisionedStateXmlWriter.addElement(pkg, ProvisionedStateXmlParser20.Element.FEATURE_PACK);
                this.writeFeaturePack(fpElement, fp);
            }
        }
        if (provisionedState.hasConfigs()) {
            for (ProvisionedConfig config : provisionedState.getConfigs()) {
                pkg.addChild(ProvisionedConfigXmlWriter.getInstance().toElement(config));
            }
        }
        return pkg;
    }

    private void writeFeaturePack(ElementNode fp, FeaturePack<?> featurePack) {
        ProvisionedStateXmlWriter.addAttribute(fp, ProvisionedStateXmlParser20.Attribute.LOCATION, featurePack.getFPID().toString());
        if (featurePack.hasPackages()) {
            ElementNode packages = ProvisionedStateXmlWriter.addElement(fp, ProvisionedStateXmlParser20.Element.PACKAGES);
            for (FeaturePackPackage pkg : featurePack.getPackages()) {
                ElementNode pkgElement = ProvisionedStateXmlWriter.addElement(packages, ProvisionedStateXmlParser20.Element.PACKAGE);
                ProvisionedStateXmlWriter.addAttribute(pkgElement, ProvisionedStateXmlParser20.Attribute.NAME, pkg.getName());
            }
        }
    }
}

