/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.xml.XmlParser;
import org.jboss.galleon.xml.XmlParsers;

public class ProvisioningXmlParser
implements XmlParser<ProvisioningConfig> {
    private static final ProvisioningXmlParser INSTANCE = new ProvisioningXmlParser();

    public static ProvisioningXmlParser getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProvisioningConfig parse(Path path) throws ProvisioningException {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            ProvisioningConfig provisioningConfig = ProvisioningXmlParser.getInstance().parse(reader);
            return provisioningConfig;
        }
        catch (IOException | XMLStreamException e) {
            throw new ProvisioningException(Errors.parseXml(path), e);
        }
    }

    private ProvisioningXmlParser() {
    }

    @Override
    public ProvisioningConfig parse(Reader input) throws XMLStreamException {
        ProvisioningConfig.Builder builder = ProvisioningConfig.builder();
        XmlParsers.parse(input, builder);
        try {
            return builder.build();
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException("Failed to build provisioning configuration", e);
        }
    }
}

