/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseFeaturePackInstaller;
import org.jboss.galleon.util.StringUtils;

public interface Errors {
    public static String pathDoesNotExist(Path p) {
        return "Failed to locate " + p.toAbsolutePath();
    }

    public static String pathAlreadyExists(Path p) {
        return "Path already exists " + p.toAbsolutePath();
    }

    public static String mkdirs(Path p) {
        return "Failed to make directories " + p.toAbsolutePath();
    }

    public static String readDirectory(Path p) {
        return "Failed to read directory " + p.toAbsolutePath();
    }

    public static String notADir(Path p) {
        return p.toAbsolutePath() + " is not a directory";
    }

    public static String copyFile(Path src, Path target) {
        return "Failed to copy " + src + " to " + target;
    }

    public static String deletePath(Path src) {
        return "Failed to delete " + src;
    }

    public static String moveFile(Path src, Path target) {
        return "Failed to move " + src.toAbsolutePath() + " to " + target.toAbsolutePath();
    }

    public static String openFile(Path p) {
        return "Failed to open " + p.toAbsolutePath();
    }

    public static String readFile(Path p) {
        return "Failed to read " + p.toAbsolutePath();
    }

    public static String parseXml() {
        return "Failed to parse XML";
    }

    public static String parseXml(Path p) {
        return "Failed to parse " + p.toAbsolutePath();
    }

    public static String writeFile(Path p) {
        return "Failed to write to " + p.toAbsolutePath();
    }

    public static String deleteFile(Path p) {
        return "Failed to delete " + p.toAbsolutePath();
    }

    public static String hashCalculation(Path path) {
        return "Hash calculation failed for " + path;
    }

    public static String homeDirNotUsable(Path p) {
        return p + " has to be empty or contain a provisioned installation to be used by the tool";
    }

    public static String fpVersionCheckFailed(Collection<Set<FeaturePackLocation.FPID>> versionConflicts) throws ProvisioningException {
        StringWriter strWriter = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(strWriter);){
            writer.write("Feature-pack versions check failed with the following errors:");
            writer.newLine();
            if (!versionConflicts.isEmpty()) {
                for (Collection collection : versionConflicts) {
                    writer.write(" * ");
                    writer.write(Errors.featurePackVersionConflict(collection));
                    writer.write(59);
                    writer.newLine();
                }
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to report version check errors", e);
        }
        return strWriter.toString();
    }

    public static String failedToResolveReleaseVersions(Collection<FeaturePackLocation.ProducerSpec> channels) {
        StringBuilder buf = new StringBuilder("Missing build number");
        if (channels.size() > 1) {
            buf.append('s');
        }
        buf.append(" for ");
        StringUtils.append(buf, channels);
        return buf.toString();
    }

    public static String packageContentCopyFailed(String packageName) {
        return "Failed to copy package " + packageName + " content";
    }

    public static String packageNotFound(FeaturePackLocation.FPID fpid, String packageName) {
        return "Failed to resolve package " + packageName + " in " + fpid;
    }

    public static String unknownPackage(FeaturePackLocation.FPID fpid, String pkgName) {
        return "Package " + pkgName + " is not found in " + fpid;
    }

    public static String unknownFeaturePack(FeaturePackLocation.FPID fpid) {
        return "Feature-pack " + fpid + " not found in the configuration";
    }

    public static String unsatisfiedFeaturePackDep(FeaturePackLocation.ProducerSpec producer) {
        return "Feature-pack " + producer + " is a required dependency";
    }

    public static String featurePackVersionConflict(FeaturePackLocation.FPID fpid1, FeaturePackLocation.FPID fpid2) {
        LinkedHashSet<FeaturePackLocation.FPID> fpids = new LinkedHashSet<FeaturePackLocation.FPID>(2);
        fpids.add(fpid1);
        fpids.add(fpid2);
        return Errors.featurePackVersionConflict(fpids);
    }

    public static String featurePackVersionConflict(Collection<FeaturePackLocation.FPID> fpids) {
        Iterator<FeaturePackLocation.FPID> i = fpids.iterator();
        FeaturePackLocation.FPID fpid = i.next();
        StringBuilder buf = new StringBuilder("Please pick the desired channel and/or build for ").append(fpid.getProducer()).append(" explicitly in the provisioning config. Current configuration includes ").append(fpid);
        while (i.hasNext()) {
            fpid = i.next();
            buf.append(", ").append(fpid);
        }
        return buf.toString();
    }

    public static String unsatisfiedPackageDependencies(FeaturePackLocation.FPID fpid, String packageName, Collection<String> unsatisfiedDeps) {
        StringBuilder buf = new StringBuilder();
        buf.append("Feature-pack ").append(fpid).append(" package ").append(packageName).append(" has unsatisfied dependencies on packages: ");
        StringUtils.append(buf, unsatisfiedDeps);
        return buf.toString();
    }

    public static String unsatisfiedPackageDependency(FeaturePackLocation.FPID fpid, String targetPackage) {
        return "Unsatisfied dependency on feature-pack " + fpid + " package " + targetPackage;
    }

    public static String resolvePackage(FeaturePackLocation.FPID fpid, String packageName) {
        return "Failed to resolve feature-pack " + fpid + " package " + packageName;
    }

    public static String packageExcludeInclude(String packageName) {
        return "Attempt to explicitly include and exclude package " + packageName;
    }

    public static String duplicateDependencyName(String name) {
        return "Dependency with name " + name + " already exists";
    }

    public static String unknownFeaturePackDependencyName(String depName) {
        return depName + " was not found among the feature-pack dependencies";
    }

    public static String featurePackAlreadyConfigured(FeaturePackLocation.ProducerSpec producer) {
        return "Feature-pack " + producer + " already present in the configuration";
    }

    public static String unknownFeaturePackDependencyName(FeaturePackLocation.FPID fpid, String pkgName, String depName) {
        return fpid + " package " + pkgName + " references unknown feature-pack dependency " + depName;
    }

    public static String noCapabilityProvider(String capability) {
        return "No provider found for capability '" + capability + "'";
    }

    public static String noCapabilityProvider(ResolvedFeature feature, CapabilitySpec capSpec, String resolvedCap) {
        StringBuilder buf = new StringBuilder();
        buf.append("No provider found for capability ").append(resolvedCap);
        buf.append(" required by ");
        if (feature.hasId()) {
            buf.append(feature.getId());
        } else {
            buf.append(" an instance of ").append(feature.getSpecId());
        }
        if (!capSpec.isStatic()) {
            buf.append(" as ").append(capSpec.toString());
        }
        return buf.toString();
    }

    public static String capabilityMissingParameter(CapabilitySpec cap, String param) {
        return "Parameter " + param + " is missing value to resolve capability " + cap;
    }

    public static String illegalCapabilityElement(CapabilitySpec cap, String resolvedPart, String elem) {
        return "Failed to resolve capability " + cap + " with illegal element value of '" + elem + "' at " + resolvedPart;
    }

    public static String failedToResolveCapability(ResolvedFeature feature, CapabilitySpec cap) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to resolve capability ").append(cap).append(" for ");
        Errors.appendFeature(buf, feature);
        return buf.toString();
    }

    public static String failedToResolveParameter(ResolvedSpecId specId, String name) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to resolve ").append(specId).append(" parameter ").append(name);
        return buf.toString();
    }

    public static String failedToResolveParameter(ResolvedSpecId specId, String name, String value) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to resolve ").append(specId).append(" parameter ").append(name).append(" value ").append(value);
        return buf.toString();
    }

    public static String failedToResolveFeatureReference(FeatureReferenceSpec refSpec, ResolvedSpecId spec) {
        return "Failed to resolve feature reference " + refSpec.getName() + " for " + spec;
    }

    public static String failedToResolveConfigSpec(String model, String name) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to resolve configuration ");
        Errors.appendConfig(buf, model, name);
        return buf.toString();
    }

    public static String failedToResolveConfigLayer(String model, String name) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to resolve configuration layer ");
        Errors.appendConfig(buf, model, name);
        return buf.toString();
    }

    public static String failedToBuildConfigSpec(String model, String name) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to build configuration ");
        Errors.appendConfig(buf, model, name);
        return buf.toString();
    }

    public static String failedToInitializeForeignKeyParams(ResolvedSpecId specId, ResolvedFeatureId parentId, Map<String, ?> params) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to initialize the foreign key parameters for the feature ").append(specId).append(" with parameters ");
        StringUtils.append(buf, params.entrySet());
        buf.append(" referencing ID ").append(parentId);
        return buf.toString();
    }

    public static String idParamForeignKeyInitConflict(ResolvedSpecId specId, String param, Object prevValue, Object newValue) {
        return "Value '" + prevValue + "' of ID parameter " + param + " of " + specId + " conflicts with the corresponding parent ID value '" + newValue + "'";
    }

    public static String nonExistingForeignKeyTarget(String localParam, String refName, ResolvedSpecId specId, String targetParam, ResolvedSpecId targetSpecId) {
        return "Foreign key parameter " + localParam + " of " + specId + " reference " + refName + " is mapped to a non-existing ID parameter " + targetParam + " of " + targetSpecId;
    }

    public static String nonExistingForeignKeyParam(String refName, ResolvedSpecId specId, String targetParam) {
        return "Foreign key parameter " + targetParam + " of " + specId + " reference " + refName + " does not exist";
    }

    public static String featureRefNotInSpec(String featureRefName, String featureSpec) {
        return "Feature spec " + featureSpec + " does not include a feature reference named " + featureRefName;
    }

    public static String nonNillableRefIsNull(ResolvedFeature feature, String refName) {
        StringBuilder buf = new StringBuilder();
        buf.append("Reference ").append(refName).append(" of ");
        Errors.appendFeature(buf, feature);
        return buf.append(" cannot be null").toString();
    }

    public static String unresolvedFeatureDep(ResolvedFeature feature, ResolvedFeatureId dep) {
        StringBuilder buf = new StringBuilder();
        Errors.appendFeature(buf, feature);
        buf.append(" has unresolved dependency on ").append(dep);
        return buf.toString();
    }

    public static String nonNillableParameterIsNull(ResolvedFeature feature, String paramName) {
        if (feature.hasId()) {
            return Errors.nonNillableParameterIsNull(feature.getId(), paramName);
        }
        return Errors.nonNillableParameterIsNull(feature.getSpecId(), paramName);
    }

    public static String nonNillableParameterIsNull(ResolvedSpecId specId, String paramName) {
        return "Non-nillable parameter " + paramName + " of " + specId + " has not been initialized";
    }

    public static String nonNillableParameterIsNull(ResolvedFeatureId featureId, String paramName) {
        return "Non-nillable parameter " + paramName + " of " + featureId + " has not been initialized";
    }

    public static String featureNotInScope(ResolvedFeatureId id, String groupName, FeaturePackLocation.FPID fpid) {
        StringBuilder buf = new StringBuilder();
        buf.append(id).append(" cannot be included into group ").append(groupName);
        if (fpid != null) {
            buf.append(" from ").append(fpid);
        }
        buf.append(" as it's not in the scope of the group");
        return buf.toString();
    }

    public static String unknownFeatureParameter(ResolvedSpecId specId, String paramName) {
        return "Feature spec " + specId + " does not contain parameter '" + paramName;
    }

    public static String featureIdParameterCantBeUnset(ResolvedFeatureId id, String paramName) {
        return "Parameter " + paramName + " of " + id + " cannot be unset";
    }

    public static String featureIdParameterCantBeReset(ResolvedFeatureId id, String paramName) {
        return "Parameter " + paramName + " of " + id + " cannot be reset";
    }

    public static String unknownFeatureParameter(String featureSpec, String paramName) {
        StringBuilder buf = new StringBuilder();
        buf.append("Feature spec ").append(featureSpec).append(" does not define parameter ").append(paramName);
        return buf.toString();
    }

    public static String failedToProcess(FeaturePackLocation.FPID fpid, FeatureConfig feature) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to process feature-pack ").append(fpid).append(" feature ").append(feature);
        return buf.toString();
    }

    public static String failedToProcess(FeaturePackLocation.FPID fpid, String groupName) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to process feature-pack ").append(fpid).append(" group ").append(groupName);
        return buf.toString();
    }

    public static String frequencyNotSupported(Collection<String> frequencies, FeaturePackLocation fpl) {
        StringBuilder buf = new StringBuilder();
        buf.append("The frequency specified in ").append(fpl).append(" is not supported, the producer ");
        if (frequencies.isEmpty()) {
            buf.append(" does not suport frequencies");
        } else {
            buf.append("supported frequencies are ");
            Object[] arr = frequencies.toArray(new String[frequencies.size()]);
            Arrays.sort(arr);
            StringUtils.append(buf, Arrays.asList(arr));
        }
        return buf.toString();
    }

    public static String transitiveDependencyNotFound(FeaturePackLocation.ProducerSpec ... producer) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to locate ");
        StringUtils.append(buf, Arrays.asList(producer));
        buf.append(" among transitive dependencies");
        return buf.toString();
    }

    public static String patchAlreadyApplied(FeaturePackLocation.FPID patchId) {
        return "Patch " + patchId + " has already been applied";
    }

    public static String patchNotApplicable(FeaturePackLocation.FPID patchId, FeaturePackLocation.FPID targetFpid) {
        return "Patch " + patchId + " applies to " + targetFpid + " which is not a part of the installation";
    }

    public static String featurePackInstallerNotFound(String universeFactory, Collection<String> installers) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to locate an implementation of ").append(UniverseFeaturePackInstaller.class.getName()).append(" for universe factory ").append(universeFactory).append(" on the classpath.");
        if (!installers.isEmpty()) {
            buf.append(" Available universe factory installers include ");
            StringUtils.append(buf, installers);
        }
        return buf.toString();
    }

    public static String noVersionAvailable(FeaturePackLocation fpl) {
        return "No version is available for " + fpl;
    }

    public static String historyIsEmpty() {
        return "Provisioning history is empty";
    }

    public static String configLayerCanEitherBeIncludedOrExcluded(String configModel, String configName, String layerName) {
        return "Configuration layer " + layerName + " appears to be included and excluded in the same configuration " + (configModel == null ? configName : configModel + ':' + configName);
    }

    public static String unsatisfiedLayerDependency(String srcLayer, String targetLayer) {
        return "Required dependency of configuration layer " + srcLayer + " on layer " + targetLayer + " was excluded";
    }

    public static String fsEntryInit(Path p) {
        return "Failed to process child entries for " + p;
    }

    public static String pluginOptionRequired(String name) {
        return "Provisioning option " + name + " is required for this configuration";
    }

    public static String pluginOptionIllegalValue(String name, String setValue, Collection<String> values) {
        StringBuilder buf = new StringBuilder();
        buf.append("Provisioning option ").append(name).append(" value ").append(setValue).append(" is not in the legal value set: ");
        StringUtils.append(buf, values);
        return buf.toString();
    }

    public static String pluginOptionsNotRecognized(Collection<String> names) {
        StringBuilder buf = new StringBuilder("The following plugin options are not recognized: ");
        if (names.size() > 1) {
            ArrayList<String> list = new ArrayList<String>(names);
            Collections.sort(list);
            names = list;
        }
        StringUtils.append(buf, names);
        return buf.toString();
    }

    public static String requiredPassiveDependency(String name) {
        return "Required dependency on " + name + " cannot be passive";
    }

    public static String unexpectedPackageDependencyType(String name, int type) {
        return "Unexpected dependency type " + type + " on package " + name;
    }

    public static String hashesNotPersisted() {
        return "Failed to persist hashes";
    }

    public static String fileClose(Path p) {
        return "Failed to close file " + p;
    }

    public static String classloaderClose() {
        return "Failed to close classloader";
    }

    public static String topConfigsCantDefinePackageDeps(ConfigId configId) {
        StringBuilder buf = new StringBuilder();
        buf.append("Config models defined in provisioning configuration are not allowed to define package dependencies: ");
        buf.append(configId);
        return buf.toString();
    }

    public static String layerNotFound(ConfigId layerId) {
        return "Failed to locate layer " + layerId + " in the the installation feature-pack layout";
    }

    public static String tookTime(String action, long startTimeNanos) {
        long nanos = Math.abs(System.nanoTime() - startTimeNanos);
        long timeSec = nanos / 1000000000L;
        return action + " took " + timeSec + "." + (nanos - timeSec * 1000000000L) / 1000000L + " seconds";
    }

    public static String defaultChannelNotConfigured(String producer) {
        return "Default channel has not been configured for feature-pack producer " + producer;
    }

    public static void appendConfig(StringBuilder buf, String model, String name) {
        if (model != null) {
            buf.append(" model ").append(model);
        }
        if (name != null) {
            buf.append(" named ").append(name);
        }
    }

    public static void appendFeature(StringBuilder buf, ResolvedFeature feature) {
        if (feature.hasId()) {
            buf.append(feature.getId());
        } else {
            buf.append(feature.getSpecId()).append(" configuration");
        }
    }
}

