/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.creator.tasks;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.jboss.galleon.creator.tasks.DirCopy;
import org.jboss.galleon.creator.tasks.FsTask;
import org.jboss.galleon.creator.tasks.FsTaskContext;
import org.jboss.galleon.creator.tasks.PathCopy;
import org.jboss.galleon.creator.tasks.StringToFile;
import org.jboss.galleon.util.CollectionUtils;

public class FsTaskList
implements FsTask {
    private List<FsTask> tasks = Collections.emptyList();

    public static FsTaskList newList() {
        return new FsTaskList();
    }

    private FsTaskList() {
    }

    public FsTaskList write(String content, String relativeTarget) {
        return this.write(content, relativeTarget, true);
    }

    public FsTaskList write(String content, String relativeTarget, boolean isContent) {
        return this.add(new StringToFile(content, relativeTarget, isContent));
    }

    public FsTaskList copy(Path src, String relativeTarget) {
        return this.copy(src, relativeTarget, true);
    }

    public FsTaskList copy(Path src, String relativeTarget, boolean isContent) {
        return this.add(new PathCopy(src, relativeTarget, isContent));
    }

    public FsTaskList copyDir(Path src, String relativeTarget, boolean contentOnly) {
        return this.copyDir(src, relativeTarget, contentOnly, true);
    }

    public FsTaskList copyDir(Path src, String relativeTarget, boolean contentOnly, boolean isContent) {
        return this.add(new DirCopy(src, relativeTarget, contentOnly, isContent));
    }

    public FsTaskList add(FsTask task) {
        this.tasks = CollectionUtils.add(this.tasks, task);
        return this;
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    @Override
    public void execute(FsTaskContext ctx) throws IOException {
        for (FsTask task : this.tasks) {
            task.execute(ctx);
        }
    }

    @Override
    public boolean isContent() {
        return false;
    }
}

