/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Decoder {
    private static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
    private static final Logger LOGGER = Logger.getLogger(Decoder.class.getName());
    private CharsetDecoder decoder;
    private ByteBuffer bBuf;
    private final CharBuffer cBuf;
    private Consumer<int[]> onChar;
    private int[] leftOverCodePoints;

    public Decoder(Charset charset, Consumer<int[]> onChar) {
        this(4, charset, onChar);
    }

    public Decoder(int initialSize, Charset charset, Consumer<int[]> onChar) {
        if (initialSize < 2) {
            throw new IllegalArgumentException("Initial size must be at least 2");
        }
        this.decoder = charset != null ? charset.newDecoder() : Charset.defaultCharset().newDecoder();
        this.bBuf = EMPTY;
        this.cBuf = CharBuffer.allocate(initialSize);
        this.onChar = onChar;
    }

    public void setCharset(Charset charset) {
        this.decoder = charset.newDecoder();
    }

    public void write(byte[] data) {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int start, int len) {
        CoderResult result;
        int remaining;
        if (this.leftOverCodePoints != null && this.leftOverCodePoints.length > 0 && this.onChar != null) {
            this.onChar.accept(this.leftOverCodePoints);
            this.leftOverCodePoints = null;
        }
        if (len > (remaining = this.bBuf.remaining())) {
            ByteBuffer tmp = this.bBuf;
            int length = tmp.position() + len;
            this.bBuf = ByteBuffer.allocate(length);
            tmp.flip();
            this.bBuf.put(tmp);
        }
        this.bBuf.put(data, start, len);
        this.bBuf.flip();
        do {
            IntBuffer iBuf = IntBuffer.allocate(this.bBuf.remaining());
            result = this.decoder.decode(this.bBuf, this.cBuf, false);
            this.cBuf.flip();
            while (this.cBuf.hasRemaining()) {
                char c = this.cBuf.get();
                if (Character.isSurrogate(c)) {
                    if (Character.isHighSurrogate(c)) {
                        if (this.cBuf.hasRemaining()) {
                            char low = this.cBuf.get();
                            if (Character.isLowSurrogate(low)) {
                                int codePoint = Character.toCodePoint(c, low);
                                if (Character.isValidCodePoint(codePoint)) {
                                    iBuf.put(codePoint);
                                    continue;
                                }
                                throw new UnsupportedOperationException("Handle me gracefully");
                            }
                            throw new UnsupportedOperationException("Handle me gracefully");
                        }
                        throw new UnsupportedOperationException("Handle me gracefully");
                    }
                    throw new UnsupportedOperationException("Handle me gracefully");
                }
                iBuf.put(c);
            }
            iBuf.flip();
            int[] codePoints = new int[iBuf.limit()];
            iBuf.get(codePoints);
            if (this.onChar != null) {
                this.onChar.accept(codePoints);
            } else {
                LOGGER.log(Level.WARNING, "InputHandler is set to null, will ignore input: " + this.fromCodePoints(codePoints));
                this.leftOverCodePoints = Arrays.copyOf(codePoints, codePoints.length);
            }
            this.cBuf.compact();
        } while (result.isOverflow());
        if (result.isUnderflow()) {
            if (this.bBuf.hasRemaining()) {
                // empty if block
            }
        } else {
            throw new UnsupportedOperationException("Handle me gracefully");
        }
        this.bBuf.compact();
    }

    public void setConsumer(Consumer<int[]> inputHandler) {
        this.onChar = inputHandler;
    }

    private String fromCodePoints(int[] input) {
        return new String(input, 0, input.length);
    }
}

