/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadata;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractRepositoryMetadata
implements RepositoryMetadata {
    private Metadata metadata;

    protected AbstractRepositoryMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public String getRemoteFilename() {
        return "maven-metadata.xml";
    }

    public String getLocalFilename(ArtifactRepository repository) {
        return "maven-metadata-" + repository.getKey() + ".xml";
    }

    public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataStoreException {
        try {
            this.updateRepositoryMetadata(localRepository, remoteRepository);
        }
        catch (IOException e) {
            throw new RepositoryMetadataStoreException("Error updating group repository metadata", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new RepositoryMetadataStoreException("Error updating group repository metadata", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRepositoryMetadata(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws IOException, XmlPullParserException {
        block16: {
            File metadataFile;
            block15: {
                boolean changed;
                MetadataXpp3Reader mappingReader = new MetadataXpp3Reader();
                Metadata metadata = null;
                metadataFile = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((org.apache.maven.artifact.metadata.ArtifactMetadata)this, remoteRepository));
                if (metadataFile.length() == 0L) {
                    if (!metadataFile.delete()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        metadataFile.delete();
                    }
                } else if (metadataFile.exists()) {
                    XmlStreamReader reader = null;
                    try {
                        reader = ReaderFactory.newXmlReader(metadataFile);
                        metadata = mappingReader.read(reader, false);
                    }
                    finally {
                        IOUtil.close(reader);
                    }
                }
                if (metadata == null) {
                    metadata = this.metadata;
                    changed = true;
                } else {
                    changed = metadata.merge(this.metadata);
                }
                String version = metadata.getVersion();
                if (version != null && ("LATEST".equals(version) || "RELEASE".equals(version))) {
                    metadata.setVersion(null);
                }
                if (!changed && metadataFile.exists()) break block15;
                XmlStreamWriter writer = null;
                try {
                    metadataFile.getParentFile().mkdirs();
                    writer = WriterFactory.newXmlWriter(metadataFile);
                    MetadataXpp3Writer mappingWriter = new MetadataXpp3Writer();
                    mappingWriter.write(writer, metadata);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
                IOUtil.close(writer);
                break block16;
            }
            metadataFile.setLastModified(System.currentTimeMillis());
        }
    }

    public String toString() {
        return "repository metadata for: '" + this.getKey() + "'";
    }

    protected static Metadata createMetadata(Artifact artifact, Versioning versioning) {
        Metadata metadata = new Metadata();
        metadata.setGroupId(artifact.getGroupId());
        metadata.setArtifactId(artifact.getArtifactId());
        metadata.setVersion(artifact.getVersion());
        metadata.setVersioning(versioning);
        return metadata;
    }

    protected static Versioning createVersioning(Snapshot snapshot) {
        Versioning versioning = new Versioning();
        versioning.setSnapshot(snapshot);
        versioning.updateTimestamp();
        return versioning;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    public void merge(ArtifactMetadata metadata) {
        AbstractRepositoryMetadata repoMetadata = (AbstractRepositoryMetadata)metadata;
        this.metadata.merge(repoMetadata.getMetadata());
    }

    public void merge(org.apache.maven.artifact.metadata.ArtifactMetadata metadata) {
        AbstractRepositoryMetadata repoMetadata = (AbstractRepositoryMetadata)metadata;
        this.metadata.merge(repoMetadata.getMetadata());
    }

    public String extendedToString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\nRepository Metadata\n--------------------------");
        buffer.append("\nGroupId: ").append(this.getGroupId());
        buffer.append("\nArtifactId: ").append(this.getArtifactId());
        buffer.append("\nMetadata Type: ").append(this.getClass().getName());
        return buffer.toString();
    }

    @Override
    public int getNature() {
        return 1;
    }

    @Override
    public ArtifactRepositoryPolicy getPolicy(ArtifactRepository repository) {
        int nature = this.getNature();
        if ((nature & 3) == 3) {
            ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy(repository.getReleases());
            policy.merge(repository.getSnapshots());
            return policy;
        }
        if ((nature & 2) != 0) {
            return repository.getSnapshots();
        }
        return repository.getReleases();
    }
}

