/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

public class FeaturePackPlugin {
    public static final String DEFAULT_REPO_ID = "repository.maven";
    private final String repoId;
    private final String location;
    private final String id;

    public static boolean isDefaultRepoId(String repoId) {
        return DEFAULT_REPO_ID.equals(repoId);
    }

    public static FeaturePackPlugin getInstance(String id, String location) {
        return FeaturePackPlugin.getInstance(id, DEFAULT_REPO_ID, location);
    }

    public static FeaturePackPlugin getInstance(String id, String repoId, String location) {
        return new FeaturePackPlugin(repoId, location, id);
    }

    private FeaturePackPlugin(String repoId, String location, String id) {
        this.repoId = repoId;
        this.location = location;
        this.id = id;
    }

    public String getRepoId() {
        return this.repoId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.repoId == null ? 0 : this.repoId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeaturePackPlugin other = (FeaturePackPlugin)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        return !(this.repoId == null ? other.repoId != null : !this.repoId.equals(other.repoId));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.id).append(' ');
        if (!FeaturePackPlugin.isDefaultRepoId(this.repoId)) {
            buf.append(this.repoId).append(' ');
        }
        return buf.append(this.location).append(']').toString();
    }
}

