/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class SystemPaths {
    private final Set<Path> paths;

    public SystemPaths(Set<Path> paths) {
        HashSet<Path> tmp = new HashSet<Path>();
        for (Path path : paths) {
            if (path.isAbsolute()) {
                throw new IllegalArgumentException("Provided system-path must be relative to the installation. " + path);
            }
            if (tmp.isEmpty()) {
                tmp.add(path.normalize());
                continue;
            }
            if (!tmp.stream().noneMatch(p -> path.normalize().startsWith((Path)p))) continue;
            tmp.removeAll(tmp.stream().filter(p -> p.startsWith(path.normalize())).collect(Collectors.toSet()));
            tmp.add(path.normalize());
        }
        this.paths = tmp;
    }

    public boolean isSystemPath(Path path) {
        if (path.isAbsolute()) {
            throw new IllegalArgumentException("Provided system-path must be relative to the installation." + path);
        }
        for (Path p : this.paths) {
            if (!path.normalize().startsWith(p)) continue;
            return true;
        }
        return false;
    }
}

