/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.layers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.cmd.AbstractCommaSeparatedCompleter;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.state.StateActivators;
import org.jboss.galleon.cli.cmd.state.layers.AbstractLayersCommand;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;

@CommandDefinition(name="remove-excluded-layers", description="Remove excluded layers from a custom configuration", activator=StateActivators.ConfigDependentCommandActivator.class)
public class StateRemoveExcludedLayersCommand
extends AbstractLayersCommand {
    @Option(required=true, description="Comma separated list of layers to provision. In order to exclude an optional layer on which a layer from the list depends on, prefix the excluded layer with '-'. In order to un-exclude a layer already excluded in the current installation, prefix the layer with '+'.", completer=LayersCompleter.class)
    private String layers;

    @Override
    protected void runCommand(PmCommandInvocation invoc, State state) throws IOException, ProvisioningException, CommandExecutionException {
        try {
            state.removeExcludedLayersConfiguration(invoc.getPmSession(), this.getConfiguration(state), this.layers.split(",+"));
        }
        catch (Exception ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.removeFailed(), ex);
        }
    }

    public static class LayersCompleter
    extends AbstractCommaSeparatedCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            AbstractLayersCommand cmd = (AbstractLayersCommand)completerInvocation.getCommand();
            ConfigId config = cmd.getConfig();
            if (config == null) {
                return Collections.emptyList();
            }
            ConfigModel cModel = completerInvocation.getPmSession().getState().getConfig().getDefinedConfig(config);
            if (cModel == null) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(cModel.getExcludedLayers());
        }
    }
}

