/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractCommaSeparatedCompleter;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathsUtils;

public class InstalledProducerCompleter
extends AbstractCommaSeparatedCompleter {
    @Override
    protected List<String> getItems(PmCompleterInvocation completerInvocation) {
        CommandWithInstallationDirectory cmd = (CommandWithInstallationDirectory)((Object)completerInvocation.getCommand());
        Path installation = cmd.getInstallationDirectory(completerInvocation.getAeshContext());
        List<FeaturePackLocation> locations = InstalledProducerCompleter.getInstallationLocations(installation, completerInvocation.getPmSession(), true, false);
        ArrayList<String> items = new ArrayList<String>();
        String trimed = completerInvocation.getGivenCompleteValue().trim();
        List<String> lst = trimed.isEmpty() ? Collections.emptyList() : Arrays.asList(completerInvocation.getGivenCompleteValue().split(",+"));
        boolean ended = trimed.endsWith(",");
        int lastIndex = ended ? lst.size() : Math.max(0, lst.size() - 1);
        ArrayList<FeaturePackLocation> specified = new ArrayList<FeaturePackLocation>();
        try {
            for (String s : lst) {
                specified.add(completerInvocation.getPmSession().getResolvedLocation(installation, s));
            }
            for (FeaturePackLocation loc : locations) {
                boolean found = false;
                for (int i = 0; i < lastIndex; ++i) {
                    FeaturePackLocation s = (FeaturePackLocation)specified.get(i);
                    if (!s.getProducer().equals(loc.getProducer())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                items.add(completerInvocation.getPmSession().getExposedLocation(installation, loc).getProducer().toString());
            }
        }
        catch (Exception ex) {
            CliLogging.completionException(ex);
            return Collections.emptyList();
        }
        return items;
    }

    public static List<FeaturePackLocation> getInstallationLocations(Path installation, PmSession session, boolean transitive, boolean patches) {
        ArrayList<FeaturePackLocation> items = new ArrayList<FeaturePackLocation>();
        try {
            PathsUtils.assertInstallationDir(installation);
            ProvisioningManager mgr = session.newProvisioningManager(installation, false);
            try (ProvisioningLayout<FeaturePackLayout> layout = mgr.getLayoutFactory().newConfigLayout(mgr.getProvisioningConfig());){
                for (FeaturePackLayout fp : layout.getOrderedFeaturePacks()) {
                    if (fp.isDirectDep() || fp.isTransitiveDep() && transitive) {
                        items.add(fp.getFPID().getLocation());
                    }
                    if (!patches) continue;
                    List<FeaturePackLayout> appliedPatches = layout.getPatches(fp.getFPID());
                    for (FeaturePackLayout patch : appliedPatches) {
                        items.add(patch.getFPID().getLocation());
                    }
                }
            }
        }
        catch (Exception ex) {
            CliLogging.completionException(ex);
        }
        return items;
    }
}

