/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.model.FeatureGroupsBuilder;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.universe.FeaturePackLocation;

public class FeatureSpecsBuilder {
    private final Map<ResolvedSpecId, FeatureSpecInfo> allspecs = new HashMap<ResolvedSpecId, FeatureSpecInfo>();

    public Map<ResolvedSpecId, FeatureSpecInfo> getAllSpecs() {
        return this.allspecs;
    }

    public Group buildTree(ProvisioningLayout<FeaturePackRuntime> layout, PmSession session, FeaturePackLocation.FPID fpid, FeaturePackLocation.FPID id, Map<Identity, Group> allPackages, boolean useCache, Set<ResolvedSpecId> wantedSpecs) throws IOException, ProvisioningException {
        FeatureGroupsBuilder grpBuilder = new FeatureGroupsBuilder();
        HashSet<FeatureSpecInfo> specs = new HashSet<FeatureSpecInfo>();
        for (ResolvedFeatureSpec resolvedSpec : layout.getFeaturePack(fpid.getProducer()).getFeatureSpecs()) {
            ResolvedSpecId resolved = resolvedSpec.getId();
            if (wantedSpecs != null && !wantedSpecs.contains(resolved)) continue;
            FeatureSpecInfo specInfo = this.allspecs.get(resolved);
            if (specInfo == null) {
                HashSet<Identity> missingPackages = new HashSet<Identity>();
                FeatureSpec spec = resolvedSpec.getSpec();
                specInfo = new FeatureSpecInfo(resolved, id, spec);
                Identity specId = Identity.fromChannel(resolved.getProducer(), resolved.getName());
                boolean featureEnabled = true;
                for (PackageDependencySpec p : spec.getLocalPackageDeps()) {
                    Identity identity = Identity.fromChannel(resolved.getProducer(), p.getName());
                    Group grp = allPackages.get(identity);
                    if (grp != null) {
                        specInfo.addPackage(grp.getPackage());
                        FeatureSpecsBuilder.attachProvider(specId, grp, new HashSet<Group>());
                        continue;
                    }
                    featureEnabled = false;
                    missingPackages.add(identity);
                }
                for (String o : spec.getPackageOrigins()) {
                    for (PackageDependencySpec p : spec.getExternalPackageDeps(o)) {
                        Identity identity = Identity.fromString(o, p.getName());
                        Group grp = allPackages.get(identity);
                        if (grp != null) {
                            specInfo.addPackage(grp.getPackage());
                            FeatureSpecsBuilder.attachProvider(specId, grp, new HashSet<Group>());
                            continue;
                        }
                        featureEnabled = false;
                        missingPackages.add(identity);
                    }
                }
                specInfo.setEnabled(featureEnabled);
                specInfo.setMissingPackages(missingPackages);
                this.allspecs.put(resolved, specInfo);
                specs.add(specInfo);
            }
            String fullSpecName = resolved.getName();
            ArrayList<String> path = new ArrayList<String>();
            Group parent = grpBuilder.buildFeatureSpecGroups(fullSpecName, specInfo, path);
            parent.setFeatureSpec(specInfo);
        }
        return grpBuilder.getRoot();
    }

    private static void attachProvider(Identity provider, Group grp, HashSet<Group> seen) {
        grp.getPackage().addProvider(provider);
        if (seen.contains(grp)) {
            return;
        }
        seen.add(grp);
        for (Group dep : grp.getGroups()) {
            FeatureSpecsBuilder.attachProvider(provider, dep, seen);
        }
    }
}

