/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigItem;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.FeatureParameterSpec;

public class ConfigProvisioning {
    private static FeatureConfig getExistingFeature(ConfigModel cm, FeatureId featId) {
        for (ConfigItem ci : cm.getItems()) {
            FeatureConfig fi;
            if (!(ci instanceof FeatureConfig) || !(fi = (FeatureConfig)ci).getSpecId().equals(featId.getSpec())) continue;
            boolean eq = true;
            for (String name : featId.getParamNames()) {
                String p = fi.getParam(name);
                if (p != null && p.equals(featId.getParam(name))) continue;
                eq = false;
                break;
            }
            if (!eq) continue;
            return fi;
        }
        return null;
    }

    State.Action resetConfiguration(ConfigId id) {
        return new ResetConfigurationAction(id);
    }

    State.Action includeLayersConfiguration(ConfigId id, String[] layers, State state) {
        return new IncludeLayersConfigurationAction(id, layers, state);
    }

    State.Action excludeLayersConfiguration(ConfigId id, String[] layers, State state) {
        return new ExcludeLayersConfigurationAction(id, layers, state);
    }

    State.Action removeIncludedLayersConfiguration(ConfigId id, String[] layers) {
        return new RemoveIncludedLayersConfigurationAction(id, layers);
    }

    State.Action removeExcludedLayersConfiguration(ConfigId id, String[] layers) {
        return new RemoveExcludedLayersConfigurationAction(id, layers);
    }

    State.Action newConfiguration(ConfigId id) {
        return new DefineConfigurationAction(id);
    }

    State.Action addFeature(ConfigId id, FeatureSpecInfo spec, Map<String, String> options) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new AddFeatureAction(id, spec, options);
    }

    State.Action removeFeature(ConfigId id, FeatureInfo fi) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new RemoveFeatureAction(id, fi);
    }

    private static class ResetConfigurationAction
    implements State.Action {
        private final ConfigId id;
        private ConfigModel config;
        private List<ConfigModel> originalList;

        ResetConfigurationAction(ConfigId id) {
            this.id = id;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            for (ConfigModel m : current.getDefinedConfigs()) {
                if (!m.getId().equals(this.id)) continue;
                this.config = m;
                break;
            }
            if (this.config == null) {
                throw new ProvisioningException(CliErrors.configurationNotFound(this.id));
            }
            this.originalList = new ArrayList<ConfigModel>(builder.getDefinedConfigs());
            builder.removeConfig(this.id);
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.removeAllConfigs();
            for (ConfigModel config : this.originalList) {
                builder.addConfig(config);
            }
        }
    }

    private static class IncludeLayersConfigurationAction
    implements State.Action {
        private final ConfigId id;
        private ConfigModel.Builder targetConfig;
        private final String[] layers;
        private boolean newConfig;
        private final State state;

        IncludeLayersConfigurationAction(ConfigId id, String[] layers, State state) {
            this.id = id;
            this.layers = layers;
            this.state = state;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            for (ConfigModel m : builder.getDefinedConfigs()) {
                if (!m.getId().equals(this.id)) continue;
                this.targetConfig = ConfigModel.builder(m);
                break;
            }
            if (this.targetConfig == null) {
                this.targetConfig = ConfigModel.builder(this.id.getModel(), this.id.getName());
                this.newConfig = true;
            }
            List<ConfigInfo> configs = this.state.getContainer().getFinalConfigs().get(this.id.getModel());
            ConfigInfo existingConfig = null;
            if (configs != null) {
                for (ConfigInfo ci : configs) {
                    if (!ci.getName().equals(this.id.getName())) continue;
                    existingConfig = ci;
                }
            }
            if (existingConfig != null) {
                for (String l : this.layers) {
                    if (!existingConfig.getlayers().contains(new ConfigId(this.id.getModel(), l))) continue;
                    throw new ProvisioningException(CliErrors.layerAlreadyExists(l, existingConfig.getlayers()));
                }
            }
            for (String layer : this.layers) {
                this.targetConfig.includeLayer(layer);
            }
            if (!this.newConfig) {
                builder.removeConfig(this.id);
            }
            builder.addConfig(this.targetConfig.build());
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.removeConfig(this.id);
            if (!this.newConfig) {
                for (String layer : this.layers) {
                    this.targetConfig.removeIncludedLayer(layer);
                }
                builder.addConfig(this.targetConfig.build());
            }
        }
    }

    private static class ExcludeLayersConfigurationAction
    implements State.Action {
        private final ConfigId id;
        private ConfigModel.Builder targetConfig;
        private final String[] layers;
        private boolean newConfig;
        private final State state;

        ExcludeLayersConfigurationAction(ConfigId id, String[] layers, State state) {
            this.id = id;
            this.layers = layers;
            this.state = state;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            for (ConfigModel m : builder.getDefinedConfigs()) {
                if (!m.getId().equals(this.id)) continue;
                this.targetConfig = ConfigModel.builder(m);
                break;
            }
            if (this.targetConfig == null) {
                this.targetConfig = ConfigModel.builder(this.id.getModel(), this.id.getName());
                this.newConfig = true;
            }
            List<ConfigInfo> configs = this.state.getContainer().getFinalConfigs().get(this.id.getModel());
            ConfigInfo existingConfig = null;
            if (configs != null) {
                for (ConfigInfo ci : configs) {
                    if (!ci.getName().equals(this.id.getName())) continue;
                    existingConfig = ci;
                }
            }
            if (existingConfig != null) {
                for (String l : this.layers) {
                    if (existingConfig.getlayers().contains(new ConfigId(this.id.getModel(), l))) continue;
                    throw new ProvisioningException(CliErrors.layerNotIncluded(l, existingConfig.getlayers()));
                }
            }
            for (String layer : this.layers) {
                this.targetConfig.excludeLayer(layer);
            }
            if (!this.newConfig) {
                builder.removeConfig(this.id);
            }
            builder.addConfig(this.targetConfig.build());
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.removeConfig(this.id);
            if (!this.newConfig) {
                for (String layer : this.layers) {
                    this.targetConfig.removeExcludedLayer(layer);
                }
                builder.addConfig(this.targetConfig.build());
            }
        }
    }

    private static class RemoveIncludedLayersConfigurationAction
    implements State.Action {
        private final ConfigId id;
        private ConfigModel.Builder targetConfig;
        private final String[] layers;

        RemoveIncludedLayersConfigurationAction(ConfigId id, String[] layers) {
            this.id = id;
            this.layers = layers;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            ConfigModel originalConfig = null;
            for (ConfigModel m : builder.getDefinedConfigs()) {
                if (!m.getId().equals(this.id)) continue;
                this.targetConfig = ConfigModel.builder(m);
                originalConfig = m;
                break;
            }
            if (this.targetConfig == null) {
                throw new ProvisioningException(CliErrors.configurationNotFound(this.id));
            }
            for (String layer : this.layers) {
                if (!originalConfig.getIncludedLayers().contains(layer)) {
                    throw new ProvisioningException(CliErrors.layerNotIncluded(layer, originalConfig.getIncludedLayers()));
                }
                this.targetConfig.removeIncludedLayer(layer);
            }
            builder.removeConfig(this.id);
            builder.addConfig(this.targetConfig.build());
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.removeConfig(this.id);
            for (String layer : this.layers) {
                this.targetConfig.includeLayer(layer);
            }
            builder.addConfig(this.targetConfig.build());
        }
    }

    private static class RemoveExcludedLayersConfigurationAction
    implements State.Action {
        private final ConfigId id;
        private ConfigModel.Builder targetConfig;
        private final String[] layers;

        RemoveExcludedLayersConfigurationAction(ConfigId id, String[] layers) {
            this.id = id;
            this.layers = layers;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            ConfigModel originalConfig = null;
            for (ConfigModel m : builder.getDefinedConfigs()) {
                if (!m.getId().equals(this.id)) continue;
                this.targetConfig = ConfigModel.builder(m);
                originalConfig = m;
                break;
            }
            if (this.targetConfig == null) {
                throw new ProvisioningException(CliErrors.configurationNotFound(this.id));
            }
            for (String layer : this.layers) {
                if (!originalConfig.getExcludedLayers().contains(layer)) {
                    throw new ProvisioningException(CliErrors.layerNotExcluded(layer, originalConfig.getExcludedLayers()));
                }
                this.targetConfig.removeExcludedLayer(layer);
            }
            builder.removeConfig(this.id);
            builder.addConfig(this.targetConfig.build());
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.removeConfig(this.id);
            for (String layer : this.layers) {
                this.targetConfig.excludeLayer(layer);
            }
            builder.addConfig(this.targetConfig.build());
        }
    }

    private static class DefineConfigurationAction
    implements State.Action {
        private final ConfigId id;

        DefineConfigurationAction(ConfigId id) {
            this.id = id;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            for (ConfigModel m : builder.getDefinedConfigs()) {
                if (!m.getId().equals(this.id)) continue;
                throw new ProvisioningException(CliErrors.configurationAlreadyExists(this.id));
            }
            builder.addConfig(ConfigModel.builder(this.id.getModel(), this.id.getName()).build());
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.removeConfig(this.id);
        }
    }

    private static class AddFeatureAction
    implements State.Action {
        private final ConfigId id;
        private final FeatureSpecInfo spec;
        private final Map<String, String> options;
        private ConfigModel.Builder targetConfig;
        private FeatureId featId;
        private boolean newConfig;
        private boolean isExcluded;
        private FeatureConfig existingFeature;

        AddFeatureAction(ConfigId id, FeatureSpecInfo spec, Map<String, String> options) {
            this.id = id;
            this.spec = spec;
            this.options = options;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            HashMap<String, String> ids = new HashMap<String, String>();
            HashMap<String, String> params = new HashMap<String, String>();
            for (String opt : this.options.keySet()) {
                FeatureParameterSpec featureParameterSpec = this.spec.getSpec().getParams().get(opt);
                String value = this.options.get(opt);
                if (featureParameterSpec.isFeatureId()) {
                    if ("GLN_UNDEFINED".equals(value)) continue;
                    ids.put(opt, value);
                    continue;
                }
                if (value.equals(featureParameterSpec.getDefaultValue())) continue;
                params.put(opt, value);
            }
            this.featId = new FeatureId(this.spec.getSpec().getName(), ids);
            FeatureConfig fc = FeatureConfig.newConfig(this.featId);
            for (ConfigModel configModel : current.getDefinedConfigs()) {
                if (!configModel.getName().equals(this.id.getName()) || !configModel.getModel().equals(this.id.getModel())) continue;
                this.targetConfig = ConfigModel.builder(configModel);
                this.existingFeature = ConfigProvisioning.getExistingFeature(configModel, this.featId);
                if (this.existingFeature != null) {
                    this.targetConfig.removeFeature(this.featId);
                }
                this.isExcluded = configModel.getExcludedFeatures().containsKey(this.featId);
                break;
            }
            if (this.targetConfig == null) {
                this.targetConfig = ConfigModel.builder(this.id.getModel(), this.id.getName());
                this.newConfig = true;
            }
            for (Map.Entry entry : params.entrySet()) {
                fc.setParam((String)entry.getKey(), (String)entry.getValue());
            }
            if (this.isExcluded) {
                this.targetConfig.removeExcludedFeature(this.featId);
            } else {
                this.targetConfig.addFeature(fc);
            }
            if (!this.newConfig) {
                builder.removeConfig(this.id);
            }
            builder.addConfig(this.targetConfig.build());
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            if (this.isExcluded) {
                this.targetConfig.excludeFeature(this.featId);
            } else {
                this.targetConfig.removeFeature(this.featId);
                if (this.existingFeature != null) {
                    this.targetConfig.addFeature(this.existingFeature);
                }
            }
            builder.removeConfig(this.id);
            if (!this.newConfig) {
                builder.addConfig(this.targetConfig.build());
            }
        }
    }

    private static class RemoveFeatureAction
    implements State.Action {
        private final ConfigId id;
        private final FeatureInfo feature;
        private ConfigModel.Builder targetConfig;
        private boolean newConfig;
        private boolean exclude;

        RemoveFeatureAction(ConfigId id, FeatureInfo feature) {
            this.id = id;
            this.feature = feature;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            if (this.feature.getFeatureId() == null) {
                throw new ProvisioningException("Feature " + this.feature.getType() + " can't be removed, no feature-id");
            }
            for (ConfigModel cm : current.getDefinedConfigs()) {
                if (!cm.getName().equals(this.id.getName()) || !cm.getModel().equals(this.id.getModel())) continue;
                this.targetConfig = ConfigModel.builder(cm);
                this.exclude = ConfigProvisioning.getExistingFeature(cm, this.feature.getFeatureId()) == null;
                break;
            }
            if (this.targetConfig == null) {
                if (!current.isInheritConfigs(true) && !current.getIncludedConfigs().contains(this.id)) {
                    throw new ProvisioningException(CliErrors.configurationNotFound(this.id));
                }
                this.targetConfig = ConfigModel.builder(this.id.getModel(), this.id.getName());
                this.newConfig = true;
                this.targetConfig.excludeFeature(this.feature.getFeatureId());
            } else {
                builder.removeConfig(this.id);
                if (this.exclude) {
                    this.targetConfig.excludeFeature(this.feature.getFeatureId());
                } else {
                    this.targetConfig.removeFeature(this.feature.getFeatureId());
                }
            }
            builder.addConfig(this.targetConfig.build());
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            if (this.newConfig) {
                builder.removeConfig(this.id);
            } else {
                if (this.exclude) {
                    this.targetConfig.removeExcludedFeature(this.feature.getFeatureId());
                } else {
                    this.targetConfig.addFeature(this.feature.getFeatureConfig());
                }
                builder.removeConfig(this.id);
                builder.addConfig(this.targetConfig.build());
            }
        }
    }
}

