/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.path;

import java.util.ArrayList;
import java.util.List;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParserException;

public class PathParser {
    public static final char PATH_SEPARATOR = '/';
    public static final char ORIGIN_SEPARATOR = '#';

    public static void parse(String path, PathConsumer consumer) throws PathParserException, PathConsumerException {
        State state = State.NOT_STARTED;
        char[] arr = path.toCharArray();
        int offset = 0;
        while (offset < arr.length) {
            char c = arr[offset];
            switch (state) {
                case NOT_STARTED: {
                    if (c != '/') {
                        throw new PathParserException("Invalid syntax, path must start by /");
                    }
                    state = State.CONTENT;
                    consumer.enterRoot();
                    ++offset;
                    break;
                }
                case CONTENT: {
                    ArrayList<String> content = new ArrayList<String>();
                    int i = PathParser.parseMultiple(arr, offset, content, '#', '/', consumer.expectEndOfNode());
                    offset += i;
                    state = State.CONTENT;
                    Node n = null;
                    if (content.size() == 1) {
                        n = new Node(null, (String)content.get(0));
                    } else if (content.size() == 2) {
                        n = new Node((String)content.get(0), (String)content.get(1));
                    } else if (!consumer.expectEndOfNode()) {
                        throw new PathParserException("Invalid node " + content);
                    }
                    consumer.enterNode(n);
                    break;
                }
            }
        }
    }

    private static int parsePathNode(char[] arr, int offset, List<String> content, char separator) {
        if (offset == arr.length - 1) {
            return -1;
        }
        StringBuilder builder = new StringBuilder();
        boolean escaped = false;
        int orig = offset;
        while (offset < arr.length) {
            char c = arr[offset];
            ++offset;
            if (c == '\\') {
                if (escaped) {
                    escaped = false;
                    builder.append("\\");
                    builder.append(c);
                    continue;
                }
                escaped = true;
                continue;
            }
            if (c == separator) {
                if (escaped) {
                    builder.append(c);
                    continue;
                }
                content.add(builder.toString());
                break;
            }
            builder.append(c);
        }
        if (content.isEmpty()) {
            content.add(builder.toString());
        }
        return offset - orig;
    }

    private static int parseMultiple(char[] arr, int offset, List<String> content, char separator1, char terminalSeparator, boolean expectEndOfPath) {
        MultiState state = MultiState.FIRST;
        int orig = offset;
        StringBuilder builder = new StringBuilder();
        boolean escaped = false;
        boolean done = false;
        while (offset < arr.length && !done) {
            char c = arr[offset];
            ++offset;
            if (c == '\\') {
                if (escaped) {
                    escaped = false;
                    builder.append("\\");
                    builder.append(c);
                    continue;
                }
                escaped = true;
                continue;
            }
            switch (state) {
                case FIRST: {
                    if (c == separator1) {
                        if (escaped) {
                            builder.append(c);
                            break;
                        }
                        content.add(builder.toString());
                        builder = new StringBuilder();
                        state = MultiState.NEXT;
                        break;
                    }
                    if (c == terminalSeparator) {
                        if (escaped) {
                            builder.append(c);
                            break;
                        }
                        content.add(builder.toString());
                        done = true;
                        break;
                    }
                    builder.append(c);
                    break;
                }
                case NEXT: {
                    if (c == terminalSeparator) {
                        if (escaped) {
                            builder.append(c);
                            break;
                        }
                        content.add(builder.toString());
                        done = true;
                        break;
                    }
                    builder.append(c);
                }
            }
        }
        if (!expectEndOfPath && !done) {
            content.add(builder.toString());
        }
        return offset - orig;
    }

    static enum State {
        NOT_STARTED,
        ROOT,
        CONTENT;

    }

    public static interface PathConsumer {
        public void enterNode(Node var1) throws PathConsumerException;

        public void enterRoot() throws PathConsumerException;

        public boolean expectEndOfNode();
    }

    public static class Node {
        private final String orig;
        private final String name;

        Node(String orig, String name) {
            this.orig = orig;
            this.name = name;
        }

        public String getOrig() {
            return this.orig;
        }

        public String getName() {
            return this.name;
        }
    }

    static enum MultiState {
        FIRST,
        NEXT;

    }
}

