/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.FeaturePackPackagesConfigParser10;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ProvisioningXmlParser30
implements PlugableXmlParser<ProvisioningConfig.Builder> {
    public static final String NAMESPACE = "urn:jboss:galleon:provisioning:3.0";
    public static final QName ROOT = new QName("urn:jboss:galleon:provisioning:3.0", Element.INSTALLATION.getLocalName());

    @Override
    public QName getRoot() {
        return ROOT;
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, ProvisioningConfig.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case UNIVERSES: {
                            ProvisioningXmlParser30.readUniverses(reader, builder);
                            continue block14;
                        }
                        case FEATURE_PACK: {
                            ProvisioningXmlParser30.readFeaturePackDep(reader, builder);
                            continue block14;
                        }
                        case DEFAULT_CONFIGS: {
                            ProvisioningXmlParser30.parseDefaultConfigs(reader, builder);
                            continue block14;
                        }
                        case CONFIG: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig(reader, config);
                            try {
                                builder.addConfig(config.build());
                                continue block14;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse config element", reader.getLocation(), e);
                            }
                        }
                        case TRANSITIVE: {
                            ProvisioningXmlParser30.readTransitive(reader, builder);
                            continue block14;
                        }
                        case OPTIONS: {
                            ProvisioningXmlParser30.readOptions(reader, builder);
                            continue block14;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    static void readUniverses(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> fpBuilder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case UNIVERSE: {
                            ProvisioningXmlParser30.readUniverse(reader, fpBuilder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
    }

    private static void readUniverse(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> fpBuilder) throws XMLStreamException {
        String name = null;
        String factory = null;
        String location = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case FACTORY: {
                    factory = reader.getAttributeValue(i);
                    continue block7;
                }
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block7;
                }
                case LOCATION: {
                    location = reader.getAttributeValue(i);
                    continue block7;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        ParsingUtils.parseNoContent(reader);
        try {
            fpBuilder.addUniverse(name, factory, location);
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException("Failed to parse universe declaration", e);
        }
    }

    static void readFeaturePackDep(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> fpBuilder) throws XMLStreamException {
        ProvisioningXmlParser30.doReadFeaturePackDep(reader, fpBuilder, false);
    }

    static void readTransitiveFeaturePackDep(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> fpBuilder) throws XMLStreamException {
        ProvisioningXmlParser30.doReadFeaturePackDep(reader, fpBuilder, true);
    }

    private static void doReadFeaturePackDep(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> builder, boolean transitive) throws XMLStreamException {
        FeaturePackConfig.Builder depBuilder;
        FeaturePackLocation location = null;
        int count = reader.getAttributeCount();
        block20: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case LOCATION: {
                    location = ProvisioningXmlParser30.parseFpl(reader, i);
                    continue block20;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (location == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.LOCATION));
        }
        location = ProvisioningXmlParser30.resolveUniverse(builder, location);
        String origin = null;
        FeaturePackConfig.Builder builder2 = depBuilder = transitive ? FeaturePackConfig.transitiveBuilder(location) : FeaturePackConfig.builder(location);
        block21: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    try {
                        builder.addFeaturePackDep(origin, depBuilder.build());
                    }
                    catch (ProvisioningDescriptionException e) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("Failed to add ").append(location).append(" as a ");
                        if (transitive) {
                            buf.append("transitive ");
                        }
                        buf.append(" feature-pack dependency");
                        throw new XMLStreamException(ParsingUtils.error(buf.toString(), reader.getLocation()), e);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case PACKAGES: {
                            try {
                                FeaturePackPackagesConfigParser10.readPackages(reader, depBuilder);
                                continue block21;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse " + Element.PACKAGES.getLocalName() + ": " + e.getLocalizedMessage(), reader.getLocation(), e);
                            }
                        }
                        case ORIGIN: {
                            origin = reader.getElementText();
                            continue block21;
                        }
                        case DEFAULT_CONFIGS: {
                            ProvisioningXmlParser30.parseDefaultConfigs(reader, depBuilder);
                            continue block21;
                        }
                        case CONFIG: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig(reader, config);
                            try {
                                depBuilder.addConfig(config.build());
                                continue block21;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse config element", reader.getLocation(), e);
                            }
                        }
                        case PATCHES: {
                            ProvisioningXmlParser30.readPatches(reader, depBuilder, builder);
                            continue block21;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
    }

    public static void parseDefaultConfigs(XMLExtendedStreamReader reader, ConfigCustomizationsBuilder<?> fpBuilder) throws XMLStreamException {
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case INHERIT: {
                    fpBuilder.setInheritConfigs(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block12;
                }
                case INHERIT_UNNAMED_MODELS: {
                    fpBuilder.setInheritModelOnlyConfigs(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case INCLUDE: {
                            ProvisioningXmlParser30.parseConfigModelRef(reader, fpBuilder, true);
                            continue block13;
                        }
                        case EXCLUDE: {
                            ProvisioningXmlParser30.parseConfigModelRef(reader, fpBuilder, false);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void parseConfigModelRef(XMLExtendedStreamReader reader, ConfigCustomizationsBuilder<?> fpBuilder, boolean include) throws XMLStreamException {
        String name = null;
        String model = null;
        Boolean namedConfigsOnly = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block7;
                }
                case MODEL: {
                    model = reader.getAttributeValue(i);
                    continue block7;
                }
                case NAMED_MODELS_ONLY: {
                    namedConfigsOnly = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block7;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        try {
            if (include) {
                if (name == null) {
                    fpBuilder.includeConfigModel(model);
                } else {
                    fpBuilder.includeDefaultConfig(new ConfigId(model, name));
                }
            } else if (name == null) {
                if (namedConfigsOnly != null) {
                    fpBuilder.excludeConfigModel(model, namedConfigsOnly);
                } else {
                    fpBuilder.excludeConfigModel(model);
                }
            } else {
                fpBuilder.excludeDefaultConfig(model, name);
            }
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException(e);
        }
        ParsingUtils.parseNoContent(reader);
    }

    private static void readTransitive(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case FEATURE_PACK: {
                            ProvisioningXmlParser30.readTransitiveFeaturePackDep(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readPatches(XMLExtendedStreamReader reader, FeaturePackConfig.Builder fpConfigBuilder, FeaturePackDepsConfigBuilder<?> depsBuilder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block9: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case PATCH: {
                            FeaturePackLocation.FPID patchId = ProvisioningXmlParser30.readPatch(reader, depsBuilder);
                            try {
                                fpConfigBuilder.addPatch(patchId);
                                continue block9;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to add patch " + patchId + " to config", e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static FeaturePackLocation.FPID readPatch(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> depsBuilder) throws XMLStreamException {
        FeaturePackLocation fpl = null;
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case ID: {
                    fpl = ProvisioningXmlParser30.parseFpl(reader, i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (fpl == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.ID));
        }
        ParsingUtils.parseNoContent(reader);
        fpl = ProvisioningXmlParser30.resolveUniverse(depsBuilder, fpl);
        return fpl.getFPID();
    }

    static FeaturePackLocation resolveUniverse(FeaturePackDepsConfigBuilder<?> builder, FeaturePackLocation location) throws XMLStreamException {
        if (location.getUniverse() == null) {
            if (!builder.hasDefaultUniverse()) {
                throw new XMLStreamException("Failed to parse feature-pack configuration for " + location + ": default universe was not configured");
            }
            location = new FeaturePackLocation(builder.getDefaultUniverse(), location.getProducerName(), location.getChannelName(), location.getFrequency(), location.getBuild());
        } else {
            UniverseSpec resolvedConfig = builder.getUniverseSpec(location.getUniverse().toString());
            if (resolvedConfig != null) {
                location = new FeaturePackLocation(resolvedConfig, location.getProducerName(), location.getChannelName(), location.getFrequency(), location.getBuild());
            }
        }
        return location;
    }

    static FeaturePackLocation parseFpl(XMLExtendedStreamReader reader, int i) throws XMLStreamException {
        try {
            return FeaturePackLocation.fromString(reader.getAttributeValue(i));
        }
        catch (IllegalArgumentException e) {
            throw ParsingUtils.error("Failed to parse feature-pack location " + reader.getAttributeValue(i), reader.getLocation(), e);
        }
    }

    static void readOptions(XMLExtendedStreamReader reader, ProvisioningConfig.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case OPTION: {
                            ProvisioningXmlParser30.readOption(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
    }

    private static void readOption(XMLExtendedStreamReader reader, ProvisioningConfig.Builder builder) throws XMLStreamException {
        String name = null;
        String value = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        ParsingUtils.parseNoContent(reader);
        builder.addOption(name, value);
    }

    static enum Element implements XmlNameProvider
    {
        CONFIG("config"),
        DEFAULT_CONFIGS("default-configs"),
        EXCLUDE("exclude"),
        FEATURE_PACK("feature-pack"),
        INCLUDE("include"),
        INSTALLATION("installation"),
        OPTION("option"),
        OPTIONS("options"),
        ORIGIN("origin"),
        PACKAGES("packages"),
        PATCHES("patches"),
        PATCH("patch"),
        TRANSITIVE("transitive"),
        UNIVERSES("universes"),
        UNIVERSE("universe"),
        UNKNOWN(null);

        private static final Map<String, Element> elementsByLocal;
        private final String name;
        private final String namespace = "urn:jboss:galleon:provisioning:3.0";

        static Element of(String localName) {
            Element element = elementsByLocal.get(localName);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return ProvisioningXmlParser30.NAMESPACE;
        }

        public String toString() {
            return this.name;
        }

        static {
            elementsByLocal = new HashMap<String, Element>(16);
            elementsByLocal.put(Element.CONFIG.name, CONFIG);
            elementsByLocal.put(Element.DEFAULT_CONFIGS.name, DEFAULT_CONFIGS);
            elementsByLocal.put(Element.EXCLUDE.name, EXCLUDE);
            elementsByLocal.put(Element.FEATURE_PACK.name, FEATURE_PACK);
            elementsByLocal.put(Element.INCLUDE.name, INCLUDE);
            elementsByLocal.put(Element.INSTALLATION.name, INSTALLATION);
            elementsByLocal.put(Element.OPTION.name, OPTION);
            elementsByLocal.put(Element.OPTIONS.name, OPTIONS);
            elementsByLocal.put(Element.ORIGIN.name, ORIGIN);
            elementsByLocal.put(Element.PACKAGES.name, PACKAGES);
            elementsByLocal.put(Element.PATCHES.name, PATCHES);
            elementsByLocal.put(Element.PATCH.name, PATCH);
            elementsByLocal.put(Element.TRANSITIVE.name, TRANSITIVE);
            elementsByLocal.put(Element.UNIVERSE.name, UNIVERSE);
            elementsByLocal.put(Element.UNIVERSES.name, UNIVERSES);
            elementsByLocal.put(null, UNKNOWN);
        }
    }

    static enum Attribute implements XmlNameProvider
    {
        FACTORY("factory"),
        ID("id"),
        INHERIT("inherit"),
        INHERIT_UNNAMED_MODELS("inherit-unnamed-models"),
        LOCATION("location"),
        MODEL("model"),
        NAME("name"),
        NAMED_MODELS_ONLY("named-models-only"),
        VALUE("value"),
        UNKNOWN(null);

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(String name) {
            Attribute attribute = attributes.get(name);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        public String toString() {
            return this.name;
        }

        static {
            attributes = new HashMap<String, Attribute>(10);
            attributes.put(Attribute.FACTORY.name, FACTORY);
            attributes.put(Attribute.ID.name, ID);
            attributes.put(Attribute.INHERIT.name, INHERIT);
            attributes.put(Attribute.INHERIT_UNNAMED_MODELS.name, INHERIT_UNNAMED_MODELS);
            attributes.put(Attribute.MODEL.name, MODEL);
            attributes.put(Attribute.NAME.name, NAME);
            attributes.put(Attribute.NAMED_MODELS_ONLY.name, NAMED_MODELS_ONLY);
            attributes.put(Attribute.LOCATION.name, LOCATION);
            attributes.put(Attribute.VALUE.name, VALUE);
            attributes.put(null, UNKNOWN);
        }
    }
}

