/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.aesh.command.completer.OptionCompleter;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathParser;

public abstract class AbstractPathCompleter
implements OptionCompleter<PmCompleterInvocation> {
    @Override
    public void complete(PmCompleterInvocation completerInvocation) {
        List<String> items = this.getItems(completerInvocation);
        int i = completerInvocation.getGivenCompleteValue().lastIndexOf("/") + 1;
        completerInvocation.setAppendSpace(false);
        completerInvocation.addAllCompleterValues(items);
        if (items.size() == 1 && completerInvocation.getGivenCompleteValue().endsWith(items.get(0))) {
            completerInvocation.setAppendSpace(true);
        }
        completerInvocation.setOffset(completerInvocation.getGivenCompleteValue().length() - i);
    }

    List<String> getItems(PmCompleterInvocation completerInvocation) {
        PmSession session = completerInvocation.getPmSession();
        try {
            String currentPath;
            FeatureContainer container = this.getContainer(completerInvocation);
            if (container == null) {
                return Collections.emptyList();
            }
            if (session.getCurrentPath() == null && completerInvocation.getGivenCompleteValue().isEmpty()) {
                return Arrays.asList("/");
            }
            Object buffer = completerInvocation.getGivenCompleteValue();
            if (!((String)buffer).startsWith("/") && (currentPath = this.getCurrentPath(completerInvocation)) != null) {
                boolean completePath = currentPath.endsWith("/");
                buffer = currentPath + (completePath ? "" : "/") + (String)buffer;
            }
            FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(container, true);
            PathParser.parse((String)buffer, consumer);
            List<String> candidates = consumer.getCandidates((String)buffer);
            this.filterCandidates(consumer, candidates);
            return candidates;
        }
        catch (Exception ex) {
            CliLogging.log.errorf("Exception while completing: {0}", (Object)ex.getLocalizedMessage());
            return Collections.emptyList();
        }
    }

    protected abstract String getCurrentPath(PmCompleterInvocation var1) throws Exception;

    protected abstract void filterCandidates(FeatureContainerPathConsumer var1, List<String> var2);

    protected abstract FeatureContainer getContainer(PmCompleterInvocation var1) throws Exception;
}

