/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.APIVersion;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.GalleonCommandExecutionContext;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.cmd.AbstractCommaSeparatedCompleter;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.plugin.AbstractPluginsCommand;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.impl.ProvisioningUtil;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathsUtils;

public class InstallCommand
extends AbstractPluginsCommand {
    public static final String FILE_OPTION_NAME = "file";
    public static final String LAYERS_OPTION_NAME = "layers";
    public static final String DEFAULT_CONFIGS_OPTION_NAME = "default-configs";
    public static final String CONFIG_OPTION_NAME = "config";

    public InstallCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options, FeaturePackLocation loc) throws CommandExecutionException {
        throw new CommandExecutionException("Shouldn't be called");
    }

    @Override
    protected String getCoreVersion(PmSession session) throws CommandExecutionException, ProvisioningException {
        Path zipPath = this.getFeaturePackFilePath();
        String version = APIVersion.getVersion();
        if (zipPath == null) {
            Path install;
            String loc = this.getFeaturePackLocation(session);
            if (loc != null && (install = this.getInstallationDirectory(session.getAeshContext())) != null) {
                Path p = PathsUtils.getProvisioningXml(install);
                if (Files.exists(p, new LinkOption[0])) {
                    version = session.getGalleonBuilder().getCoreVersion(p);
                } else {
                    FeaturePackLocation fpl = session.getGalleonContext(APIVersion.getVersion()).getResolvedLocation(null, loc);
                    version = session.getGalleonBuilder().getCoreVersion(fpl);
                }
            }
        } else {
            version = ProvisioningUtil.getFeaturePackDescription(zipPath).getGalleonVersion();
        }
        return version;
    }

    private static List<ConfigId> parseConfigurations(String configurations) {
        String[] split = configurations.split(",+");
        ArrayList<ConfigId> configs = new ArrayList<ConfigId>();
        if (split.length == 0) {
            return configs;
        }
        for (String c : split) {
            String config = null;
            String model = null;
            if ((c = c.trim()).isEmpty()) continue;
            int i = c.indexOf("/");
            if (i < 0) {
                config = c.trim();
            } else {
                model = c.substring(0, i).trim();
                if (i < c.length() - 1) {
                    config = c.substring(i + 1, c.length()).trim();
                }
            }
            configs.add(new ConfigId(model, config));
        }
        return configs;
    }

    @Override
    protected String getName() {
        return "install";
    }

    @Override
    protected String getDescription() {
        return "Installs specified feature pack";
    }

    @Override
    protected String getId(PmSession session) throws CommandExecutionException {
        Path p = this.getFeaturePackFilePath();
        if (p != null) {
            return p.toString();
        }
        return super.getId(session);
    }

    public Path getFeaturePackFilePath() {
        Path p;
        String filePath = (String)this.getValue(FILE_OPTION_NAME);
        if (filePath == null) {
            filePath = this.getOptionValue(FILE_OPTION_NAME);
        }
        if (filePath != null && Files.exists(p = Paths.get(filePath, new String[0]), new LinkOption[0])) {
            return p;
        }
        return null;
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        ProcessedOption dir = ProcessedOptionBuilder.builder().name("dir").hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Installation directory").completer(FileOptionCompleter.class).build();
        options.add(dir);
        ProcessedOption file = ProcessedOptionBuilder.builder().name(FILE_OPTION_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).activator(new FileOptionActivator()).description("Path to feature pack zip file").completer(FileOptionCompleter.class).build();
        options.add(file);
        ProcessedOption layers = ProcessedOptionBuilder.builder().name(LAYERS_OPTION_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).completer(LayersCompleter.class).activator(new LayersOptionActivator()).description("Comma separated list of layers to provision. In order to exclude an optional layer on which a layer from the list depends on, prefix the excluded layer with '-'. In order to un-exclude a layer already excluded in the current installation, prefix the layer with '+'.").build();
        options.add(layers);
        ProcessedOption configs = ProcessedOptionBuilder.builder().name(DEFAULT_CONFIGS_OPTION_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).activator(new DefaultConfigsOptionActivator()).description("A comma separated list of <configuration model>/<configuration name>").build();
        options.add(configs);
        ProcessedOption config = ProcessedOptionBuilder.builder().name(CONFIG_OPTION_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).activator(new ConfigOptionActivator()).description("A <configuration model>/<configuration name> to configure configuration generated with layers. The configuration model is optional, it is retrieved from the feature-pack content").build();
        options.add(config);
        return options;
    }

    String getModel(PmSession session) throws CommandExecutionException {
        String config = (String)this.getValue(CONFIG_OPTION_NAME);
        if (config == null) {
            config = this.getOptionValue(CONFIG_OPTION_NAME);
        }
        String model = null;
        if (config != null) {
            List<ConfigId> configs = InstallCommand.parseConfigurations(config);
            if (configs.size() > 1) {
                throw new CommandExecutionException(CliErrors.onlyOneConfigurationWithlayers());
            }
            if (!configs.isEmpty()) {
                model = configs.get(0).getModel();
            }
        }
        return model;
    }

    @Override
    protected OptionActivator getArgumentActivator() {
        return new ArgOptionActivator();
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
        Path p;
        String filePath = (String)this.getValue(FILE_OPTION_NAME);
        if (filePath == null) {
            super.doValidateOptions(invoc);
            return;
        }
        String arg = (String)this.getValue("");
        if (arg != null) {
            throw new CommandExecutionException("Only one of file or Feature-pack location is allowed.");
        }
        try {
            p = Util.resolvePath(invoc.getConfiguration().getAeshContext(), filePath);
        }
        catch (IOException ex) {
            throw new CommandExecutionException(ex.getMessage());
        }
        if (!Files.exists(p, new LinkOption[0])) {
            throw new CommandExecutionException(p + " doesn't exist.");
        }
    }

    @Override
    protected boolean canComplete(PmSession pmSession) {
        String targetDirArg = (String)this.getValue("dir");
        if (targetDirArg == null) {
            targetDirArg = this.getOptionValue("dir");
        }
        if (targetDirArg != null) {
            return true;
        }
        Path workDir = PmSession.getWorkDir(pmSession.getAeshContext());
        return Files.exists(PathsUtils.getProvisioningXml(workDir), new LinkOption[0]) || workDir.toFile().list().length == 0;
    }

    @Override
    public Path getInstallationDirectory(AeshContext context) {
        String targetDirArg = (String)this.getValue("dir");
        Path workDir = PmSession.getWorkDir(context);
        try {
            return targetDirArg == null ? workDir : Util.resolvePath(context, targetDirArg);
        }
        catch (IOException ex) {
            CliLogging.exception(ex);
            return null;
        }
    }

    @Override
    public String getCommandClassName(PmSession session) throws ProvisioningException {
        return "org.jboss.galleon.cli.cmd.maingrp.core.CoreInstallCommand";
    }

    @Override
    protected PmCommandActivator getActivator() {
        return null;
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.PROVISIONING;
    }

    private static class ConfigOptionActivator
    implements OptionActivator {
        private ConfigOptionActivator() {
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck(InstallCommand.LAYERS_OPTION_NAME);
            return opt != null && opt.value() != null;
        }
    }

    private static class DefaultConfigsOptionActivator
    implements OptionActivator {
        private DefaultConfigsOptionActivator() {
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck(InstallCommand.LAYERS_OPTION_NAME);
            return opt == null || opt.value() == null;
        }
    }

    private static class LayersOptionActivator
    implements OptionActivator {
        private LayersOptionActivator() {
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck(InstallCommand.DEFAULT_CONFIGS_OPTION_NAME);
            return opt == null || opt.value() == null;
        }
    }

    private static class FileOptionActivator
    implements OptionActivator {
        private FileOptionActivator() {
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.argument();
            return opt == null || opt.value() == null;
        }
    }

    private static class ArgOptionActivator
    implements OptionActivator {
        private ArgOptionActivator() {
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck(InstallCommand.FILE_OPTION_NAME);
            return opt == null || opt.value() == null;
        }
    }

    public static class LayersCompleter
    extends AbstractCommaSeparatedCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            InstallCommand cmd = (InstallCommand)completerInvocation.getCommand();
            try {
                String model = cmd.getModel(completerInvocation.getPmSession());
                Path zipPath = cmd.getFeaturePackFilePath();
                FeaturePackLocation.FPID fpid = null;
                if (zipPath == null) {
                    Path install;
                    String loc = cmd.getFeaturePackLocation(completerInvocation.getPmSession());
                    if (loc != null && (install = cmd.getInstallationDirectory(completerInvocation.getAeshContext())) != null) {
                        Path p = PathsUtils.getProvisioningXml(install);
                        String coreVersion = APIVersion.getVersion();
                        if (Files.exists(p, new LinkOption[0])) {
                            coreVersion = completerInvocation.getPmSession().getGalleonBuilder().getCoreVersion(p);
                        }
                        fpid = completerInvocation.getPmSession().getGalleonContext(coreVersion).getResolvedLocation(install, loc).getFPID();
                    }
                } else {
                    fpid = ProvisioningUtil.getFeaturePackDescription(zipPath).getProducer();
                }
                if (fpid != null) {
                    ArrayList<String> ret = new ArrayList<String>();
                    String buffer = completerInvocation.getGivenCompleteValue();
                    HashSet<String> excluded = new HashSet<String>();
                    if (buffer != null) {
                        String[] arr;
                        for (String a : arr = buffer.split(",")) {
                            if (a.isEmpty()) continue;
                            excluded.add(a.trim());
                        }
                    }
                    FeaturePackLocation loc = fpid.getLocation();
                    String coreVersion = completerInvocation.getPmSession().getGalleonBuilder().getCoreVersion(loc);
                    GalleonCommandExecutionContext bridge = completerInvocation.getPmSession().getGalleonContext(coreVersion);
                    bridge.getLayers(model, loc, excluded);
                    ret.addAll(bridge.getLayers(model, loc, excluded));
                    return ret;
                }
            }
            catch (Exception ex) {
                CliLogging.error(ex.toString());
            }
            return null;
        }
    }
}

