/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.maven.plugin.util.Configuration;
import org.jboss.galleon.maven.plugin.util.ConfigurationId;
import org.jboss.galleon.maven.plugin.util.FeaturePack;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.maven.plugin.util.MvnMessageWriter;
import org.jboss.galleon.maven.plugin.util.ResolveLocalItem;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.xml.ConfigXmlParser;

@Mojo(name="provision", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_TEST_RESOURCES)
public class ProvisionStateMojo
extends AbstractMojo {
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Parameter(alias="install-dir", required=true)
    private File installDir;
    @Parameter(alias="custom-config", required=false)
    private File customConfig;
    @Parameter(alias="plugin-options", required=false)
    private Map<String, String> pluginOptions = Collections.emptyMap();
    @Parameter(alias="feature-packs", required=true)
    private List<FeaturePack> featurePacks = Collections.emptyList();
    @Parameter(alias="configurations", required=false)
    private List<Configuration> configs = Collections.emptyList();
    @Parameter(alias="offline", defaultValue="false")
    private boolean offline;
    @Parameter(alias="log-time", defaultValue="false")
    private boolean logTime;
    @Parameter(alias="record-state", defaultValue="true")
    private boolean recordState = true;
    @Parameter(alias="resolve-locals")
    private List<ResolveLocalItem> resolveLocals = Collections.emptyList();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.featurePacks.isEmpty()) {
            throw new MojoExecutionException("No feature-packs to install.");
        }
        String originalMavenRepoLocal = System.getProperty(MAVEN_REPO_LOCAL);
        System.setProperty(MAVEN_REPO_LOCAL, this.session.getSettings().getLocalRepository());
        try {
            this.doProvision();
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Provisioning failed", (Exception)((Object)e));
        }
        finally {
            if (originalMavenRepoLocal == null) {
                System.clearProperty(MAVEN_REPO_LOCAL);
            } else {
                System.setProperty(MAVEN_REPO_LOCAL, originalMavenRepoLocal);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doProvision() throws MojoExecutionException, ProvisioningException {
        ProvisioningConfig.Builder state = ProvisioningConfig.builder();
        MavenArtifactRepositoryManager artifactResolver = this.offline ? new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession) : new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
        Path home = this.installDir.toPath();
        if (!this.recordState) {
            IoUtils.recursiveDelete((Path)home);
        }
        try (ProvisioningManager pm = ((ProvisioningManager.Builder)ProvisioningManager.builder().addArtifactResolver((RepositoryArtifactResolver)artifactResolver)).setInstallationHome(home).setMessageWriter((MessageWriter)new MvnMessageWriter(this.getLog())).setLogTime(this.logTime).setRecordState(this.recordState).build();){
            Path path;
            for (FeaturePack featurePack : this.featurePacks) {
                void var8_17;
                FeaturePackConfig.Builder fpConfig;
                if (featurePack.getLocation() == null && (featurePack.getGroupId() == null || featurePack.getArtifactId() == null) && featurePack.getNormalizedPath() == null) {
                    throw new MojoExecutionException("Feature-pack location, Maven GAV or feature pack path is missing");
                }
                if (featurePack.getNormalizedPath() != null) {
                    FeaturePackLocation featurePackLocation = pm.getLayoutFactory().addLocal(featurePack.getNormalizedPath(), false);
                } else if (featurePack.getGroupId() != null && featurePack.getArtifactId() != null) {
                    path = this.resolveMaven(featurePack, artifactResolver);
                    FeaturePackLocation featurePackLocation = pm.getLayoutFactory().addLocal(path, false);
                } else {
                    FeaturePackLocation featurePackLocation = FeaturePackLocation.fromString((String)featurePack.getLocation());
                }
                FeaturePackConfig.Builder builder = fpConfig = featurePack.isTransitive() ? FeaturePackConfig.transitiveBuilder((FeaturePackLocation)var8_17) : FeaturePackConfig.builder((FeaturePackLocation)var8_17);
                if (featurePack.isInheritConfigs() != null) {
                    fpConfig.setInheritConfigs(featurePack.isInheritConfigs().booleanValue());
                }
                if (featurePack.isInheritPackages() != null) {
                    fpConfig.setInheritPackages(featurePack.isInheritPackages().booleanValue());
                }
                if (!featurePack.getExcludedConfigs().isEmpty()) {
                    for (ConfigurationId configId : featurePack.getExcludedConfigs()) {
                        if (configId.isModelOnly()) {
                            fpConfig.excludeConfigModel(configId.getId().getModel());
                            continue;
                        }
                        fpConfig.excludeDefaultConfig(configId.getId());
                    }
                }
                if (!featurePack.getIncludedConfigs().isEmpty()) {
                    for (ConfigurationId configId : featurePack.getIncludedConfigs()) {
                        if (configId.isModelOnly()) {
                            fpConfig.includeConfigModel(configId.getId().getModel());
                            continue;
                        }
                        fpConfig.includeDefaultConfig(configId.getId());
                    }
                }
                if (!featurePack.getIncludedPackages().isEmpty()) {
                    for (String includedPackage : featurePack.getIncludedPackages()) {
                        fpConfig.includePackage(includedPackage);
                    }
                }
                if (!featurePack.getExcludedPackages().isEmpty()) {
                    for (String excludedPackage : featurePack.getExcludedPackages()) {
                        fpConfig.excludePackage(excludedPackage);
                    }
                }
                state.addFeaturePackDep(fpConfig.build());
            }
            boolean hasLayers = false;
            for (Configuration configuration : this.configs) {
                ConfigModel.Builder configBuilder = ConfigModel.builder((String)configuration.getModel(), (String)configuration.getName());
                for (String layer : configuration.getLayers()) {
                    hasLayers = true;
                    configBuilder.includeLayer(layer);
                }
                state.addConfig(configBuilder.build());
            }
            if (hasLayers) {
                if (this.pluginOptions.isEmpty()) {
                    this.pluginOptions = Collections.singletonMap("optional-packages", "passive");
                } else if (!this.pluginOptions.containsKey("optional-packages")) {
                    this.pluginOptions.put("optional-packages", "passive");
                }
            }
            if (this.customConfig != null && this.customConfig.exists()) {
                try {
                    Throwable throwable = null;
                    try (BufferedReader bufferedReader = Files.newBufferedReader(this.customConfig.toPath());){
                        state.addConfig(ConfigXmlParser.getInstance().parse((Reader)bufferedReader));
                    }
                    catch (Throwable configBuilder) {
                        Throwable throwable2 = configBuilder;
                        throw configBuilder;
                    }
                }
                catch (IOException | XMLStreamException exception) {
                    throw new IllegalArgumentException("Couldn't load the customization configuration " + this.customConfig, exception);
                }
            }
            for (ResolveLocalItem resolveLocalItem : this.resolveLocals) {
                if (resolveLocalItem.getError() == null) continue;
                throw new MojoExecutionException(resolveLocalItem.getError());
            }
            for (ResolveLocalItem resolveLocalItem : this.resolveLocals) {
                if (resolveLocalItem.getNormalizedPath() != null) {
                    pm.getLayoutFactory().addLocal(resolveLocalItem.getNormalizedPath(), resolveLocalItem.getInstallInUniverse().booleanValue());
                    continue;
                }
                if (resolveLocalItem.hasArtifactCoords()) {
                    path = this.resolveMaven(resolveLocalItem, artifactResolver);
                    pm.getLayoutFactory().addLocal(path, false);
                    continue;
                }
                throw new MojoExecutionException("resolve-local element appears to be neither path not maven artifact");
            }
            pm.provision(state.build(), this.pluginOptions);
        }
    }

    private Path resolveMaven(ArtifactCoordinate coordinate, MavenRepoManager resolver) throws MavenUniverseException {
        MavenArtifact artifact = new MavenArtifact().setGroupId(coordinate.getGroupId()).setArtifactId(coordinate.getArtifactId()).setVersion(coordinate.getVersion()).setExtension(coordinate.getExtension()).setClassifier(coordinate.getClassifier());
        resolver.resolve(artifact);
        return artifact.getPath();
    }
}

