/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Singleton;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;

@Singleton
public class MavenPluginUtil
extends AbstractLogEnabled {
    public InstallRequest getInstallLayoutRequest(Path layoutDir, MavenProject project) throws IOException {
        File pomFile = project.getFile();
        Logger logger = this.getLogger();
        InstallRequest installReq = new InstallRequest();
        try (DirectoryStream<Path> wdStream = Files.newDirectoryStream(layoutDir, entry -> Files.isDirectory(entry, new LinkOption[0]));){
            for (Path groupDir : wdStream) {
                String groupId = groupDir.getFileName().toString();
                DirectoryStream<Path> groupStream = Files.newDirectoryStream(groupDir);
                try {
                    for (Path artifactDir : groupStream) {
                        String artifactId = artifactDir.getFileName().toString();
                        DirectoryStream<Path> artifactStream = Files.newDirectoryStream(artifactDir);
                        try {
                            for (Path versionDir : artifactStream) {
                                Path zippedFP;
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Preparing feature-pack " + versionDir.toAbsolutePath());
                                }
                                if (Files.exists(zippedFP = layoutDir.resolve(groupId + "_" + artifactId + "_" + versionDir.getFileName().toString() + ".zip"), new LinkOption[0])) {
                                    IoUtils.recursiveDelete((Path)zippedFP);
                                }
                                ZipUtils.zip((Path)versionDir, (Path)zippedFP);
                                DefaultArtifact artifact = new DefaultArtifact(groupDir.getFileName().toString(), artifactDir.getFileName().toString(), null, "zip", versionDir.getFileName().toString(), null, zippedFP.toFile());
                                Path target = Paths.get(project.getBuild().getDirectory(), new String[0]).resolve(project.getBuild().getFinalName() + ".zip");
                                IoUtils.copy((Path)zippedFP, (Path)target);
                                installReq.addArtifact((Artifact)artifact);
                                if (pomFile == null || !Files.exists(pomFile.toPath(), new LinkOption[0])) continue;
                                SubArtifact pomArtifact = new SubArtifact((Artifact)artifact, "", "pom");
                                pomArtifact = pomArtifact.setFile(pomFile);
                                installReq.addArtifact((Artifact)pomArtifact);
                            }
                        }
                        finally {
                            if (artifactStream == null) continue;
                            artifactStream.close();
                        }
                    }
                }
                finally {
                    if (groupStream == null) continue;
                    groupStream.close();
                }
            }
        }
        return installReq;
    }
}

