/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.maven.plugin.ProducerDescription;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenProducerDescription;
import org.jboss.galleon.universe.maven.MavenProducers;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.universe.maven.repo.SimplisticMavenRepoManager;

@Mojo(name="create-producers")
public class CreateProducersMojo
extends AbstractMojo {
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(required=true, defaultValue="${project.groupId}")
    private String groupId;
    @Parameter(required=true, defaultValue="${project.artifactId}")
    private String artifactId;
    @Parameter(required=true, defaultValue="${project.version}")
    private String version;
    @Parameter(required=true)
    private List<ProducerDescription> producers;
    @Parameter(defaultValue="false", property="galleon.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping the create-producers goal.");
            return;
        }
        MavenArtifact artifact = new MavenArtifact().setGroupId(this.groupId).setArtifactId(this.artifactId).setVersion(this.version);
        MavenProducers installer = MavenProducers.getInstance((MavenRepoManager)SimplisticMavenRepoManager.getInstance((Path)Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("local-repo"), (MavenRepoManager)new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories)), (MavenArtifact)artifact);
        for (ProducerDescription producer : this.producers) {
            installer.addProducer((MavenProducerDescription)producer);
        }
        try {
            installer.install();
        }
        catch (MavenUniverseException e) {
            throw new MojoExecutionException("Failed to create producers artifact", (Exception)((Object)e));
        }
        this.projectHelper.attachArtifact(this.project, "jar", artifact.getPath().toFile());
    }
}

