/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.APIVersion;
import org.jboss.galleon.api.Configuration;
import org.jboss.galleon.api.ConfigurationId;
import org.jboss.galleon.api.GalleonArtifactCoordinate;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.GalleonFeaturePack;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilder;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.maven.plugin.util.MvnMessageWriter;
import org.jboss.galleon.maven.plugin.util.ResolveLocalItem;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;

@Mojo(name="provision", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_TEST_RESOURCES)
public class ProvisionStateMojo
extends AbstractMojo {
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Parameter(alias="install-dir", required=true)
    private File installDir;
    @Parameter(alias="custom-config", required=false)
    private File customConfig;
    @Parameter(alias="plugin-options", required=false)
    private Map<String, String> pluginOptions = Collections.emptyMap();
    @Parameter(alias="feature-packs", required=true)
    private List<GalleonFeaturePack> featurePacks = Collections.emptyList();
    @Parameter(alias="configurations", required=false)
    private List<Configuration> configs = Collections.emptyList();
    @Parameter(alias="offline", defaultValue="false")
    private boolean offline;
    @Parameter(alias="log-time", defaultValue="false")
    private boolean logTime;
    @Parameter(alias="record-state", defaultValue="true")
    private boolean recordState = true;
    @Parameter(alias="resolve-locals")
    private List<ResolveLocalItem> resolveLocals = Collections.emptyList();
    @Parameter(defaultValue="false", property="galleon.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping the provision goal.");
            return;
        }
        String vers = APIVersion.checkForLatestVersion();
        if (vers != null) {
            this.getLog().warn((CharSequence)("A new version of Galleon is available, you should update your dependency to " + vers));
        }
        if (this.featurePacks.isEmpty()) {
            throw new MojoExecutionException("No feature-packs to install.");
        }
        String originalMavenRepoLocal = System.getProperty(MAVEN_REPO_LOCAL);
        System.setProperty(MAVEN_REPO_LOCAL, this.session.getSettings().getLocalRepository());
        try {
            this.doProvision();
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Provisioning failed", (Exception)((Object)e));
        }
        finally {
            if (originalMavenRepoLocal == null) {
                System.clearProperty(MAVEN_REPO_LOCAL);
            } else {
                System.setProperty(MAVEN_REPO_LOCAL, originalMavenRepoLocal);
            }
        }
    }

    private void doProvision() throws MojoExecutionException, ProvisioningException {
        MavenArtifactRepositoryManager artifactResolver = this.offline ? new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession) : new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
        Path home = this.installDir.toPath();
        if (!this.recordState) {
            IoUtils.recursiveDelete((Path)home);
        }
        GalleonBuilder provider = new GalleonBuilder();
        provider.addArtifactResolver((RepositoryArtifactResolver)artifactResolver);
        GalleonProvisioningConfig.Builder state = GalleonProvisioningConfig.builder();
        for (GalleonFeaturePack galleonFeaturePack : this.featurePacks) {
            GalleonFeaturePackConfig.Builder fpConfig;
            FeaturePackLocation fpl;
            if (galleonFeaturePack.getLocation() == null && (galleonFeaturePack.getGroupId() == null || galleonFeaturePack.getArtifactId() == null) && galleonFeaturePack.getNormalizedPath() == null) {
                throw new MojoExecutionException("Feature-pack location, Maven GAV or feature pack path is missing");
            }
            if (galleonFeaturePack.getNormalizedPath() != null) {
                fpl = provider.addLocal(galleonFeaturePack.getNormalizedPath(), false);
            } else if (galleonFeaturePack.getGroupId() != null && galleonFeaturePack.getArtifactId() != null) {
                Path path = this.resolveMaven((GalleonArtifactCoordinate)galleonFeaturePack, artifactResolver);
                fpl = provider.addLocal(path, false);
            } else {
                fpl = FeaturePackLocation.fromString((String)galleonFeaturePack.getLocation());
            }
            GalleonFeaturePackConfig.Builder builder = fpConfig = galleonFeaturePack.isTransitive() ? GalleonFeaturePackConfig.transitiveBuilder((FeaturePackLocation)fpl) : GalleonFeaturePackConfig.builder((FeaturePackLocation)fpl);
            if (galleonFeaturePack.isInheritConfigs() != null) {
                fpConfig.setInheritConfigs(galleonFeaturePack.isInheritConfigs().booleanValue());
            }
            if (galleonFeaturePack.isInheritPackages() != null) {
                fpConfig.setInheritPackages(galleonFeaturePack.isInheritPackages().booleanValue());
            }
            if (!galleonFeaturePack.getExcludedConfigs().isEmpty()) {
                for (ConfigurationId configId : galleonFeaturePack.getExcludedConfigs()) {
                    if (configId.isModelOnly()) {
                        fpConfig.excludeConfigModel(configId.getId().getModel());
                        continue;
                    }
                    fpConfig.excludeDefaultConfig(configId.getId());
                }
            }
            if (!galleonFeaturePack.getIncludedConfigs().isEmpty()) {
                for (ConfigurationId configId : galleonFeaturePack.getIncludedConfigs()) {
                    if (configId.isModelOnly()) {
                        fpConfig.includeConfigModel(configId.getId().getModel());
                        continue;
                    }
                    fpConfig.includeDefaultConfig(configId.getId());
                }
            }
            if (!galleonFeaturePack.getIncludedPackages().isEmpty()) {
                for (String includedPackage : galleonFeaturePack.getIncludedPackages()) {
                    fpConfig.includePackage(includedPackage);
                }
            }
            if (!galleonFeaturePack.getExcludedPackages().isEmpty()) {
                for (String excludedPackage : galleonFeaturePack.getExcludedPackages()) {
                    fpConfig.excludePackage(excludedPackage);
                }
            }
            state.addFeaturePackDep(fpConfig.build());
        }
        for (ResolveLocalItem resolveLocalItem : this.resolveLocals) {
            if (resolveLocalItem.getError() == null) continue;
            throw new MojoExecutionException(resolveLocalItem.getError());
        }
        for (ResolveLocalItem resolveLocalItem : this.resolveLocals) {
            if (resolveLocalItem.getNormalizedPath() != null) {
                provider.addLocal(resolveLocalItem.getNormalizedPath(), resolveLocalItem.getInstallInUniverse().booleanValue());
                continue;
            }
            if (resolveLocalItem.hasArtifactCoords()) {
                Path path = this.resolveMaven(resolveLocalItem, artifactResolver);
                provider.addLocal(path, false);
                continue;
            }
            throw new MojoExecutionException("resolve-local element appears to be neither path not maven artifact");
        }
        boolean hasLayers = false;
        for (Configuration config2 : this.configs) {
            hasLayers = !config2.getLayers().isEmpty();
            GalleonConfigurationWithLayersBuilder configBuilder = GalleonConfigurationWithLayersBuilder.builder((String)config2.getModel(), (String)config2.getName());
            for (String layer : config2.getLayers()) {
                hasLayers = true;
                configBuilder.includeLayer(layer);
            }
            if (config2.getExcludedLayers() != null) {
                for (String layer : config2.getExcludedLayers()) {
                    configBuilder.excludeLayer(layer);
                }
            }
            state.addConfig(configBuilder.build());
        }
        if (hasLayers) {
            if (this.pluginOptions.isEmpty()) {
                this.pluginOptions = Collections.singletonMap("optional-packages", "passive+");
            } else if (!this.pluginOptions.containsKey("optional-packages")) {
                this.pluginOptions.put("optional-packages", "passive+");
            }
        }
        state.addOptions(this.pluginOptions);
        ArrayList<Path> arrayList = new ArrayList<Path>();
        if (this.customConfig != null && this.customConfig.exists()) {
            arrayList.add(this.customConfig.toPath());
        }
        GalleonProvisioningConfig config = state.build();
        try (Provisioning pm = provider.newProvisioningBuilder(config).setInstallationHome(home).setMessageWriter((MessageWriter)new MvnMessageWriter(this.getLog())).setLogTime(this.logTime).setRecordState(this.recordState).build();){
            pm.provision(config, arrayList, this.pluginOptions);
        }
    }

    private Path resolveMaven(GalleonArtifactCoordinate coordinate, MavenRepoManager resolver) throws MavenUniverseException, MojoExecutionException {
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(coordinate.getGroupId());
        artifact.setArtifactId(coordinate.getArtifactId());
        String version = coordinate.getVersion();
        if (this.isEmptyOrNull(version)) {
            for (Artifact a : this.project.getArtifacts()) {
                if (!coordinate.getArtifactId().equals(a.getArtifactId()) || !coordinate.getGroupId().equals(a.getGroupId()) || !coordinate.getExtension().equals(a.getType()) || !(coordinate.getClassifier() == null ? "" : coordinate.getClassifier()).equals(a.getClassifier() == null ? "" : a.getClassifier())) continue;
                version = a.getVersion();
                break;
            }
            if (this.isEmptyOrNull(version)) {
                for (Dependency d : this.project.getDependencyManagement().getDependencies()) {
                    if (!coordinate.getArtifactId().equals(d.getArtifactId()) || !coordinate.getGroupId().equals(d.getGroupId()) || !coordinate.getExtension().equals(d.getType()) || !(coordinate.getClassifier() == null ? "" : coordinate.getClassifier()).equals(d.getClassifier() == null ? "" : d.getClassifier())) continue;
                    version = d.getVersion();
                    break;
                }
                if (this.isEmptyOrNull(version)) {
                    throw new MojoExecutionException(coordinate.getGroupId() + ":" + coordinate.getArtifactId() + ":" + (coordinate.getClassifier() == null ? "" : coordinate.getClassifier()) + ":" + coordinate.getExtension() + " was found among neither the project's dependencies nor the managed dependencies. To proceed, please, add the desired version of the feature-pack to the provisioning configuration or the project dependencies, or the dependency management section of the Maven project");
                }
            }
        }
        artifact.setVersion(version);
        artifact.setExtension(coordinate.getExtension());
        artifact.setClassifier(coordinate.getClassifier());
        resolver.resolve(artifact);
        return artifact.getPath();
    }

    private boolean isEmptyOrNull(String version) {
        return version == null || version.isEmpty();
    }
}

