/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin.util;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.galleon.maven.plugin.FpMavenErrors;
import org.jboss.galleon.repo.RepositoryArtifactInstaller;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenLatestVersionNotAvailableException;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.LocalArtifactVersionRangeResolver;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersion;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRange;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRangeParser;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;

public abstract class AbstractMavenArtifactRepositoryManager
implements MavenRepoManager,
RepositoryArtifactInstaller {
    private static final MavenArtifactVersionRangeParser versionRangeParser = new MavenArtifactVersionRangeParser();
    private final RepositorySystem repoSystem;
    private LocalArtifactVersionRangeResolver localRangeResolver;

    public AbstractMavenArtifactRepositoryManager(RepositorySystem repoSystem) {
        this.repoSystem = repoSystem;
    }

    protected abstract RepositorySystemSession getSession() throws MavenUniverseException;

    protected abstract List<RemoteRepository> getRepositories() throws MavenUniverseException;

    protected RepositorySystem getRepositorySystem() {
        return this.repoSystem;
    }

    public void resolve(MavenArtifact artifact) throws MavenUniverseException {
        ArtifactResult result;
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already resolved");
        }
        ArtifactRequest request = this.toArtifactRequest(artifact);
        request.setRepositories(this.getRepositories());
        try {
            result = this.repoSystem.resolveArtifact(this.getSession(), request);
        }
        catch (Exception e) {
            throw new MavenUniverseException(FpMavenErrors.artifactResolution(request.getArtifact().toString()), (Throwable)e);
        }
        if (!result.isResolved()) {
            throw new MavenUniverseException(FpMavenErrors.artifactResolution(request.getArtifact().toString()));
        }
        if (result.isMissing()) {
            throw new MavenUniverseException(FpMavenErrors.artifactMissing(request.getArtifact().toString()));
        }
        artifact.setPath(Paths.get(result.getArtifact().getFile().toURI()));
    }

    public void resolveAll(Collection<MavenArtifact> artifacts) throws MavenUniverseException {
        if (artifacts.stream().anyMatch(MavenArtifact::isResolved)) {
            throw new MavenUniverseException("One of artifact is already resolved");
        }
        ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();
        ArrayList<MavenArtifact> orderedArtifacts = new ArrayList<MavenArtifact>();
        for (MavenArtifact artifact : artifacts) {
            requests.add(this.toArtifactRequest(artifact));
            orderedArtifacts.add(artifact);
        }
        try {
            List artifactResults = this.repoSystem.resolveArtifacts(this.getSession(), requests);
            for (int i = 0; i < artifactResults.size(); ++i) {
                ArtifactResult result = (ArtifactResult)artifactResults.get(i);
                if (!result.isResolved()) {
                    throw new MavenUniverseException(FpMavenErrors.artifactResolution(result.getArtifact().toString()));
                }
                if (result.isMissing()) {
                    throw new MavenUniverseException(FpMavenErrors.artifactMissing(result.getArtifact().toString()));
                }
                ((MavenArtifact)orderedArtifacts.get(i)).setPath(Paths.get(result.getArtifact().getFile().toURI()));
            }
        }
        catch (Exception e) {
            throw new MavenUniverseException(FpMavenErrors.artifactResolution(), (Throwable)e);
        }
    }

    private ArtifactRequest toArtifactRequest(MavenArtifact artifact) throws MavenUniverseException {
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion()));
        request.setRepositories(this.getRepositories());
        return request;
    }

    public void resolveLatestVersion(MavenArtifact mavenArtifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        mavenArtifact.setVersion(this.doGetHighestVersion(mavenArtifact, lowestQualifier, false, null, null));
        this.resolve(mavenArtifact);
    }

    public void resolveLatestVersion(MavenArtifact mavenArtifact, String lowestQualifier, boolean locallyAvailable) throws MavenUniverseException {
        mavenArtifact.setVersion(this.doGetHighestVersion(mavenArtifact, lowestQualifier, locallyAvailable, null, null));
        this.resolve(mavenArtifact);
    }

    private VersionRangeResult getVersionRange(Artifact artifact) throws MavenUniverseException {
        VersionRangeResult rangeResult;
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(this.getRepositories());
        try {
            rangeResult = this.repoSystem.resolveVersionRange(this.getSession(), rangeRequest);
        }
        catch (VersionRangeResolutionException ex) {
            throw new MavenUniverseException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        return rangeResult;
    }

    private String doGetHighestVersion(MavenArtifact mavenArtifact, String lowestQualifier, boolean locallyAvailable, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        MavenArtifactVersion latest;
        if (locallyAvailable) {
            if (this.localRangeResolver == null) {
                this.localRangeResolver = new LocalArtifactVersionRangeResolver(this.getSession().getLocalRepository().getBasedir().toPath());
            }
            return this.localRangeResolver.getLatestVersion(mavenArtifact, lowestQualifier, includeVersion, excludeVersion);
        }
        VersionRangeResult rangeResult = this.getVersionRange((Artifact)new DefaultArtifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getExtension(), mavenArtifact.getVersionRange()));
        MavenArtifactVersion mavenArtifactVersion = latest = rangeResult == null ? null : MavenArtifactVersion.getLatest((Iterable)rangeResult.getVersions(), (String)lowestQualifier, (Pattern)includeVersion, (Pattern)excludeVersion);
        if (latest == null) {
            throw new MavenLatestVersionNotAvailableException(MavenErrors.failedToResolveLatestVersion((String)mavenArtifact.getCoordsAsString()));
        }
        return latest.toString();
    }

    public String getLatestVersion(MavenArtifact mavenArtifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        return this.doGetHighestVersion(mavenArtifact, lowestQualifier, false, includeVersion, excludeVersion);
    }

    public String getLatestVersion(MavenArtifact mavenArtifact, String lowestQualifier) throws MavenUniverseException {
        return this.doGetHighestVersion(mavenArtifact, lowestQualifier, false, null, null);
    }

    public String getLatestVersion(MavenArtifact mavenArtifact) throws MavenUniverseException {
        return this.getLatestVersion(mavenArtifact, null);
    }

    public List<String> getAllVersions(MavenArtifact mavenArtifact) throws MavenUniverseException {
        return this.getAllVersions(mavenArtifact, null, null);
    }

    public List<String> getAllVersions(MavenArtifact mavenArtifact, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        DefaultArtifact artifact = new DefaultArtifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getExtension(), mavenArtifact.getVersionRange());
        VersionRangeResult rangeResult = this.getVersionRange((Artifact)artifact);
        ArrayList<String> versions = new ArrayList<String>();
        for (Version v : rangeResult.getVersions()) {
            String vString = v.toString();
            if (includeVersion != null && !includeVersion.matcher(vString).matches() || excludeVersion != null && excludeVersion.matcher(vString).matches()) continue;
            versions.add(vString);
        }
        return versions;
    }

    public void install(String coords, Path path) throws MavenUniverseException {
        this.install(MavenArtifact.fromString((String)coords), path);
    }

    public void install(MavenArtifact coords, Path path) throws MavenUniverseException {
        InstallRequest request = new InstallRequest();
        request.addArtifact((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion(), Collections.emptyMap(), path.toFile()));
        try {
            this.repoSystem.install(this.getSession(), request);
        }
        catch (InstallationException ex) {
            throw new MavenUniverseException("Failed to install " + coords.getCoordsAsString(), (Throwable)ex);
        }
    }

    public boolean isResolved(MavenArtifact artifact) throws MavenUniverseException {
        if (artifact.isResolved()) {
            return true;
        }
        Path path = this.getArtifactPath(artifact);
        return Files.exists(path, new LinkOption[0]);
    }

    private Path getArtifactPath(MavenArtifact artifact) throws MavenUniverseException {
        String[] groupParts;
        if (artifact.getGroupId() == null) {
            MavenErrors.missingGroupId();
        }
        Path p = this.getSession().getLocalRepository().getBasedir().toPath();
        for (String part : groupParts = artifact.getGroupId().split("\\.")) {
            p = p.resolve(part);
        }
        String artifactFileName = artifact.getArtifactFileName();
        return p.resolve(artifact.getArtifactId()).resolve(artifact.getVersion()).resolve(artifactFileName);
    }

    public boolean isLatestVersionResolved(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        if (artifact.isResolved()) {
            return true;
        }
        Path path = this.resolveLatestVersionDir(artifact, lowestQualifier);
        return Files.exists(path, new LinkOption[0]);
    }

    private Path resolveLatestVersionDir(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        String[] groupParts;
        Path repoHome;
        if (artifact.getGroupId() == null) {
            MavenErrors.missingGroupId();
        }
        if (artifact.getArtifactId() == null) {
            MavenErrors.missingArtifactId();
        }
        if (artifact.getVersionRange() == null) {
            throw new MavenUniverseException("Version range is missing for " + artifact.getCoordsAsString());
        }
        Path artifactDir = repoHome = this.getSession().getLocalRepository().getBasedir().toPath();
        for (String part : groupParts = artifact.getGroupId().split("\\.")) {
            artifactDir = artifactDir.resolve(part);
        }
        if (!Files.exists(artifactDir = artifactDir.resolve(artifact.getArtifactId()), new LinkOption[0])) {
            throw MavenErrors.artifactNotFound((MavenArtifact)artifact, (Path)repoHome);
        }
        MavenArtifactVersionRange range = versionRangeParser.parseRange(artifact.getVersionRange());
        if (lowestQualifier == null) {
            lowestQualifier = "";
        }
        Path latestDir = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(artifactDir);){
            MavenArtifactVersion latest = null;
            for (Path versionDir : stream) {
                MavenArtifactVersion next;
                if (!Files.isDirectory(versionDir, new LinkOption[0]) || !range.includesVersion(next = new MavenArtifactVersion(versionDir.getFileName().toString())) || !next.isQualifierHigher(lowestQualifier, true) || latest != null && latest.compareTo(next) > 0) continue;
                latest = next;
                latestDir = versionDir;
            }
        }
        catch (Exception e) {
            throw new MavenUniverseException("Failed to determine the latest version of " + artifact.getCoordsAsString(), (Throwable)e);
        }
        if (latestDir == null) {
            throw new MavenUniverseException("Failed to determine the latest version of " + artifact.getCoordsAsString());
        }
        return latestDir;
    }
}

