/*
 * Copyright 2016-2018 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.galleon.universe;

import java.util.Collection;

import org.jboss.galleon.ProvisioningException;

/**
 * Feature-pack producer
 *
 * @author Alexey Loubyansky
 */
public interface Producer<C extends Channel> {

    String getName();

    boolean hasFrequencies();

    Collection<String> getFrequencies();

    boolean hasChannel(String name) throws ProvisioningException;

    C getChannel(String name) throws ProvisioningException;

    Collection<C> getChannels() throws ProvisioningException;
}
