/*
 * Copyright 2016-2018 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.galleon.cli.tracking;

import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.universe.FeaturePackLocation.ProducerSpec;

/**
 *
 * @author jdenise@redhat.com
 */
public class UpdatesTracker extends CliProgressTracker<ProducerSpec> {

    private final PmSession session;

    public UpdatesTracker(PmSession session) {
        super("Looking for update for", null);
        this.session = session;
    }

    @Override
    protected String processingContent(ProgressTracker<ProducerSpec> tracker) {
        return session.getExposedLocation(tracker.getItem().getLocation()).toString();
    }

    @Override
    protected String completeContent(ProgressTracker<ProducerSpec> tracker) {
        // No complete message, the command itself adds one.
        return null;
    }

}
