/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.arquillian.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.jboss.gravia.arquillian.container.ContainerLogger;
import org.jboss.gravia.arquillian.container.ContainerSetup;
import org.jboss.gravia.arquillian.container.ContainerSetupTask;
import org.jboss.gravia.repository.RepositoryMBean;
import org.jboss.gravia.utils.MBeanProxy;

public class ContainerSetupObserver {
    public static final String PROPERTY_JMX_SERVICE_URL = "jmxServiceURL";
    public static final String PROPERTY_JMX_USERNAME = "jmxUsername";
    public static final String PROPERTY_JMX_PASSWORD = "jmxPassword";
    @Inject
    private Instance<ClassContext> classContextInstance;
    @Inject
    @ApplicationScoped
    private InstanceProducer<MBeanServerConnection> mbeanServerInstance;
    @Inject
    @ApplicationScoped
    private InstanceProducer<RepositoryMBean> repositoryInstance;
    private List<ContainerSetupTask> setupTasks;

    public void handleAfterStart(@Observes AfterStart event, Container container) throws Throwable {
        MBeanServerConnection mbeanServer = this.getMBeanServerConnection(container);
        if (mbeanServer != null) {
            this.mbeanServerInstance.set((Object)mbeanServer);
            if (mbeanServer.isRegistered(RepositoryMBean.OBJECT_NAME)) {
                RepositoryMBean repository = (RepositoryMBean)MBeanProxy.get((MBeanServerConnection)mbeanServer, (ObjectName)RepositoryMBean.OBJECT_NAME, RepositoryMBean.class);
                this.repositoryInstance.set((Object)repository);
            }
        }
    }

    public void handleBeforeDeploy(@Observes BeforeDeploy event, Container container) throws Throwable {
        Class<? extends ContainerSetupTask>[] classes;
        ClassContext classContext = (ClassContext)this.classContextInstance.get();
        Class currentClass = (Class)classContext.getActiveId();
        ContainerSetup setup = currentClass.getAnnotation(ContainerSetup.class);
        if (setup == null || this.setupTasks != null) {
            return;
        }
        this.setupTasks = new ArrayList<ContainerSetupTask>();
        for (Class<? extends ContainerSetupTask> clazz : classes = setup.value()) {
            this.setupTasks.add(clazz.newInstance());
        }
        MBeanServerConnection server = (MBeanServerConnection)this.mbeanServerInstance.get();
        Map props = container.getContainerConfiguration().getContainerProperties();
        for (ContainerSetupTask task : this.setupTasks) {
            task.setUp(server, props);
        }
    }

    public void handleBeforeStop(@Observes BeforeStop event, Container container) throws Throwable {
        if (this.setupTasks != null) {
            Collections.reverse(this.setupTasks);
            MBeanServerConnection server = (MBeanServerConnection)this.mbeanServerInstance.get();
            Map props = container.getContainerConfiguration().getContainerProperties();
            for (ContainerSetupTask task : this.setupTasks) {
                task.tearDown(server, props);
            }
        }
    }

    private MBeanServerConnection getMBeanServerConnection(Container container) throws IOException {
        Map props = container.getContainerConfiguration().getContainerProperties();
        String jmxServiceURL = (String)props.get(PROPERTY_JMX_SERVICE_URL);
        String jmxUsername = (String)props.get(PROPERTY_JMX_USERNAME);
        String jmxPassword = (String)props.get(PROPERTY_JMX_PASSWORD);
        MBeanServerConnection mbeanServer = null;
        if (jmxServiceURL == null) {
            ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
            if (serverArr.size() > 1) {
                ContainerLogger.LOGGER.warn("Multiple MBeanServer instances: {}", serverArr);
            }
            if (serverArr.size() > 0) {
                mbeanServer = (MBeanServerConnection)serverArr.get(0);
                ContainerLogger.LOGGER.debug("Found MBeanServer: {}", (Object)mbeanServer.getDefaultDomain());
            }
        } else {
            try {
                JMXServiceURL serviceURL = new JMXServiceURL(jmxServiceURL);
                HashMap<String, String[]> env = new HashMap<String, String[]>();
                if (jmxUsername != null && jmxPassword != null) {
                    String[] credentials = new String[]{jmxUsername, jmxPassword};
                    env.put("jmx.remote.credentials", credentials);
                }
                JMXConnector connector = JMXConnectorFactory.connect(serviceURL, env);
                mbeanServer = connector.getMBeanServerConnection();
            }
            catch (Exception ex) {
                ContainerLogger.LOGGER.warn("Cannot create JMXServiceURL from: {}", (Object)jmxServiceURL);
            }
        }
        return mbeanServer;
    }
}

