/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.arquillian.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.jboss.gravia.repository.DefaultRepositoryXMLReader;
import org.jboss.gravia.repository.RepositoryMBean;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.utils.MBeanProxy;

public abstract class ContainerSetupTask {
    protected void setUp(MBeanServerConnection server, Map<String, String> props) throws Exception {
        if (server != null && server.isRegistered(RepositoryMBean.OBJECT_NAME)) {
            RepositoryMBean repository = (RepositoryMBean)MBeanProxy.get((MBeanServerConnection)server, (ObjectName)RepositoryMBean.OBJECT_NAME, RepositoryMBean.class);
            this.setupRepositoryContent(server, repository, props);
        }
    }

    protected void tearDown(MBeanServerConnection server, Map<String, String> props) throws Exception {
        if (server != null && server.isRegistered(RepositoryMBean.OBJECT_NAME)) {
            RepositoryMBean repository = (RepositoryMBean)MBeanProxy.get((MBeanServerConnection)server, (ObjectName)RepositoryMBean.OBJECT_NAME, RepositoryMBean.class);
            this.removeRepositoryContent(server, repository, props);
        }
    }

    protected String[] getInitialFeatureNames() {
        return new String[0];
    }

    protected void setupRepositoryContent(MBeanServerConnection server, RepositoryMBean repository, Map<String, String> props) throws IOException {
        for (String name : this.getInitialFeatureNames()) {
            String resname = "META-INF/repository-content/" + name + ".feature.xml";
            URL resurl = this.getClass().getClassLoader().getResource(resname);
            InputStream input = resurl.openStream();
            DefaultRepositoryXMLReader reader = new DefaultRepositoryXMLReader(input);
            Resource auxres = reader.nextResource();
            while (auxres != null) {
                String identity = auxres.getIdentity().toString();
                if (repository.getResource(identity) == null) {
                    repository.addResource((CompositeData)auxres.adapt(CompositeData.class));
                }
                auxres = reader.nextResource();
            }
        }
    }

    protected void removeRepositoryContent(MBeanServerConnection server, RepositoryMBean repository, Map<String, String> props) throws IOException {
        for (String name : this.getInitialFeatureNames()) {
            String resname = "META-INF/repository-content/" + name + ".feature.xml";
            URL resurl = this.getClass().getClassLoader().getResource(resname);
            InputStream input = resurl.openStream();
            DefaultRepositoryXMLReader reader = new DefaultRepositoryXMLReader(input);
            Resource auxres = reader.nextResource();
            while (auxres != null) {
                String identity = auxres.getIdentity().toString();
                repository.removeResource(identity);
                auxres = reader.nextResource();
            }
        }
    }
}

