/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resolver.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.gravia.resolver.ResolutionException;
import org.jboss.gravia.resolver.ResolveContext;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.Wire;
import org.jboss.gravia.resource.Wiring;
import org.jboss.gravia.resource.spi.AbstractResource;
import org.jboss.gravia.resource.spi.AbstractWire;
import org.jboss.gravia.resource.spi.AbstractWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResolver
implements Resolver {
    static final Logger LOGGER = LoggerFactory.getLogger((String)Resolver.class.getPackage().getName());

    protected abstract AbstractWire createWire(Requirement var1, Capability var2);

    protected abstract AbstractWiring createWiring(Resource var1, List<Wire> var2, List<Wire> var3);

    @Override
    public Map<Resource, List<Wire>> resolve(ResolveContext context) throws ResolutionException {
        return this.resolveInternal(context, false);
    }

    @Override
    public Map<Resource, List<Wire>> resolveAndApply(ResolveContext context) throws ResolutionException {
        return this.resolveInternal(context, true);
    }

    ResourceSpaces createResourceSpaces(ResolveContext context) {
        return new ResourceSpaces(context);
    }

    ResourceCandidates createResourceCandidates(Resource res) {
        return new ResourceCandidates(res);
    }

    private Map<Resource, List<Wire>> resolveInternal(ResolveContext context, boolean apply) throws ResolutionException {
        LOGGER.debug("Resolve: mandatory{} optional{}", context.getMandatoryResources(), context.getOptionalResources());
        LinkedHashSet<Resource> combined = new LinkedHashSet<Resource>();
        combined.addAll(context.getMandatoryResources());
        combined.addAll(context.getOptionalResources());
        ResolverState state = new ResolverState(context);
        for (Resource res : combined) {
            this.resolveResource(state, res);
        }
        Map<Resource, List<Wire>> resourceWires = state.getResult();
        if (LOGGER.isDebugEnabled()) {
            for (Map.Entry<Resource, List<Wire>> entry : resourceWires.entrySet()) {
                LOGGER.debug("Resolved: {}", (Object)entry.getKey());
                for (Wire wire : entry.getValue()) {
                    LOGGER.debug("   {}", (Object)wire);
                }
            }
        }
        if (apply) {
            for (Map.Entry<Resource, List<Wire>> entry : resourceWires.entrySet()) {
                AbstractResource requirer = (AbstractResource)entry.getKey();
                List<Wire> reqwires = entry.getValue();
                AbstractWiring reqwiring = (AbstractWiring)requirer.getWiring();
                if (reqwiring == null) {
                    reqwiring = this.createWiring((Resource)requirer, reqwires, null);
                    requirer.setWiring((Wiring)reqwiring);
                } else {
                    for (Wire wire : reqwires) {
                        reqwiring.addRequiredWire(wire);
                    }
                }
                for (Wire wire : reqwires) {
                    AbstractResource provider = (AbstractResource)wire.getProvider();
                    AbstractWiring provwiring = (AbstractWiring)provider.getWiring();
                    if (provwiring == null) {
                        provwiring = this.createWiring((Resource)provider, null, null);
                        provider.setWiring((Wiring)provwiring);
                    }
                    provwiring.addProvidedWire(wire);
                }
            }
        }
        return resourceWires;
    }

    private ResourceSpace resolveResource(ResolverState state, Resource res) throws ResolutionException {
        ResourceSpaces spaces = state.getResourceSpaces();
        ResourceSpace resspace = spaces.getResourceSpace(res);
        if (resspace != null) {
            return resspace;
        }
        ResourceCandidates rescan = new ResourceCandidates(res);
        Iterator<List<Wire>> itres = rescan.iterator(state.getResolveContext());
        while (itres.hasNext()) {
            ResourceSpace space = new ResourceSpace(res);
            List<Wire> wires = itres.next();
            boolean allgood = true;
            for (Wire wire : wires) {
                Resource provider = wire.getProvider();
                ResourceSpace provspace = this.resolveResource(state, provider);
                if (space.addDependencySpace(provspace)) continue;
                allgood = false;
                break;
            }
            if (!allgood) continue;
            spaces.addResourceSpace(space);
            state.getResult().put(res, wires);
            return space;
        }
        ResolutionException resex = rescan.getResolutionException();
        if (resex != null) {
            throw resex;
        }
        if (spaces.getResourceSpace(res) == null) {
            List manreqs = res.getRequirements(null);
            Iterator itreqs = manreqs.iterator();
            while (itreqs.hasNext()) {
                if (!((Requirement)itreqs.next()).isOptional()) continue;
                itreqs.remove();
            }
            throw new ResolutionException("Requirements map to candidates in disconnetced spaces", null, manreqs);
        }
        return null;
    }

    class RequirementCandidates {
        private final Requirement req;

        RequirementCandidates(Requirement req) {
            this.req = req;
        }

        Iterator<Wire> iterator(ResolveContext context) throws ResolutionException {
            Collection<Resource> optres = context.getOptionalResources();
            final List<Capability> providers = context.findProviders(this.req);
            if (!optres.contains(this.req.getResource()) && !this.req.isOptional() && providers.isEmpty()) {
                Set<Requirement> unresolved = Collections.singleton(this.req);
                throw new ResolutionException("Cannot find provider for: " + this.req, null, unresolved);
            }
            return new Iterator<Wire>(){
                Iterator<Capability> delagate;
                {
                    this.delagate = providers.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.delagate.hasNext();
                }

                @Override
                public Wire next() {
                    Capability cap = this.delagate.next();
                    return AbstractResolver.this.createWire(RequirementCandidates.this.req, cap);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    class ResourceCandidates {
        private final Resource res;
        private ResolutionException resolutionException;

        ResourceCandidates(Resource res) {
            this.res = res;
        }

        ResolutionException getResolutionException() {
            return this.resolutionException;
        }

        Iterator<List<Wire>> iterator(final ResolveContext context) throws ResolutionException {
            return new Iterator<List<Wire>>(){
                private List<Iterator<Wire>> candidates = new ArrayList<Iterator<Wire>>();
                private List<Requirement> reqs = ResourceCandidates.access$000(ResourceCandidates.this).getRequirements(null);
                private Map<Requirement, Wire> wires;
                private boolean hasNext;

                @Override
                public boolean hasNext() {
                    try {
                        if (this.wires == null) {
                            this.wires = new LinkedHashMap<Requirement, Wire>();
                            this.initWiremap(context, 0);
                            this.hasNext = true;
                            return true;
                        }
                        for (int index = this.reqs.size() - 1; index >= 0; --index) {
                            if (this.candidates.get(index).hasNext()) {
                                Wire wire = this.candidates.get(index).next();
                                Requirement req = wire.getRequirement();
                                this.wires.put(req, wire);
                                this.hasNext = true;
                                return true;
                            }
                            if (index <= 0 || !this.candidates.get(index - 1).hasNext()) continue;
                            this.initWiremap(context, index);
                        }
                    }
                    catch (ResolutionException ex) {
                        ResourceCandidates.this.resolutionException = ex;
                    }
                    this.hasNext = false;
                    return false;
                }

                private void initWiremap(ResolveContext context2, int start) throws ResolutionException {
                    for (int i = start; i < this.reqs.size(); ++i) {
                        Requirement req = this.reqs.get(i);
                        RequirementCandidates reqcan = new RequirementCandidates(req);
                        Iterator<Wire> itcan = reqcan.iterator(context2);
                        if (start == 0) {
                            this.candidates.add(itcan);
                        } else {
                            this.candidates.set(i, itcan);
                        }
                        if (!itcan.hasNext()) continue;
                        this.wires.put(req, itcan.next());
                    }
                }

                @Override
                public List<Wire> next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    ArrayList<Wire> next = new ArrayList<Wire>(this.wires.values());
                    return Collections.unmodifiableList(next);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        static /* synthetic */ Resource access$000(ResourceCandidates x0) {
            return x0.res;
        }
    }

    class ResourceSpace {
        private final Resource primary;
        private final Map<String, Resource> resources = new LinkedHashMap<String, Resource>();

        ResourceSpace(Resource primary) {
            this.primary = primary;
            String uniquekey = primary.getIdentity().getSymbolicName();
            this.resources.put(uniquekey, primary);
            Wiring wiring = primary.getWiring();
            if (wiring != null) {
                for (Wire wire : wiring.getRequiredResourceWires(null)) {
                    Resource provider = wire.getProvider();
                    uniquekey = provider.getIdentity().getSymbolicName();
                    this.resources.put(uniquekey, provider);
                }
            }
        }

        Resource getPrimary() {
            return this.primary;
        }

        Collection<Resource> getResources() {
            return Collections.unmodifiableCollection(this.resources.values());
        }

        boolean addDependencySpace(ResourceSpace dependency) {
            String uniquekey;
            if (dependency == null) {
                return false;
            }
            for (Resource aux : dependency.getResources()) {
                uniquekey = aux.getIdentity().getSymbolicName();
                Resource other = this.resources.get(uniquekey);
                if (other == null || other == aux) continue;
                return false;
            }
            for (Resource aux : dependency.getResources()) {
                uniquekey = aux.getIdentity().getSymbolicName();
                this.resources.put(uniquekey, aux);
            }
            return true;
        }

        public String toString() {
            return "ResourceSpace[" + this.primary.getIdentity() + "]";
        }
    }

    class ResourceSpaces {
        private final Map<Resource, ResourceSpace> spacemap = new LinkedHashMap<Resource, ResourceSpace>();

        ResourceSpaces(ResolveContext context) {
            for (Resource res : context.getWirings().keySet()) {
                this.spacemap.put(res, new ResourceSpace(res));
            }
        }

        ResourceSpaces(ResourceSpaces parent) {
            this.spacemap.putAll(parent.spacemap);
        }

        void addResourceSpace(ResourceSpace space) {
            Resource primary = space.getPrimary();
            assert (!this.spacemap.containsKey(primary)) : "spaces does not contain: " + primary;
            this.spacemap.put(primary, space);
        }

        Map<Resource, ResourceSpace> getResourceSpaces() {
            return Collections.unmodifiableMap(this.spacemap);
        }

        ResourceSpace getResourceSpace(Resource res) {
            return this.spacemap.get(res);
        }
    }

    private class ResolverState {
        private final ResourceSpaces spaces;
        private final ResolveContext context;
        private final Map<Resource, List<Wire>> wiremap = new LinkedHashMap<Resource, List<Wire>>();

        ResolverState(ResolveContext context) {
            this.context = context;
            this.spaces = new ResourceSpaces(context);
        }

        ResourceSpaces getResourceSpaces() {
            return this.spaces;
        }

        ResolveContext getResolveContext() {
            return this.context;
        }

        Map<Resource, List<Wire>> getResult() {
            return this.wiremap;
        }
    }
}

