package org.jboss.hal.client.configuration.subsystem.ejb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.Tabs;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_EjbView extends EjbView {

    private final Metadata metadata18;
    private final Metadata metadata15;
    private final Metadata metadata14;
    private final Metadata metadata19;
    private final Metadata metadata17;
    private final Metadata metadata16;
    private final Metadata metadata11;
    private final Metadata metadata9;
    private final Metadata metadata13;
    private final Metadata metadata8;
    private final Metadata metadata12;
    private final Metadata metadata10;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_EjbView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata18Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/mdb-delivery-group=*");
        this.metadata18 = mbuiContext.metadataRegistry().lookup(metadata18Template);
        AddressTemplate metadata15Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=iiop");
        this.metadata15 = mbuiContext.metadataRegistry().lookup(metadata15Template);
        AddressTemplate metadata14Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=async");
        this.metadata14 = mbuiContext.metadataRegistry().lookup(metadata14Template);
        AddressTemplate metadata19Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/application-security-domain=*");
        this.metadata19 = mbuiContext.metadataRegistry().lookup(metadata19Template);
        AddressTemplate metadata17Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service");
        this.metadata17 = mbuiContext.metadataRegistry().lookup(metadata17Template);
        AddressTemplate metadata16Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=remote");
        this.metadata16 = mbuiContext.metadataRegistry().lookup(metadata16Template);
        AddressTemplate metadata11Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/strict-max-bean-instance-pool=*");
        this.metadata11 = mbuiContext.metadataRegistry().lookup(metadata11Template);
        AddressTemplate metadata9Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*");
        this.metadata9 = mbuiContext.metadataRegistry().lookup(metadata9Template);
        AddressTemplate metadata13Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/passivation-store=*");
        this.metadata13 = mbuiContext.metadataRegistry().lookup(metadata13Template);
        AddressTemplate metadata8Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3");
        this.metadata8 = mbuiContext.metadataRegistry().lookup(metadata8Template);
        AddressTemplate metadata12Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/cache=*");
        this.metadata12 = mbuiContext.metadataRegistry().lookup(metadata12Template);
        AddressTemplate metadata10Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/remoting-profile=*");
        this.metadata10 = mbuiContext.metadataRegistry().lookup(metadata10Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("configuration-form", metadata8)
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata8Template.resolve(mbuiContext.statementContext()), "Container"))
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("thread-pool-form", metadata9)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata9Template.resolve(mbuiContext.statementContext(), name),
                    "Thread Pool", name);
            })
            .build();
        remotingProfileForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("remoting-profile-form", metadata10)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata10Template.resolve(mbuiContext.statementContext(), name),
                    "Remoting Profile", name);
            })
            .build();
        beanPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("bean-pool-form", metadata11)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata11Template.resolve(mbuiContext.statementContext(), name),
                    "Bean Pool", name);
            })
            .build();
        cacheForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("cache-form", metadata12)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata12Template.resolve(mbuiContext.statementContext(), name),
                    "Cache", name);
            })
            .build();
        passivationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("passivation-form", metadata13)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata13Template.resolve(mbuiContext.statementContext(), name),
                    "Passivation", name);
            })
            .build();
        serviceAsyncForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("service-async-form", metadata14)
            .include("thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata14Template.resolve(mbuiContext.statementContext()), "Async"))
            .build();
        serviceAsyncForm.getFormItem("thread-pool-name").registerSuggestHandler(new Typeahead(
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*"), mbuiContext.statementContext()));
        serviceIiopForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("service-iiop-form", metadata15)
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata15Template.resolve(mbuiContext.statementContext()), "IIOP"))
            .build();
        serviceRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("service-remote-form", metadata16)
            .include("cluster", "connector-ref", "thread-pool-name", "execute-in-worker")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata16Template.resolve(mbuiContext.statementContext()), "Remote"))
            .build();
        serviceRemoteForm.getFormItem("cluster").registerSuggestHandler(new Typeahead(
            AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*"), mbuiContext.statementContext()));
        serviceRemoteForm.getFormItem("connector-ref").registerSuggestHandler(new Typeahead(
            AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*"), mbuiContext.statementContext()));
        serviceRemoteForm.getFormItem("thread-pool-name").registerSuggestHandler(new Typeahead(
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*"), mbuiContext.statementContext()));
        serviceTimerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("service-timer-form", metadata17)
            .include("default-data-store", "thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata17Template.resolve(mbuiContext.statementContext()), "Timer"))
            .build();
        List<AddressTemplate> serviceTimerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/database-data-store=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/file-data-store=*"));
        serviceTimerForm.getFormItem("default-data-store").registerSuggestHandler(new Typeahead(
            serviceTimerFormTemplates, mbuiContext.statementContext()));
        serviceTimerForm.getFormItem("thread-pool-name").registerSuggestHandler(new Typeahead(
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*"), mbuiContext.statementContext()));
        mdbDeliveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("mdb-delivery-group-form", metadata18)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata18Template.resolve(mbuiContext.statementContext(), name),
                    "MDB Delivery Group", name);
            })
            .build();
        appSecurityDomainForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("app-security-domain-form", metadata19)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata19Template.resolve(mbuiContext.statementContext(), name),
                    "Application Security Domain", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> threadPoolTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata9)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("thread-pool-table", Ids.ADD_SUFFIX), "Thread Pool",
                metadata9Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata9Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        threadPoolTable = new ModelNodeTable<>("thread-pool-table", threadPoolTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> remotingProfileTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata10)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-profile-table", Ids.ADD_SUFFIX), "Remoting Profile",
                metadata10Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Remoting Profile", metadata10Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remotingProfileTable = new ModelNodeTable<>("remoting-profile-table", remotingProfileTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> beanPoolTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata11)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("bean-pool-table", Ids.ADD_SUFFIX), "Bean Pool",
                metadata11Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Bean Pool", metadata11Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        beanPoolTable = new ModelNodeTable<>("bean-pool-table", beanPoolTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> cacheTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata12)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("cache-table", Ids.ADD_SUFFIX), "Cache",
                metadata12Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Cache", metadata12Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        cacheTable = new ModelNodeTable<>("cache-table", cacheTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> passivationTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata13)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("passivation-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Passivation"),
                    metadata13,
                    asList("bean-cache", "cache-container", "max-size"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata13Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                                mbuiContext.resources().messages().addResourceSuccess("Passivation", name)));
                        });
                    });
                dialog.getForm().getFormItem("cache-container").registerSuggestHandler(new Typeahead(
                    AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*"), mbuiContext.statementContext()));
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Passivation", metadata13Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        passivationTable = new ModelNodeTable<>("passivation-table", passivationTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> mdbDeliveryGroupTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata18)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("mdb-delivery-group-table", Ids.ADD_SUFFIX), "MDB Delivery Group",
                metadata18Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("MDB Delivery Group", metadata18Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mdbDeliveryGroupTable = new ModelNodeTable<>("mdb-delivery-group-table", mdbDeliveryGroupTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> appSecurityDomainTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata19)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("app-security-domain-table", Ids.ADD_SUFFIX), "Application Security Domain",
                metadata19Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Application Security Domain", metadata19Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        appSecurityDomainTable = new ModelNodeTable<>("app-security-domain-table", appSecurityDomainTableOptions);

        registerAttachable(configurationForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);
        registerAttachable(remotingProfileTable);
        registerAttachable(remotingProfileForm);
        registerAttachable(beanPoolTable);
        registerAttachable(beanPoolForm);
        registerAttachable(cacheTable);
        registerAttachable(cacheForm);
        registerAttachable(passivationTable);
        registerAttachable(passivationForm);
        registerAttachable(serviceAsyncForm);
        registerAttachable(serviceIiopForm);
        registerAttachable(serviceRemoteForm);
        registerAttachable(serviceTimerForm);
        registerAttachable(mdbDeliveryGroupTable);
        registerAttachable(mdbDeliveryGroupForm);
        registerAttachable(appSecurityDomainTable);
        registerAttachable(appSecurityDomainForm);


        navigation = new VerticalNavigation();
        navigation.addPrimary("container-item", "Container", "fa fa-cogs");
        Elements.Builder configurationItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Container</h1><p>{{metadata8.getDescription().getDescription()}}</p>"))
                    .rememberAs("html22")
                .end()
                .add(configurationForm)
            .end();
        Element configurationItemElement = configurationItemBuilder.build();
        handlebarElements.put("html22", configurationItemBuilder.referenceFor("html22"));
        navigation.addSecondary("container-item", "configuration-item", "Container", configurationItemElement);
        Elements.Builder threadPoolItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>{{metadata9.getDescription().getDescription()}}</p>"))
                    .rememberAs("html24")
                .end()
                .add(threadPoolTable)
                .add(threadPoolForm)
            .end();
        Element threadPoolItemElement = threadPoolItemBuilder.build();
        handlebarElements.put("html24", threadPoolItemBuilder.referenceFor("html24"));
        navigation.addSecondary("container-item", "thread-pool-item", "Thread Pool", threadPoolItemElement);
        Elements.Builder remotingProfileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remoting Profile</h1><p>{{metadata10.getDescription().getDescription()}}</p>"))
                    .rememberAs("html27")
                .end()
                .add(remotingProfileTable)
                .add(remotingProfileForm)
            .end();
        Element remotingProfileItemElement = remotingProfileItemBuilder.build();
        handlebarElements.put("html27", remotingProfileItemBuilder.referenceFor("html27"));
        navigation.addSecondary("container-item", "remoting-profile-item", "Remoting Profile", remotingProfileItemElement);
        Elements.Builder beanPoolItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bean Pool</h1><p>{{metadata11.getDescription().getDescription()}}</p>"))
                    .rememberAs("html30")
                .end()
                .add(beanPoolTable)
                .add(beanPoolForm)
            .end();
        Element beanPoolItemElement = beanPoolItemBuilder.build();
        handlebarElements.put("html30", beanPoolItemBuilder.referenceFor("html30"));
        navigation.addPrimary("bean-pool-item", "Bean Pool", "pficon pficon-repository", beanPoolItemElement);
        navigation.addPrimary("state-item", "State Management", "fa fa-list-ul");
        Elements.Builder cacheItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cache</h1><p>{{metadata12.getDescription().getDescription()}}</p>"))
                    .rememberAs("html33")
                .end()
                .add(cacheTable)
                .add(cacheForm)
            .end();
        Element cacheItemElement = cacheItemBuilder.build();
        handlebarElements.put("html33", cacheItemBuilder.referenceFor("html33"));
        navigation.addSecondary("state-item", "cache-item", "Cache", cacheItemElement);
        Elements.Builder passivationItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Passivation</h1><p>{{metadata13.getDescription().getDescription()}}</p>"))
                    .rememberAs("html36")
                .end()
                .add(passivationTable)
                .add(passivationForm)
            .end();
        Element passivationItemElement = passivationItemBuilder.build();
        handlebarElements.put("html36", passivationItemBuilder.referenceFor("html36"));
        navigation.addSecondary("state-item", "passivation-item", "Passivation", passivationItemElement);
        navigation.addPrimary("service-item", "Services", "pficon pficon-service");
        Elements.Builder serviceAsyncItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async</h1><p>{{metadata14.getDescription().getDescription()}}</p>"))
                    .rememberAs("html39")
                .end()
                .add(serviceAsyncForm)
            .end();
        Element serviceAsyncItemElement = serviceAsyncItemBuilder.build();
        handlebarElements.put("html39", serviceAsyncItemBuilder.referenceFor("html39"));
        navigation.addSecondary("service-item", "service-async-item", "Async", serviceAsyncItemElement);
        Elements.Builder serviceIiopItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>IIOP</h1><p>{{metadata15.getDescription().getDescription()}}</p>"))
                    .rememberAs("html41")
                .end()
                .add(serviceIiopForm)
            .end();
        Element serviceIiopItemElement = serviceIiopItemBuilder.build();
        handlebarElements.put("html41", serviceIiopItemBuilder.referenceFor("html41"));
        navigation.addSecondary("service-item", "service-iiop-item", "IIOP", serviceIiopItemElement);
        Elements.Builder serviceRemoteItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote</h1><p>{{metadata16.getDescription().getDescription()}}</p>"))
                    .rememberAs("html43")
                .end()
                .add(serviceRemoteForm)
            .end();
        Element serviceRemoteItemElement = serviceRemoteItemBuilder.build();
        handlebarElements.put("html43", serviceRemoteItemBuilder.referenceFor("html43"));
        navigation.addSecondary("service-item", "service-remote-item", "Remote", serviceRemoteItemElement);
        Elements.Builder serviceTimerItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Timer</h1><p>{{metadata17.getDescription().getDescription()}}</p>"))
                    .rememberAs("html45")
                .end()
                .add(serviceTimerForm)
            .end();
        Element serviceTimerItemElement = serviceTimerItemBuilder.build();
        handlebarElements.put("html45", serviceTimerItemBuilder.referenceFor("html45"));
        navigation.addSecondary("service-item", "service-timer-item", "Timer", serviceTimerItemElement);
        Elements.Builder mdbDeliveryGroupItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>MDB Delivery Group</h1><p>{{metadata18.getDescription().getDescription()}}</p>"))
                    .rememberAs("html47")
                .end()
                .add(mdbDeliveryGroupTable)
                .add(mdbDeliveryGroupForm)
            .end();
        Element mdbDeliveryGroupItemElement = mdbDeliveryGroupItemBuilder.build();
        handlebarElements.put("html47", mdbDeliveryGroupItemBuilder.referenceFor("html47"));
        navigation.addPrimary("mdb-delivery-group-item", "MDB Delivery", "fa fa-inbox", mdbDeliveryGroupItemElement);
        Elements.Builder appSecurityDomainItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Application Security Domain</h1><p>{{metadata19.getDescription().getDescription()}}</p>"))
                    .rememberAs("html50")
                .end()
                .add(appSecurityDomainTable)
                .add(appSecurityDomainForm)
            .end();
        Element appSecurityDomainItemElement = appSecurityDomainItemBuilder.build();
        handlebarElements.put("html50", appSecurityDomainItemBuilder.referenceFor("html50"));
        navigation.addPrimary("app-security-domain-item", "Security Domain", "fa fa-link", appSecurityDomainItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        threadPoolTable.api().bindForm(threadPoolForm);
        remotingProfileTable.api().bindForm(remotingProfileForm);
        beanPoolTable.api().bindForm(beanPoolForm);
        cacheTable.api().bindForm(cacheForm);
        passivationTable.api().bindForm(passivationForm);
        mdbDeliveryGroupTable.api().bindForm(mdbDeliveryGroupForm);
        appSecurityDomainTable.api().bindForm(appSecurityDomainForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html22"), "{{metadata8.getDescription().getDescription()}}", String.valueOf(metadata8.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html24"), "{{metadata9.getDescription().getDescription()}}", String.valueOf(metadata9.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html27"), "{{metadata10.getDescription().getDescription()}}", String.valueOf(metadata10.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html30"), "{{metadata11.getDescription().getDescription()}}", String.valueOf(metadata11.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html33"), "{{metadata12.getDescription().getDescription()}}", String.valueOf(metadata12.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html36"), "{{metadata13.getDescription().getDescription()}}", String.valueOf(metadata13.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html39"), "{{metadata14.getDescription().getDescription()}}", String.valueOf(metadata14.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html41"), "{{metadata15.getDescription().getDescription()}}", String.valueOf(metadata15.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html43"), "{{metadata16.getDescription().getDescription()}}", String.valueOf(metadata16.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html45"), "{{metadata17.getDescription().getDescription()}}", String.valueOf(metadata17.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html47"), "{{metadata18.getDescription().getDescription()}}", String.valueOf(metadata18.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html50"), "{{metadata19.getDescription().getDescription()}}", String.valueOf(metadata19.getDescription().getDescription()));
    }
}
