package org.jboss.hal.client.configuration.subsystem.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.Tabs;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_IOView extends IOView {

    private final Metadata metadata21;
    private final Metadata metadata22;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_IOView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata21Template = AddressTemplate.of("/{selected.profile}/subsystem=io/worker=*");
        this.metadata21 = mbuiContext.metadataRegistry().lookup(metadata21Template);
        AddressTemplate metadata22Template = AddressTemplate.of("/{selected.profile}/subsystem=io/buffer-pool=*");
        this.metadata22 = mbuiContext.metadataRegistry().lookup(metadata22Template);
        this.handlebarElements = new HashMap<>();

        bufferPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("buffer-pool-form", metadata22)
            .include("buffer-size", "buffers-per-slice", "direct-buffers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata22Template.resolve(mbuiContext.statementContext(), name),
                    "Buffer Pool", name);
            })
            .build();
        workerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("worker-form", metadata21)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata21Template.resolve(mbuiContext.statementContext(), name),
                    "Worker", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> bufferPoolTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata22)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("buffer-pool-table", Ids.ADD_SUFFIX), "Buffer Pool",
                metadata22Template,
                () -> presenter.reload(),
                "buffer-size", 
                "buffers-per-slice", 
                "direct-buffers"))
            .button(mbuiContext.tableButtonFactory().remove("Buffer Pool", metadata22Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        bufferPoolTable = new ModelNodeTable<>("buffer-pool-table", bufferPoolTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> workerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata21)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("worker-table", Ids.ADD_SUFFIX), "Worker",
                metadata21Template,
                () -> presenter.reload(),
                "io-threads", 
                "stack-size", 
                "task-keepalive", 
                "task-max-threads"))
            .button(mbuiContext.tableButtonFactory().remove("Worker", metadata21Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        workerTable = new ModelNodeTable<>("worker-table", workerTableOptions);

        registerAttachable(bufferPoolTable);
        registerAttachable(bufferPoolForm);
        registerAttachable(workerTable);
        registerAttachable(workerForm);


        navigation = new VerticalNavigation();
        Elements.Builder workerItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Worker</h1><p>{{metadata21.getDescription().getDescription()}}</p>"))
                    .rememberAs("html55")
                .end()
                .add(workerTable)
                .add(workerForm)
            .end();
        Element workerItemElement = workerItemBuilder.build();
        handlebarElements.put("html55", workerItemBuilder.referenceFor("html55"));
        navigation.addPrimary("worker-item", "Worker", "fa fa-cogs", workerItemElement);
        Elements.Builder bufferPoolItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Buffer Pool</h1><p>{{metadata22.getDescription().getDescription()}}</p>"))
                    .rememberAs("html58")
                .end()
                .add(bufferPoolTable)
                .add(bufferPoolForm)
            .end();
        Element bufferPoolItemElement = bufferPoolItemBuilder.build();
        handlebarElements.put("html58", bufferPoolItemBuilder.referenceFor("html58"));
        navigation.addPrimary("buffer-pool-item", "Buffer Pool", "pficon pficon-repository", bufferPoolItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        bufferPoolTable.api().bindForm(bufferPoolForm);
        workerTable.api().bindForm(workerForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html55"), "{{metadata21.getDescription().getDescription()}}", String.valueOf(metadata21.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html58"), "{{metadata22.getDescription().getDescription()}}", String.valueOf(metadata22.getDescription().getDescription()));
    }
}
