package org.jboss.hal.client.configuration.subsystem.transactions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.Tabs;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_TransactionView extends TransactionView {

    private final Metadata metadata48;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_TransactionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata48Template = AddressTemplate.of("/{selected.profile}/subsystem=transactions");
        this.metadata48 = mbuiContext.metadataRegistry().lookup(metadata48Template);
        this.handlebarElements = new HashMap<>();

        attributesForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("attributes-form", metadata48)
            .include("default-timeout", "enable-tsm-status", "journal-store-enable-async-io", "jts", "node-identifier", "statistics-enabled", "use-journal-store")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata48Template.resolve(mbuiContext.statementContext()), "Transaction Manager"))
            .build();
        processForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("process-form", metadata48)
            .include("process-id-uuid", "process-id-socket-binding", "process-id-socket-max-ports")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveProcessForm(form, changedValues))
            .build();
        processForm.getFormItem("process-id-socket-binding").registerSuggestHandler(new Typeahead(
            AddressTemplate.of("/socket-binding-group=*/socket-binding=*"), mbuiContext.statementContext()));
        recoveryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("recovery-form", metadata48)
            .include("socket-binding", "status-socket-binding", "recovery-listener")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata48Template.resolve(mbuiContext.statementContext()), "Recovery"))
            .build();
        recoveryForm.getFormItem("socket-binding").registerSuggestHandler(new Typeahead(
            AddressTemplate.of("/socket-binding-group=*/socket-binding=*"), mbuiContext.statementContext()));
        recoveryForm.getFormItem("status-socket-binding").registerSuggestHandler(new Typeahead(
            AddressTemplate.of("/socket-binding-group=*/socket-binding=*"), mbuiContext.statementContext()));
        pathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("path-form", metadata48)
            .include("object-store-path", "object-store-relative-to")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata48Template.resolve(mbuiContext.statementContext()), "Path"))
            .build();
        pathForm.getFormItem("object-store-relative-to").registerSuggestHandler(new org.jboss.hal.client.configuration.PathsTypeahead());
        jdbcForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("jdbc-form", metadata48)
            .include("use-jdbc-store", "jdbc-action-store-drop-table", "jdbc-action-store-table-prefix", "jdbc-communication-store-drop-table", "jdbc-communication-store-table-prefix", "jdbc-state-store-drop-table", "jdbc-state-store-table-prefix", "jdbc-store-datasource")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata48Template.resolve(mbuiContext.statementContext()), "JDBC"))
            .build();
        List<AddressTemplate> jdbcFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/xa-data-source=*"));
        jdbcForm.getFormItem("jdbc-store-datasource").registerSuggestHandler(new Typeahead(
            jdbcFormTemplates, mbuiContext.statementContext()));


        registerAttachable(attributesForm);
        registerAttachable(processForm);
        registerAttachable(recoveryForm);
        registerAttachable(pathForm);
        registerAttachable(jdbcForm);


        navigation = new VerticalNavigation();
        Elements.Builder attributesConfigItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Transaction Manager</h1><p>{{metadata48.getDescription().getDescription()}}</p>"))
                    .rememberAs("html133")
                .end()
                .add(attributesForm)
            .end();
        Element attributesConfigItemElement = attributesConfigItemBuilder.build();
        handlebarElements.put("html133", attributesConfigItemBuilder.referenceFor("html133"));
        navigation.addPrimary("attributes-config-item", "Configuration", "fa fa-list-ul", attributesConfigItemElement);
        Elements.Builder processItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Process ID</h1><p>{{metadata48.getDescription().getDescription()}}</p>"))
                    .rememberAs("html135")
                .end()
                .add(processForm)
            .end();
        Element processItemElement = processItemBuilder.build();
        handlebarElements.put("html135", processItemBuilder.referenceFor("html135"));
        navigation.addPrimary("process-item", "Process", "pficon pficon-service", processItemElement);
        Elements.Builder recoveryConfigItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Recovery</h1><p>{{metadata48.getDescription().getDescription()}}</p>"))
                    .rememberAs("html137")
                .end()
                .add(recoveryForm)
            .end();
        Element recoveryConfigItemElement = recoveryConfigItemBuilder.build();
        handlebarElements.put("html137", recoveryConfigItemBuilder.referenceFor("html137"));
        navigation.addPrimary("recovery-config-item", "Recovery", "fa fa-repeat", recoveryConfigItemElement);
        Elements.Builder pathConfigItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Path</h1><p>{{metadata48.getDescription().getDescription()}}</p>"))
                    .rememberAs("html139")
                .end()
                .add(pathForm)
            .end();
        Element pathConfigItemElement = pathConfigItemBuilder.build();
        handlebarElements.put("html139", pathConfigItemBuilder.referenceFor("html139"));
        navigation.addPrimary("path-config-item", "Path", "fa fa-folder-open", pathConfigItemElement);
        Elements.Builder jdbcConfigItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC</h1><p>{{metadata48.getDescription().getDescription()}}</p>"))
                    .rememberAs("html141")
                .end()
                .add(jdbcForm)
            .end();
        Element jdbcConfigItemElement = jdbcConfigItemBuilder.build();
        handlebarElements.put("html141", jdbcConfigItemBuilder.referenceFor("html141"));
        navigation.addPrimary("jdbc-config-item", "JDBC", "fa fa-database", jdbcConfigItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        TemplateUtil.replaceHandlebar(handlebarElements.get("html133"), "{{metadata48.getDescription().getDescription()}}", String.valueOf(metadata48.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html135"), "{{metadata48.getDescription().getDescription()}}", String.valueOf(metadata48.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html137"), "{{metadata48.getDescription().getDescription()}}", String.valueOf(metadata48.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html139"), "{{metadata48.getDescription().getDescription()}}", String.valueOf(metadata48.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html141"), "{{metadata48.getDescription().getDescription()}}", String.valueOf(metadata48.getDescription().getDescription()));
    }
}
