package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.Tabs;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_HostView extends HostView {

    private final Metadata metadata52;
    private final Metadata metadata56;
    private final Metadata metadata54;
    private final Metadata metadata55;
    private final Metadata metadata53;
    private final Metadata metadata57;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata52Template = AddressTemplate.of("/{selected.host}");
        this.metadata52 = mbuiContext.metadataRegistry().lookup(metadata52Template);
        AddressTemplate metadata56Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata56 = mbuiContext.metadataRegistry().lookup(metadata56Template);
        AddressTemplate metadata54Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata54 = mbuiContext.metadataRegistry().lookup(metadata54Template);
        AddressTemplate metadata55Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata55 = mbuiContext.metadataRegistry().lookup(metadata55Template);
        AddressTemplate metadata53Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata53 = mbuiContext.metadataRegistry().lookup(metadata53Template);
        AddressTemplate metadata57Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata57 = mbuiContext.metadataRegistry().lookup(metadata57Template);
        this.handlebarElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata52)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-interface-form", metadata53)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata53Template.resolve(mbuiContext.statementContext(), name),
                    "Interface", name);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-jvm-form", metadata54)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata54Template.resolve(mbuiContext.statementContext(), name),
                    "Jvm", name);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-path-form", metadata55)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata55Template.resolve(mbuiContext.statementContext(), name),
                    "Path", name);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-socket-binding-group-form", metadata56)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata56Template.resolve(mbuiContext.statementContext(), name),
                    "Socket Binding Group", name);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-system-property-form", metadata57)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata57Template.resolve(mbuiContext.statementContext(), name),
                    "System Property", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> hostInterfaceTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata53)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-interface-table", Ids.ADD_SUFFIX), "Interface",
                metadata53Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata53Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostInterfaceTable = new ModelNodeTable<>("host-interface-table", hostInterfaceTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostJvmTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata54)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-jvm-table", Ids.ADD_SUFFIX), "Jvm",
                metadata54Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata54Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hostJvmTable = new ModelNodeTable<>("host-jvm-table", hostJvmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostPathTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata55)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-path-table", Ids.ADD_SUFFIX), "Path",
                metadata55Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata55Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostPathTable = new ModelNodeTable<>("host-path-table", hostPathTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostSocketBindingGroupTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata56)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-socket-binding-group-table", Ids.ADD_SUFFIX), "Socket Binding Group",
                metadata56Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata56Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSocketBindingGroupTable = new ModelNodeTable<>("host-socket-binding-group-table", hostSocketBindingGroupTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostSystemPropertyTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata57)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-system-property-table", Ids.ADD_SUFFIX), "System Property",
                metadata57Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata57Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        hostSystemPropertyTable = new ModelNodeTable<>("host-system-property-table", hostSystemPropertyTableOptions);

        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);


        navigation = new VerticalNavigation();
        Elements.Builder hostConfigurationItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>{{metadata52.getDescription().getDescription()}}</p>"))
                    .rememberAs("html151")
                .end()
                .add(hostConfigurationForm)
            .end();
        Element hostConfigurationItemElement = hostConfigurationItemBuilder.build();
        handlebarElements.put("html151", hostConfigurationItemBuilder.referenceFor("html151"));
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-cluster", hostConfigurationItemElement);
        Elements.Builder hostInterfaceItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata53.getDescription().getDescription()}}</p>"))
                    .rememberAs("html153")
                .end()
                .add(hostInterfaceTable)
                .add(hostInterfaceForm)
            .end();
        Element hostInterfaceItemElement = hostInterfaceItemBuilder.build();
        handlebarElements.put("html153", hostInterfaceItemBuilder.referenceFor("html153"));
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        Elements.Builder hostJvmItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata54.getDescription().getDescription()}}</p>"))
                    .rememberAs("html156")
                .end()
                .add(hostJvmTable)
                .add(hostJvmForm)
            .end();
        Element hostJvmItemElement = hostJvmItemBuilder.build();
        handlebarElements.put("html156", hostJvmItemBuilder.referenceFor("html156"));
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        Elements.Builder hostPathItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata55.getDescription().getDescription()}}</p>"))
                    .rememberAs("html159")
                .end()
                .add(hostPathTable)
                .add(hostPathForm)
            .end();
        Element hostPathItemElement = hostPathItemBuilder.build();
        handlebarElements.put("html159", hostPathItemBuilder.referenceFor("html159"));
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        Elements.Builder hostSocketBindingGroupItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>{{metadata56.getDescription().getDescription()}}</p>"))
                    .rememberAs("html162")
                .end()
                .add(hostSocketBindingGroupTable)
                .add(hostSocketBindingGroupForm)
            .end();
        Element hostSocketBindingGroupItemElement = hostSocketBindingGroupItemBuilder.build();
        handlebarElements.put("html162", hostSocketBindingGroupItemBuilder.referenceFor("html162"));
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        Elements.Builder hostSystemPropertyItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata57.getDescription().getDescription()}}</p>"))
                    .rememberAs("html165")
                .end()
                .add(hostSystemPropertyTable)
                .add(hostSystemPropertyForm)
            .end();
        Element hostSystemPropertyItemElement = hostSystemPropertyItemBuilder.build();
        handlebarElements.put("html165", hostSystemPropertyItemBuilder.referenceFor("html165"));
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        hostInterfaceTable.api().bindForm(hostInterfaceForm);
        hostJvmTable.api().bindForm(hostJvmForm);
        hostPathTable.api().bindForm(hostPathForm);
        hostSocketBindingGroupTable.api().bindForm(hostSocketBindingGroupForm);
        hostSystemPropertyTable.api().bindForm(hostSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html151"), "{{metadata52.getDescription().getDescription()}}", String.valueOf(metadata52.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html153"), "{{metadata53.getDescription().getDescription()}}", String.valueOf(metadata53.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html156"), "{{metadata54.getDescription().getDescription()}}", String.valueOf(metadata54.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html159"), "{{metadata55.getDescription().getDescription()}}", String.valueOf(metadata55.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html162"), "{{metadata56.getDescription().getDescription()}}", String.valueOf(metadata56.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html165"), "{{metadata57.getDescription().getDescription()}}", String.valueOf(metadata57.getDescription().getDescription()));
    }
}
