package org.jboss.hal.client.configuration.subsystem.microprofile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_MicroProfileConfigView extends MicroProfileConfigView {

    private final Metadata metadata19;
    private final Metadata metadata18;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_MicroProfileConfigView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata19Template = AddressTemplate.of("/{selected.profile}/subsystem=microprofile-config-smallrye/config-source-provider=*");
        this.metadata19 = mbuiContext.metadataRegistry().lookup(metadata19Template);
        AddressTemplate metadata18Template = AddressTemplate.of("/{selected.profile}/subsystem=microprofile-config-smallrye/config-source=*");
        this.metadata18 = mbuiContext.metadataRegistry().lookup(metadata18Template);
        this.expressionElements = new HashMap<>();

        configSourceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-form", metadata18)
            .customFormItem("class", attributeDescription -> new ClassFormItem())
            .customFormItem("dir", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("dir", false))
            .include("properties")
            .include("ordinal")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Config Source", name, metadata18Template.resolve(statementContext(), name), changedValues, metadata18);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Config Source", name, metadata18Template.resolve(statementContext(), name), form, metadata18);
            })
            .build();
        configSourceProviderForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-provider-form", metadata19)
            .customFormItem("class", attributeDescription -> new ClassFormItem())
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Config Source Provider", name, metadata19Template.resolve(statementContext(), name), changedValues, metadata19);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Config Source Provider", name, metadata19Template.resolve(statementContext(), name), form, metadata19);
            })
            .build();

        configSourceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-table", metadata18)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(), Constraint.parse("executable({selected.profile}/subsystem=microprofile-config-smallrye/config-source=*:add)"))
            .button(mbuiContext.tableButtonFactory().remove("Config Source", metadata18Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("ordinal")
            .build();
        configSourceProviderTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-provider-table", metadata19)
            .button(mbuiContext.tableButtonFactory().add(metadata19Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("microprofile-config-source-provider-table", Ids.ADD),
                    metadata19)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("class", attributeDescription -> new ClassFormItem())
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Config Provider"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata19Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Config Provider", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Config Provider", metadata19Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html54;
        HTMLElement microprofileConfigSourceItemElement = section()
            .add(html54 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Config Sources</h1><p>${metadata18.getDescription().getDescription()}</p>"))
                            .element())
            .add(configSourceTable)
            .add(configSourceForm)
                    .element();
        expressionElements.put("html54", html54);
        navigation.addPrimary("microprofile-config-source-item", "Config Sources", "fa fa-cogs", microprofileConfigSourceItemElement);
        HTMLElement html57;
        HTMLElement microprofileConfigSourceProviderItemElement = section()
            .add(html57 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Config Providers</h1><p>${metadata19.getDescription().getDescription()}</p>"))
                            .element())
            .add(configSourceProviderTable)
            .add(configSourceProviderForm)
                    .element();
        expressionElements.put("html57", html57);
        navigation.addPrimary("microprofile-config-source-provider-item", "Config Providers", "pficon pficon-services", microprofileConfigSourceProviderItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configSourceTable);
        registerAttachable(configSourceForm);
        registerAttachable(configSourceProviderTable);
        registerAttachable(configSourceProviderForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            configSourceTable.bindForm(configSourceForm);
            configSourceProviderTable.bindForm(configSourceProviderForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html54"), "${metadata18.getDescription().getDescription()}", String.valueOf(metadata18.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html57"), "${metadata19.getDescription().getDescription()}", String.valueOf(metadata19.getDescription().getDescription()));
    }
}
