package org.jboss.hal.client.runtime.group;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ServerGroupView extends ServerGroupView {

    private final Metadata metadata122;
    private final Metadata metadata121;
    private final Metadata metadata123;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ServerGroupView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata122Template = AddressTemplate.of("/{selected.group}/jvm=*");
        this.metadata122 = mbuiContext.metadataRegistry().lookup(metadata122Template);
        AddressTemplate metadata121Template = AddressTemplate.of("/{selected.group}");
        this.metadata121 = mbuiContext.metadataRegistry().lookup(metadata121Template);
        AddressTemplate metadata123Template = AddressTemplate.of("/{selected.group}/system-property=*");
        this.metadata123 = mbuiContext.metadataRegistry().lookup(metadata123Template);
        this.expressionElements = new HashMap<>();

        serverGroupConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.group.ServerGroup>("server-group-configuration-form", metadata121)
            .includeRuntime()
            .include("profile", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "management-subsystem-endpoint")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Group Configuration", metadata121Template.resolve(statementContext()), changedValues, metadata121))
            .prepareReset(form -> resetSingletonForm("Server Group Configuration", metadata121Template.resolve(statementContext()), form, metadata121))
            .build();
        serverGroupJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-group-jvm-form", metadata122)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata122Template.resolve(statementContext(), name), changedValues, metadata122);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata122Template.resolve(statementContext(), name), form, metadata122);
            })
            .build();
        serverGroupSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-group-system-property-form", metadata123)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata123Template.resolve(statementContext(), name), changedValues, metadata123);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata123Template.resolve(statementContext(), name), form, metadata123);
            })
            .build();

        serverGroupJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-group-jvm-table", metadata122)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-jvm-table", Ids.ADD), "JVM",
                metadata122Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata122Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverGroupSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-group-system-property-table", metadata123)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-system-property-table", Ids.ADD), "System Property",
                metadata123Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata123Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html352;
        HTMLElement serverGroupConfigurationItemElement = section()
            .add(html352 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Group Configuration</h1><p>${metadata121.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverGroupConfigurationForm)
                    .element();
        expressionElements.put("html352", html352);
        navigation.addPrimary("server-group-configuration-item", "Configuration", "pficon pficon-settings", serverGroupConfigurationItemElement);
        HTMLElement html354;
        HTMLElement serverGroupJvmItemElement = section()
            .add(html354 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata122.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverGroupJvmTable)
            .add(serverGroupJvmForm)
                    .element();
        expressionElements.put("html354", html354);
        navigation.addPrimary("server-group-jvm-item", "JVMs", "fa fa-coffee", serverGroupJvmItemElement);
        HTMLElement html357;
        HTMLElement serverGroupSystemPropertyItemElement = section()
            .add(html357 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata123.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverGroupSystemPropertyTable)
            .add(serverGroupSystemPropertyForm)
                    .element();
        expressionElements.put("html357", html357);
        navigation.addPrimary("server-group-system-property-item", "System Properties", "fa fa-list-ul", serverGroupSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(serverGroupConfigurationForm);
        registerAttachable(serverGroupJvmTable);
        registerAttachable(serverGroupJvmForm);
        registerAttachable(serverGroupSystemPropertyTable);
        registerAttachable(serverGroupSystemPropertyForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            serverGroupJvmTable.bindForm(serverGroupJvmForm);
            serverGroupSystemPropertyTable.bindForm(serverGroupSystemPropertyForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html352"), "${metadata121.getDescription().getDescription()}", String.valueOf(metadata121.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html354"), "${metadata122.getDescription().getDescription()}", String.valueOf(metadata122.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html357"), "${metadata123.getDescription().getDescription()}", String.valueOf(metadata123.getDescription().getDescription()));
    }
}
