package org.jboss.hal.config;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class UserChangedEvent extends GwtEvent<UserChangedEvent.UserChangedHandler> { 


  public UserChangedEvent() {
    // Possibly for serialization.
  }

  public static void fire(HasHandlers source) {
    UserChangedEvent eventInstance = new UserChangedEvent();
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, UserChangedEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasUserChangedHandlers extends HasHandlers {
    HandlerRegistration addUserChangedHandler(UserChangedHandler handler);
  }

  public interface UserChangedHandler extends EventHandler {
    public void onUserChanged(UserChangedEvent event);
  }

  private static final Type<UserChangedHandler> TYPE = new Type<UserChangedHandler>();

  public static Type<UserChangedHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<UserChangedHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(UserChangedHandler handler) {
    handler.onUserChanged(this);
  }

  @Override
  public boolean equals(Object obj) {
    return super.equals(obj);
  }

  @Override
  public int hashCode() {
    return super.hashCode();
  }

  @Override
  public String toString() {
    return "UserChangedEvent["
    + "]";
  }
}
