/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.dmr;

import org.jboss.hal.dmr.ModelNode;
import org.jboss.hal.dmr.ModelNodeHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ModelNodeHelperTest {
    private ModelNode modelNode;
    private ModelNode foo;
    private ModelNode bar;

    @Before
    public void setUp() {
        this.modelNode = new ModelNode();
        this.bar = new ModelNode().set(42);
        this.foo = new ModelNode();
        this.foo.get("bar").set(this.bar);
        this.modelNode.get("foo").set(this.foo);
    }

    @Test
    public void nullPath() {
        Assert.assertFalse((boolean)ModelNodeHelper.failSafeGet((ModelNode)this.modelNode, null).isDefined());
    }

    @Test
    public void emptyPath() {
        Assert.assertFalse((boolean)ModelNodeHelper.failSafeGet((ModelNode)this.modelNode, (String)"").isDefined());
    }

    @Test
    public void invalidPath() {
        Assert.assertFalse((boolean)ModelNodeHelper.failSafeGet((ModelNode)this.modelNode, (String)"/").isDefined());
    }

    @Test
    public void wrongPath() {
        Assert.assertFalse((boolean)ModelNodeHelper.failSafeGet((ModelNode)this.modelNode, (String)"a").isDefined());
        Assert.assertFalse((boolean)ModelNodeHelper.failSafeGet((ModelNode)this.modelNode, (String)"a/b").isDefined());
        Assert.assertFalse((boolean)ModelNodeHelper.failSafeGet((ModelNode)this.modelNode, (String)"foo/bar/baz").isDefined());
    }

    @Test
    public void simplePath() {
        ModelNode node = ModelNodeHelper.failSafeGet((ModelNode)this.modelNode, (String)"foo");
        Assert.assertTrue((boolean)node.isDefined());
        Assert.assertEquals((Object)this.foo, (Object)node);
    }

    @Test
    public void nestedPath() {
        ModelNode node = ModelNodeHelper.failSafeGet((ModelNode)this.modelNode, (String)"foo/bar");
        Assert.assertTrue((boolean)node.isDefined());
        Assert.assertEquals((Object)this.bar, (Object)node);
    }

    @Test
    public void flatToNestedNull() {
        Assert.assertNull((Object)ModelNodeHelper.flatToNested(null));
    }

    @Test
    public void flatToNestedUndefined() {
        Assert.assertFalse((boolean)ModelNodeHelper.flatToNested((ModelNode)new ModelNode()).isDefined());
    }

    @Test
    public void flatToNestedFlat() {
        Assert.assertEquals((Object)this.modelNode, (Object)ModelNodeHelper.flatToNested((ModelNode)this.modelNode));
    }

    @Test
    public void flatToNested() {
        ModelNode flat = new ModelNode();
        flat.get("foo.bar").set(42);
        Assert.assertEquals((Object)this.modelNode, (Object)ModelNodeHelper.flatToNested((ModelNode)flat));
    }

    @Test
    public void flatToNestedWithOverlay() {
        ModelNode flat = new ModelNode();
        flat.get("a.b").set("ab");
        flat.get("a.b.c").set("abc");
        ModelNode nested = new ModelNode();
        nested.get("a").get("b").get("c").set("abc");
        Assert.assertEquals((Object)nested, (Object)ModelNodeHelper.flatToNested((ModelNode)flat));
    }
}

