/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.dmr;

import java.util.Collections;
import org.jboss.hal.dmr.ModelNode;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.junit.Assert;
import org.junit.Test;

public class OperationTest {
    @Test
    public void fromModelNode() {
        ModelNode address = new ModelNode();
        address.add().set("subsystem", "datasources");
        address.add().set("data-source", "foo");
        ModelNode modelNode = new ModelNode();
        modelNode.get("operation").set("add");
        modelNode.get("address").set(address);
        modelNode.get("jndi-name").set("java:/bar");
        modelNode.get("operation-headers").get("header1").set("value1");
        this.assertOperation(new Operation(modelNode));
    }

    @Test
    public void fromBuilder() {
        ResourceAddress address = new ResourceAddress().add("subsystem", "datasources").add("data-source", "foo");
        Operation operation = new Operation.Builder(address, "add").param("jndi-name", "java:/bar").header("header1", "value1").build();
        this.assertOperation(operation);
    }

    @Test
    public void fromBuilderResolveExpression() {
        ResourceAddress address = new ResourceAddress().add("subsystem", "datasources").add("data-source", "foo");
        Operation operation = new Operation.Builder(address, "read-resource", true).header("header1", "value1").build();
        ModelNode parameter = new ModelNode();
        parameter.get("resolve-expression").set(true);
        Assert.assertEquals((Object)parameter, (Object)operation.getParameter());
        Assert.assertTrue((boolean)operation.getParameter().asBoolean());
    }

    @Test
    public void runAs() {
        ResourceAddress address = new ResourceAddress().add("subsystem", "datasources").add("data-source", "foo");
        Operation operation = new Operation.Builder(address, "add").param("jndi-name", "java:/bar").header("header1", "value1").build();
        this.assertOperation(operation.runAs(Collections.singleton("Administrator")), "Administrator");
    }

    private void assertOperation(Operation operation) {
        this.assertOperation(operation, null);
    }

    private void assertOperation(Operation operation, String runAs) {
        Assert.assertEquals((Object)"add", (Object)operation.getName());
        Assert.assertEquals((Object)"/subsystem=datasources/data-source=foo", (Object)operation.getAddress().toString());
        ModelNode parameter = new ModelNode();
        parameter.get("jndi-name").set("java:/bar");
        Assert.assertEquals((Object)parameter, (Object)operation.getParameter());
        ModelNode header = new ModelNode();
        header.get("header1").set("value1");
        if (runAs != null) {
            header.get("roles").set(runAs);
            Assert.assertEquals((Object)header, (Object)operation.getHeader());
        }
        StringBuilder expected = new StringBuilder();
        expected.append("/subsystem=datasources/data-source=foo:add(jndi-name=java:/bar){header1=value1");
        if (runAs != null) {
            expected.append(",roles=").append(runAs);
        }
        expected.append("}");
        Assert.assertEquals((Object)expected.toString(), (Object)operation.asCli());
    }
}

