/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.dmr;

import java.util.ArrayList;
import org.jboss.hal.dmr.Property;
import org.jboss.hal.dmr.ResourceAddress;
import org.junit.Assert;
import org.junit.Test;

public class ResourceAddressTest {
    @Test(expected=IllegalArgumentException.class)
    public void fromNull() {
        ResourceAddress.from(null);
    }

    @Test
    public void fromEmpty() {
        ResourceAddress address = ResourceAddress.from((String)"");
        Assert.assertEquals((Object)ResourceAddress.root(), (Object)address);
    }

    @Test
    public void fromRoot() {
        ResourceAddress address = ResourceAddress.from((String)"/");
        Assert.assertEquals((Object)ResourceAddress.root(), (Object)address);
    }

    @Test
    public void fromAddressWithSlash() {
        ResourceAddress address = ResourceAddress.from((String)"/subsystem=ee");
        Assert.assertFalse((boolean)address.isEmpty());
        Assert.assertEquals((long)1L, (long)address.size());
        Assert.assertArrayEquals((Object[])new String[]{"subsystem", "ee"}, (Object[])this.segments(address));
    }

    @Test
    public void fromAddressWithoutSlash() {
        ResourceAddress address = ResourceAddress.from((String)"subsystem=ee");
        Assert.assertFalse((boolean)address.isEmpty());
        Assert.assertEquals((long)1L, (long)address.size());
        Assert.assertArrayEquals((Object[])new String[]{"subsystem", "ee"}, (Object[])this.segments(address));
    }

    @Test
    public void fromAddress() {
        ResourceAddress address = ResourceAddress.from((String)"subsystem=ee/context-service=default");
        Assert.assertFalse((boolean)address.isEmpty());
        Assert.assertEquals((long)2L, (long)address.size());
        Assert.assertArrayEquals((Object[])new String[]{"subsystem", "ee", "context-service", "default"}, (Object[])this.segments(address));
    }

    @Test
    public void startsWith() {
        ResourceAddress address = ResourceAddress.from((String)"/host=primary/server=server1");
        Assert.assertTrue((boolean)ResourceAddress.root().startsWith(ResourceAddress.root()));
        Assert.assertTrue((boolean)ResourceAddress.from((String)"/host=primary/server=server1").startsWith(ResourceAddress.root()));
        Assert.assertTrue((boolean)ResourceAddress.from((String)"/host=primary/server=server1").startsWith(address));
        Assert.assertTrue((boolean)ResourceAddress.from((String)"/host=primary/server=server1/").startsWith(address));
        Assert.assertTrue((boolean)ResourceAddress.from((String)"/host=primary/server=server1/subsystem=undertow").startsWith(address));
        Assert.assertFalse((boolean)ResourceAddress.root().startsWith(address));
        Assert.assertFalse((boolean)ResourceAddress.from((String)"/host=primary").startsWith(address));
        Assert.assertFalse((boolean)ResourceAddress.from((String)"/host=primary/server=server2").startsWith(address));
        Assert.assertFalse((boolean)ResourceAddress.from((String)"/host=secondary/server=server1").startsWith(address));
        Assert.assertFalse((boolean)ResourceAddress.from((String)"/subsystem=undertow").startsWith(address));
    }

    private String[] segments(ResourceAddress address) {
        ArrayList<String> segments = new ArrayList<String>();
        for (Property property : address.asPropertyList()) {
            segments.add(property.getName());
            segments.add(property.getValue().asString());
        }
        return segments.toArray(new String[0]);
    }
}

