/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import com.google.auto.common.MoreElements;
import com.google.auto.service.AutoService;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jboss.auto.AbstractProcessor;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Table;
import org.jboss.hal.core.mbui.MbuiViewImpl;
import org.jboss.hal.processor.TypeSimplifier;
import org.jboss.hal.processor.mbui.AbstractPropertyInfo;
import org.jboss.hal.processor.mbui.Content;
import org.jboss.hal.processor.mbui.DataTableInfo;
import org.jboss.hal.processor.mbui.DataTableProcessor;
import org.jboss.hal.processor.mbui.ElementType;
import org.jboss.hal.processor.mbui.FormInfo;
import org.jboss.hal.processor.mbui.FormProcessor;
import org.jboss.hal.processor.mbui.MbuiElementInfo;
import org.jboss.hal.processor.mbui.MbuiElementProcessor;
import org.jboss.hal.processor.mbui.MbuiViewContext;
import org.jboss.hal.processor.mbui.MetadataInfo;
import org.jboss.hal.processor.mbui.PostConstructInfo;
import org.jboss.hal.processor.mbui.VerticalNavigationInfo;
import org.jboss.hal.processor.mbui.VerticalNavigationProcessor;
import org.jboss.hal.processor.mbui.XmlHelper;
import org.jboss.hal.spi.MbuiElement;
import org.jboss.hal.spi.MbuiView;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

@SupportedAnnotationTypes(value={"org.jboss.hal.spi.MbuiView"})
@AutoService(value={Processor.class})
public class MbuiViewProcessor
extends AbstractProcessor {
    public static final String GET = "get";
    public static final String IS = "is";
    private static final String MBUI_PREFIX = "Mbui_";
    private static final String SLASH_SLASH = "//";
    private static final String TEMPLATE = "MbuiView.ftl";
    private XPathFactory xPathFactory;

    static void resetCounter() {
        Content.counter = 0;
        MetadataInfo.counter = 0;
    }

    public MbuiViewProcessor() {
        this(MbuiViewProcessor.class, "templates");
    }

    protected MbuiViewProcessor(Class resourceLoaderClass, String templates) {
        super(resourceLoaderClass, templates);
    }

    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(MbuiView.class)) {
            TypeElement type = (TypeElement)element;
            MbuiView mbuiView = type.getAnnotation(MbuiView.class);
            this.validateType(type, mbuiView);
            this.processType(type, mbuiView);
        }
        return false;
    }

    private void validateType(TypeElement type, MbuiView mbuiView) {
        if (mbuiView == null) {
            this.error(type, "Annotation processor for @%s was invoked with a type that does not have that annotation; this is probably a compiler bug", new Object[]{MbuiView.class.getSimpleName()});
        }
        if (type.getKind() != ElementKind.CLASS) {
            this.error(type, "@%s only applies to classes", new Object[]{MbuiView.class.getSimpleName()});
        }
        if (!this.isAssignable(type, MbuiViewImpl.class)) {
            this.error(type, "Missing base class %s", new Object[]{MbuiViewImpl.class.getSimpleName()});
        }
        if (this.ancestorIsMbuiView(type)) {
            this.error(type, "One @%s class may not extend another", new Object[]{MbuiView.class.getSimpleName()});
        }
        if (this.isAssignable(type, Annotation.class)) {
            this.error(type, "@%s may not be used to implement an annotation interface", new Object[]{MbuiView.class.getSimpleName()});
        }
    }

    private boolean ancestorIsMbuiView(TypeElement type) {
        TypeMirror parentMirror;
        while ((parentMirror = type.getSuperclass()).getKind() != TypeKind.NONE) {
            TypeElement parentElement = (TypeElement)this.typeUtils.asElement(parentMirror);
            if (parentElement.getAnnotation(MbuiView.class) != null) {
                return true;
            }
            type = parentElement;
        }
        return false;
    }

    private boolean isAssignable(TypeElement subType, Class<?> baseType) {
        return this.isAssignable(subType.asType(), baseType);
    }

    private boolean isAssignable(TypeMirror subType, Class<?> baseType) {
        return this.isAssignable(subType, this.getTypeMirror(baseType));
    }

    private boolean isAssignable(TypeMirror subType, TypeMirror baseType) {
        return this.typeUtils.isAssignable(this.typeUtils.erasure(subType), this.typeUtils.erasure(baseType));
    }

    private TypeMirror getTypeMirror(Class<?> c) {
        return this.processingEnv.getElementUtils().getTypeElement(c.getName()).asType();
    }

    protected void processType(TypeElement type, MbuiView mbuiView) {
        String subclass = TypeSimplifier.simpleNameOf(this.generatedClassName(type, ""));
        String createMethod = this.verifyCreateMethod(type);
        MbuiViewContext context = new MbuiViewContext(TypeSimplifier.packageNameOf(type), TypeSimplifier.classNameOf(type), subclass, createMethod);
        this.xPathFactory = XPathFactory.instance();
        Document document = this.parseXml(type, mbuiView);
        this.validateDocument(type, document);
        this.processMetadata(type, document, context);
        this.processMbuiElements(type, document, context);
        this.processRoot(document, context);
        this.processCrossReferences(document, context);
        this.processAbstractProperties(type, context);
        this.processPostConstruct(type, context);
        this.code(TEMPLATE, context.getPackage(), context.getSubclass(), () -> ImmutableMap.of((Object)"context", (Object)context));
        this.info("Generated MBUI view implementation [%s] for [%s]", new Object[]{context.getSubclass(), context.getBase()});
    }

    String generatedClassName(TypeElement type, String suffix) {
        Object name = type.getSimpleName().toString();
        while (type.getEnclosingElement() instanceof TypeElement) {
            type = (TypeElement)type.getEnclosingElement();
            name = String.valueOf(type.getSimpleName()) + "_" + (String)name;
        }
        String pkg = TypeSimplifier.packageNameOf(type);
        String dot = pkg.isEmpty() ? "" : ".";
        return pkg + dot + MBUI_PREFIX + (String)name + suffix;
    }

    String verifyCreateMethod(TypeElement type) {
        Optional<ExecutableElement> createMethod = ElementFilter.methodsIn(type.getEnclosedElements()).stream().filter(method -> method.getModifiers().contains((Object)Modifier.STATIC) && method.getReturnType().equals(type.asType())).findAny();
        if (createMethod.isPresent()) {
            return createMethod.get().getSimpleName().toString();
        }
        this.error(type, "@%s needs to define one static method which returns an %s instance", new Object[]{MbuiView.class.getSimpleName(), type.getSimpleName()});
        return null;
    }

    private Document parseXml(TypeElement type, MbuiView mbuiView) {
        String mbuiXml = Strings.isNullOrEmpty((String)mbuiView.value()) ? type.getSimpleName().toString() + ".mbui.xml" : mbuiView.value();
        String fq = TypeSimplifier.packageNameOf(type).replace('.', '/') + "/" + mbuiXml;
        try {
            FileObject file = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_PATH, "", fq);
            return new SAXBuilder().build(file.openReader(true));
        }
        catch (IOException e) {
            this.error(type, "Cannot find MBUI XML \"%s\". Please make sure the file exists and resides in the source path.", new Object[]{fq});
        }
        catch (JDOMException e) {
            this.error(type, "Cannot parse MBUI XML \"%s\". Please verify that the file contains valid XML.", new Object[]{fq});
        }
        return null;
    }

    private void validateDocument(TypeElement type, Document document) {
        List children;
        org.jdom2.Element root = document.getRootElement();
        if (!root.getName().equals("view")) {
            this.error(type, "Invalid root element in MBUI XML. Allowed: \"%s\", found: \"%s\".", new Object[]{"view", root.getName()});
        }
        if ((children = root.getChildren()).isEmpty()) {
            this.error(type, "No children found in MBUI XML.", new Object[0]);
        } else if (children.size() > 1) {
            this.error(type, "Only one child allowed in MBUI XML.", new Object[0]);
        }
        org.jdom2.Element child = (org.jdom2.Element)children.get(0);
        if (!child.getName().equals("vertical-navigation") && !child.getName().equals("metadata")) {
            this.error(type, "Invalid child of root element in MBUI XML. Allowed: \"%s\" or \"%s\", found: \"%s\".", new Object[]{"vertical-navigation", "metadata", child.getName()});
        }
    }

    private void processMetadata(TypeElement type, Document document, MbuiViewContext context) {
        XPathExpression expression = this.xPathFactory.compile("//metadata", Filters.element());
        for (org.jdom2.Element element : expression.evaluate((Object)document)) {
            String template = element.getAttributeValue("address");
            if (template == null) {
                this.error(type, "Missing address attribute in metadata element \"%s\"", new Object[]{XmlHelper.xmlAsString(element)});
                continue;
            }
            context.addMetadata(template);
        }
    }

    private void processMbuiElements(TypeElement type, Document document, MbuiViewContext context) {
        ElementFilter.fieldsIn(type.getEnclosedElements()).stream().filter(field -> MoreElements.isAnnotationPresent((Element)field, MbuiElement.class)).forEach(field -> {
            if (field.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error((Element)field, "@%s member must not be private", new Object[]{MbuiElement.class.getSimpleName()});
            }
            if (field.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error((Element)field, "@%s member must not be static", new Object[]{MbuiElement.class.getSimpleName()});
            }
            String selector = this.getSelector((Element)field);
            org.jdom2.Element element = this.verifySelector(selector, (Element)field, document);
            ElementType elementType = this.getMbuiElementType(field.asType());
            if (elementType == null) {
                this.error((Element)field, "Unsupported type %s. Please choose one of %s", new Object[]{field.asType(), EnumSet.allOf(ElementType.class)});
            } else {
                MbuiElementProcessor elementProcessor = null;
                switch (elementType) {
                    case VerticalNavigation: {
                        elementProcessor = new VerticalNavigationProcessor(this, this.elementUtils, this.xPathFactory);
                        break;
                    }
                    case Table: {
                        elementProcessor = new DataTableProcessor(this, this.elementUtils, this.xPathFactory);
                        break;
                    }
                    case Form: {
                        elementProcessor = new FormProcessor(this, this.elementUtils, this.xPathFactory);
                        break;
                    }
                }
                elementProcessor.process((VariableElement)field, element, selector, context);
            }
        });
    }

    private String getSelector(Element element) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values;
        String selector = null;
        com.google.common.base.Optional annotationMirror = MoreElements.getAnnotationMirror((Element)element, MbuiElement.class);
        if (annotationMirror.isPresent() && !(values = this.elementUtils.getElementValuesWithDefaults((AnnotationMirror)annotationMirror.get())).isEmpty()) {
            selector = String.valueOf(values.values().iterator().next().getValue());
        }
        return Strings.emptyToNull(selector) == null ? element.getSimpleName().toString() : selector;
    }

    private org.jdom2.Element verifySelector(String selector, Element element, Document document) {
        XPathExpression expression = this.xPathFactory.compile("//*[@id='" + selector + "']", Filters.element());
        List elements = expression.evaluate((Object)document);
        if (elements.isEmpty()) {
            this.error(element, "Cannot find a matching element in the MBUI XML with id \"%s\".", new Object[]{selector});
        } else if (elements.size() > 1) {
            this.error(element, "Found %d matching elements in the MBUI XML with id \"%s\". Id must be unique.", new Object[]{elements.size(), selector});
        }
        return (org.jdom2.Element)elements.get(0);
    }

    private ElementType getMbuiElementType(TypeMirror dataElementType) {
        if (this.isAssignable(dataElementType, VerticalNavigation.class)) {
            return ElementType.VerticalNavigation;
        }
        if (this.isAssignable(dataElementType, Table.class)) {
            return ElementType.Table;
        }
        if (this.isAssignable(dataElementType, Form.class)) {
            return ElementType.Form;
        }
        return null;
    }

    private void processRoot(Document document, MbuiViewContext context) {
        if (!"vertical-navigation".equals(document.getRootElement().getName())) {
            Content.parse(document.getRootElement(), context).forEach(context::addContent);
        }
    }

    private void processCrossReferences(Document document, MbuiViewContext context) {
        XPathExpression expression = this.xPathFactory.compile("//table[@form-ref]", Filters.element());
        for (org.jdom2.Element element : expression.evaluate((Object)document)) {
            DataTableInfo tableInfo = (DataTableInfo)context.getElement(element.getAttributeValue("id"));
            FormInfo formInfo = (FormInfo)context.getElement(element.getAttributeValue("form-ref"));
            if (tableInfo == null || formInfo == null) continue;
            tableInfo.setFormRef(formInfo);
        }
        VerticalNavigationInfo navigation = context.getVerticalNavigation();
        if (navigation == null) {
            for (MbuiElementInfo elementInfo : context.getElements()) {
                Content reference = context.findContent(elementInfo.getSelector());
                if (reference == null) continue;
                reference.setReference(elementInfo.getName());
            }
        } else {
            this.resolveItemReferences(navigation, "//item//table", document, context);
            this.resolveItemReferences(navigation, "//item//form", document, context);
            this.resolveItemReferences(navigation, "//item//singleton-form", document, context);
        }
    }

    private void resolveItemReferences(VerticalNavigationInfo navigation, String xpath, Document document, MbuiViewContext context) {
        XPathExpression expression = this.xPathFactory.compile(xpath, Filters.element());
        for (org.jdom2.Element element : expression.evaluate((Object)document)) {
            VerticalNavigationInfo.Item parentItem;
            Content reference;
            String id = element.getAttributeValue("id");
            Object elementInfo = context.getElement(id);
            if (elementInfo == null) continue;
            XPathExpression parentItemExpression = this.xPathFactory.compile("ancestor::sub-item", Filters.element());
            org.jdom2.Element parentItemElement = (org.jdom2.Element)parentItemExpression.evaluateFirst((Object)element);
            if (parentItemElement == null) {
                parentItemExpression = this.xPathFactory.compile("ancestor::item", Filters.element());
                parentItemElement = (org.jdom2.Element)parentItemExpression.evaluateFirst((Object)element);
            }
            if ((reference = (parentItem = navigation.getItem(parentItemElement.getAttributeValue("id"))).findContent(id)) == null) continue;
            reference.setReference(((MbuiElementInfo)elementInfo).getName());
        }
    }

    void processAbstractProperties(TypeElement type, MbuiViewContext context) {
        ElementFilter.methodsIn(type.getEnclosedElements()).stream().filter(method -> method.getModifiers().contains((Object)Modifier.ABSTRACT)).forEach(method -> {
            if (method.getReturnType().getKind() == TypeKind.VOID) {
                this.error((Element)method, "Abstract propertiers in a @%s class must not return void", new Object[]{MbuiView.class.getSimpleName()});
            }
            if (!method.getParameters().isEmpty()) {
                this.error((Element)method, "Abstract properties in a @%s class must not have parameters", new Object[]{MbuiView.class.getSimpleName()});
            }
            String typeName = TypeSimplifier.simpleTypeName(method.getReturnType());
            String methodName = method.getSimpleName().toString();
            String fieldName = this.isGetter((ExecutableElement)method) ? this.nameWithoutPrefix(methodName) : methodName;
            String modifier = this.getModifier((ExecutableElement)method);
            context.addAbstractProperty(new AbstractPropertyInfo(typeName, fieldName, methodName, modifier));
        });
    }

    private boolean isGetter(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        boolean get = name.startsWith(GET) && !name.equals(GET);
        boolean is = name.startsWith(IS) && !name.equals(IS) && method.getReturnType().getKind() == TypeKind.BOOLEAN;
        return get || is;
    }

    private String nameWithoutPrefix(String name) {
        String withoutPrefix;
        if (name.startsWith(GET) && !name.equals(GET)) {
            withoutPrefix = name.substring(3);
        } else {
            assert (name.startsWith(IS));
            withoutPrefix = name.substring(2);
        }
        return Introspector.decapitalize(withoutPrefix);
    }

    private String getModifier(ExecutableElement method) {
        String modifier = null;
        Set<Modifier> modifiers = method.getModifiers();
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            modifier = "public";
        } else if (modifiers.contains((Object)Modifier.PROTECTED)) {
            modifier = "protected";
        }
        return modifier;
    }

    private void processPostConstruct(TypeElement type, MbuiViewContext context) {
        ElementFilter.methodsIn(type.getEnclosedElements()).stream().filter(method -> MoreElements.isAnnotationPresent((Element)method, PostConstruct.class)).forEach(method -> {
            if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error((Element)method, "@%s method must not be private", new Object[]{PostConstruct.class.getSimpleName()});
            }
            if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error((Element)method, "@%s method must not be static", new Object[]{PostConstruct.class.getSimpleName()});
            }
            if (!method.getReturnType().equals(this.typeUtils.getNoType(TypeKind.VOID))) {
                this.error((Element)method, "@%s method must return void", new Object[]{PostConstruct.class.getSimpleName()});
            }
            if (!method.getParameters().isEmpty()) {
                this.error((Element)method, "@%s method must not have parameters", new Object[]{PostConstruct.class.getSimpleName()});
            }
            context.addPostConstruct(new PostConstructInfo(method.getSimpleName().toString()));
        });
        if (context.getPostConstructs().size() > 1) {
            this.warning(type, "%d methods annotated with @%s found. Order is not guaranteed!", new Object[]{context.getPostConstructs().size(), PostConstruct.class.getSimpleName()});
        }
    }
}

