/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.UndertowLogger;
import io.undertow.protocols.ssl.SslConduit;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.xnio.ssl.SslConnection;

public class UndertowLogger_$logger
extends DelegatingBasicLogger
implements UndertowLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UndertowLogger_$logger.class.getName();
    private static final String exceptionProcessingRequest = "UT005001: An exception occurred processing the request";
    private static final String ioExceptionReadingFromChannel = "UT005003: IOException reading from channel";
    private static final String cannotRemoveUploadedFile = "UT005005: Cannot remove uploaded file %s";
    private static final String requestHeaderWasTooLarge = "UT005006: Connection from %s terminated as request header was larger than %s";
    private static final String requestWasNotFullyConsumed = "UT005007: Request was not fully consumed";
    private static final String invalidTokenReceived = "UT005008: An invalid token '%s' with value '%s' has been received.";
    private static final String missingAuthorizationToken = "UT005009: A mandatory token %s is missing from the request.";
    private static final String authenticationFailed = "UT005010: Verification of authentication tokens for user '%s' has failed using mechanism '%s'.";
    private static final String ignoringAjpRequestWithPrefixCode = "UT005011: Ignoring AJP request with prefix %s";
    private static final String ioException = "UT005013: An IOException occurred";
    private static final String failedToParseRequest = "UT005014: Failed to parse request";
    private static final String errorRotatingAccessLog = "UT005015: Error rotating access log";
    private static final String errorWritingAccessLog = "UT005016: Error writing access log";
    private static final String unknownVariable = "UT005017: Unknown variable %s. For the literal percent character use two percent characters: '%%'";
    private static final String exceptionInvokingCloseListener = "UT005018: Exception invoking close listener %s";
    private static final String errorWritingJDBCLog = "UT005020: Error writing JDBC log";
    private static final String exceptionGeneratingErrorPage = "UT005022: Exception generating error page %s";
    private static final String exceptionHandlingRequest = "UT005023: Exception handling request to %s";
    private static final String couldNotRegisterChangeListener = "UT005024: Could not register resource change listener for caching resource manager, automatic invalidation of cached resource will not work";
    private static final String timingOutRequest = "UT005027: Timing out request to %s";
    private static final String proxyRequestFailed = "UT005028: Proxy request to %s failed";
    private static final String proxyFailedToConnectToBackend = "UT005031: Proxy request to %s could not connect to backend server %s";
    private static final String listenerNotProgressing = "UT005032: Listener not making progress on framed channel, closing channel to prevent infinite loop";
    private static final String remoteEndpointFailedToSendInitialSettings = "UT005034: Remote endpoint failed to send initial settings frame in HTTP2 connection, frame type %s";
    private static final String parseRequestTimedOut = "UT005035: Closing channel because of parse timeout for remote address %s";
    private static final String noALPNFallback = "UT005036: ALPN negotiation failed for %s and no fallback defined, closing connection";
    private static final String stickySessionCookieLengthTruncated = "UT005037: Name of the cookie containing the session id, %s, had been too long and was truncated to: %s";
    private static final String balancerCreated = "UT005038: Balancer created: id: %s, name: %s, stickySession: %s, stickySessionCookie: %s, stickySessionPath: %s, stickySessionRemove: %s, stickySessionForce: %s, waitWorker: %s, maxattempts: %s";
    private static final String proxyAdvertisementsStarted = "UT005039: Undertow starts mod_cluster proxy advertisements on %s with frequency %s ms";
    private static final String proxyAdvertiseMessagePayload = "UT005040: Gonna send payload:\n%s";
    private static final String proxyAdvertiseCannotSendMessage = "UT005041: Cannot send advertise message. Address: %s";
    private static final String mcmpHandlerCreated = "UT005042: Undertow mod_cluster proxy MCMPHandler created";
    private static final String mcmpProcessingError = "UT005043: Error in processing MCMP commands: Type:%s, Mess: %s";
    private static final String removingNode = "UT005044: Removing node %s";
    private static final String registeringContext2 = "UT005045: Registering context %s, for node %s";
    private static final String registeringContext3 = "UT005046: Registering context %s, for node %s, with aliases %s";
    private static final String unregisteringContext = "UT005047: Unregistering context %s, from node %s";
    private static final String nodeIsInError = "UT005048: Node %s in error";
    private static final String nodeConfigCreated = "UT005049: NodeConfig created: connectionURI: %s, balancer: %s, load balancing group: %s, jvmRoute: %s, flushPackets: %s, flushwait: %s, ping: %s,ttl: %s, timeout: %s, maxConnections: %s, cacheConnections: %s, requestQueueSize: %s, queueNewRequests: %s";
    private static final String failedToProcessManagementReq = "UT005050: Failed to process management request";
    private static final String failedToSendPingResponse = "UT005051: Failed to send ping response";
    private static final String failedToSendPingResponseDBG = "UT005052: Failed to send ping response, node.getJvmRoute(): %s, jvmRoute: %s";
    private static final String registeringNode = "UT005053: Registering node %s, connection: %s";
    private static final String mcmpKeyValue = "UT005054: MCMP processing, key: %s, value: %s";
    private static final String httpClientPingTask = "UT005055: HttpClientPingTask run for connection: %s";
    private static final String receivedNodeLoad = "UT005056: Received node load in STATUS message, node jvmRoute: %s, load: %s";
    private static final String mcmpSendingResponse = "UT005057: Sending MCMP response to destination: %s, HTTP status: %s, Headers: %s, response: %s";
    private static final String potentialCrossTalking = "UT005058: Could not bind multicast socket to %s (%s address): %s; make sure your multicast address is of the same type as the IP stack (IPv4 or IPv6). Multicast socket will not be bound to an address, but this may lead to cross talking (see http://www.jboss.org/community/docs/DOC-9469 for details).";
    private static final String oldStylePredicateSyntax = "UT005060: Predicate %s uses old style square braces to define predicates, which will be removed in a future release. predicate[value] should be changed to predicate(value)";
    private static final String maxRestartsExceeded = "UT005061: More than %s restarts detected, breaking assumed infinite loop";
    private static final String extendedAccessLogPatternParseError = "UT005062: Pattern parse error";
    private static final String extendedAccessLogUnknownToken = "UT005063: Unable to decode with rest of chars starting: %s";
    private static final String extendedAccessLogMissingClosing = "UT005064: No closing ) found for in decode";
    private static final String extendedAccessLogCannotDecode = "UT005065: The next characters couldn't be decoded: %s";
    private static final String extendedAccessLogCannotDecodeXParamValue = "UT005066: X param for servlet request, couldn't decode value: %s";
    private static final String extendedAccessLogBadXParam = "UT005067: X param in wrong format. Needs to be 'x-#(...)'";
    private static final String extendedAccessLogEmptyPattern = "UT005068: Pattern was just empty or whitespace";
    private static final String failedToWriteJdbcAccessLog = "UT005069: Failed to write JDBC access log";
    private static final String failedToWritePreCachedFile = "UT005070: Failed to write pre-cached file";
    private static final String undertowRequestFailed = "UT005071: Undertow request failed %s";
    private static final String stuckThreadDetected = "UT005072: Thread %s (id=%s) has been active for %s milliseconds (since %s) to serve the same request for %s and may be stuck (configured threshold for this StuckThreadDetectionValve is %s seconds). There is/are %s thread(s) in total that are monitored by this Valve and may be stuck.";
    private static final String stuckThreadCompleted = "UT005073: Thread %s (id=%s) was previously reported to be stuck but has completed. It was active for approximately %s milliseconds. There is/are still %s thread(s) that are monitored by this Valve and may be stuck.";
    private static final String failedToInvokeFailedCallback = "UT005074: Failed to invoke error callback %s for SSE task";
    private static final String unableToResolveModClusterManagementHost = "UT005075: Unable to resolve mod_cluster management host's address for '%s'";
    private static final String sslReadLoopDetected = "UT005076: SSL read loop detected. This should not happen, please report this to the Undertow developers. Current state %s";
    private static final String sslBufferOverflow = "UT005077: SSL unwrap buffer overflow detected. This should not happen, please report this to the Undertow developers. Current state %s";
    private static final String alpnConnectionFailed = "UT005079: ALPN negotiation on %s failed";
    private static final String resumedAndDispatched = "UT005080: HttpServerExchange cannot have both async IO resumed and dispatch() called in the same cycle";
    private static final String cannotProxyStartedRequest = "UT005081: Response has already been started, cannot proxy request %s";
    private static final String cannotUseWildcardAddressAsModClusterManagementHost = "UT005082: Configured mod_cluster management host address cannot be a wildcard address (%s)!";
    private static final String unexpectedEndOfCompressedInput = "UT005083: Unexpected end of compressed input";
    private static final String dataLargerThanContentLength = "UT005084: Attempted to write %s bytes however content-length has been set to %s";
    private static final String responseWasNotTerminated = "UT005085: Connection %s for exchange %s was not closed cleanly, forcibly closing connection";
    private static final String failedToAcceptSSLRequest = "UT005086: Failed to accept SSL request";
    private static final String failedToUseServerOrder = "UT005087: Failed to use the server order";
    private static final String closeAsyncFailed = "UT005088: Failed to execute ServletOutputStream.closeAsync() on IO thread";
    private static final String nullParameter = "UT005089: Method parameter '%s' cannot be null";
    private static final String handleUnexpectedFailure = "UT005090: Unexpected failure";
    private static final String directBufferDeallocatorInitializationFailed = "UT005091: Failed to initialize DirectByteBufferDeallocator";
    private static final String directBufferDeallocationFailed = "UT005092: Failed to free direct buffer";

    public UndertowLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void exceptionProcessingRequest(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.exceptionProcessingRequest$str(), new Object[0]);
    }

    protected String exceptionProcessingRequest$str() {
        return exceptionProcessingRequest;
    }

    @Override
    public final void ioExceptionReadingFromChannel(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.ioExceptionReadingFromChannel$str(), new Object[0]);
    }

    protected String ioExceptionReadingFromChannel$str() {
        return ioExceptionReadingFromChannel;
    }

    @Override
    public final void cannotRemoveUploadedFile(Path file) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.cannotRemoveUploadedFile$str(), (Object)file);
    }

    protected String cannotRemoveUploadedFile$str() {
        return cannotRemoveUploadedFile;
    }

    @Override
    public final void requestHeaderWasTooLarge(SocketAddress address, int size) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.requestHeaderWasTooLarge$str(), (Object)address, (Object)size);
    }

    protected String requestHeaderWasTooLarge$str() {
        return requestHeaderWasTooLarge;
    }

    @Override
    public final void requestWasNotFullyConsumed() {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.requestWasNotFullyConsumed$str(), new Object[0]);
    }

    protected String requestWasNotFullyConsumed$str() {
        return requestWasNotFullyConsumed;
    }

    @Override
    public final void invalidTokenReceived(String tokenName, String tokenValue) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.invalidTokenReceived$str(), (Object)tokenName, (Object)tokenValue);
    }

    protected String invalidTokenReceived$str() {
        return invalidTokenReceived;
    }

    @Override
    public final void missingAuthorizationToken(String tokenName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.missingAuthorizationToken$str(), (Object)tokenName);
    }

    protected String missingAuthorizationToken$str() {
        return missingAuthorizationToken;
    }

    @Override
    public final void authenticationFailed(String userName, String mechanism) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.authenticationFailed$str(), (Object)userName, (Object)mechanism);
    }

    protected String authenticationFailed$str() {
        return authenticationFailed;
    }

    @Override
    public final void ignoringAjpRequestWithPrefixCode(byte prefix) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.ignoringAjpRequestWithPrefixCode$str(), (Object)prefix);
    }

    protected String ignoringAjpRequestWithPrefixCode$str() {
        return ignoringAjpRequestWithPrefixCode;
    }

    @Override
    public final void ioException(IOException e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)e, this.ioException$str(), new Object[0]);
    }

    protected String ioException$str() {
        return ioException;
    }

    @Override
    public final void failedToParseRequest(Throwable e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, e, this.failedToParseRequest$str(), new Object[0]);
    }

    protected String failedToParseRequest$str() {
        return failedToParseRequest;
    }

    @Override
    public final void errorRotatingAccessLog(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRotatingAccessLog$str(), new Object[0]);
    }

    protected String errorRotatingAccessLog$str() {
        return errorRotatingAccessLog;
    }

    @Override
    public final void errorWritingAccessLog(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorWritingAccessLog$str(), new Object[0]);
    }

    protected String errorWritingAccessLog$str() {
        return errorWritingAccessLog;
    }

    @Override
    public final void unknownVariable(String token) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.unknownVariable$str(), (Object)token);
    }

    protected String unknownVariable$str() {
        return unknownVariable;
    }

    @Override
    public final void exceptionInvokingCloseListener(ServerConnection.CloseListener l, Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.exceptionInvokingCloseListener$str(), (Object)l);
    }

    protected String exceptionInvokingCloseListener$str() {
        return exceptionInvokingCloseListener;
    }

    @Override
    public final void errorWritingJDBCLog(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorWritingJDBCLog$str(), new Object[0]);
    }

    protected String errorWritingJDBCLog$str() {
        return errorWritingJDBCLog;
    }

    @Override
    public final void exceptionGeneratingErrorPage(Exception e, String location) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.exceptionGeneratingErrorPage$str(), (Object)location);
    }

    protected String exceptionGeneratingErrorPage$str() {
        return exceptionGeneratingErrorPage;
    }

    @Override
    public final void exceptionHandlingRequest(Throwable t, String requestURI) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.exceptionHandlingRequest$str(), (Object)requestURI);
    }

    protected String exceptionHandlingRequest$str() {
        return exceptionHandlingRequest;
    }

    @Override
    public final void couldNotRegisterChangeListener(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.couldNotRegisterChangeListener$str(), new Object[0]);
    }

    protected String couldNotRegisterChangeListener$str() {
        return couldNotRegisterChangeListener;
    }

    @Override
    public final void timingOutRequest(String requestURI) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.timingOutRequest$str(), (Object)requestURI);
    }

    protected String timingOutRequest$str() {
        return timingOutRequest;
    }

    @Override
    public final void proxyRequestFailed(String requestURI, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.proxyRequestFailed$str(), (Object)requestURI);
    }

    protected String proxyRequestFailed$str() {
        return proxyRequestFailed;
    }

    @Override
    public final void proxyFailedToConnectToBackend(String requestURI, URI uri) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.proxyFailedToConnectToBackend$str(), (Object)requestURI, (Object)uri);
    }

    protected String proxyFailedToConnectToBackend$str() {
        return proxyFailedToConnectToBackend;
    }

    @Override
    public final void listenerNotProgressing() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.listenerNotProgressing$str(), new Object[0]);
    }

    protected String listenerNotProgressing$str() {
        return listenerNotProgressing;
    }

    @Override
    public final void remoteEndpointFailedToSendInitialSettings(int type) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.remoteEndpointFailedToSendInitialSettings$str(), (Object)type);
    }

    protected String remoteEndpointFailedToSendInitialSettings$str() {
        return remoteEndpointFailedToSendInitialSettings;
    }

    @Override
    public final void parseRequestTimedOut(SocketAddress remoteAddress) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.parseRequestTimedOut$str(), (Object)remoteAddress);
    }

    protected String parseRequestTimedOut$str() {
        return parseRequestTimedOut;
    }

    @Override
    public final void noALPNFallback(SocketAddress address) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.noALPNFallback$str(), (Object)address);
    }

    protected String noALPNFallback$str() {
        return noALPNFallback;
    }

    @Override
    public final void stickySessionCookieLengthTruncated(String original, String current) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.stickySessionCookieLengthTruncated$str(), (Object)original, (Object)current);
    }

    protected String stickySessionCookieLengthTruncated$str() {
        return stickySessionCookieLengthTruncated;
    }

    @Override
    public final void balancerCreated(int id, String name, boolean stickySession, String stickySessionCookie, String stickySessionPath, boolean stickySessionRemove, boolean stickySessionForce, int waitWorker, int maxattempts) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.balancerCreated$str(), id, name, stickySession, stickySessionCookie, stickySessionPath, stickySessionRemove, stickySessionForce, waitWorker, maxattempts);
    }

    protected String balancerCreated$str() {
        return balancerCreated;
    }

    @Override
    public final void proxyAdvertisementsStarted(String address, int frequency) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.proxyAdvertisementsStarted$str(), (Object)address, (Object)frequency);
    }

    protected String proxyAdvertisementsStarted$str() {
        return proxyAdvertisementsStarted;
    }

    @Override
    public final void proxyAdvertiseMessagePayload(String payload) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.proxyAdvertiseMessagePayload$str(), (Object)payload);
    }

    protected String proxyAdvertiseMessagePayload$str() {
        return proxyAdvertiseMessagePayload;
    }

    @Override
    public final void proxyAdvertiseCannotSendMessage(Exception e, InetSocketAddress address) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.proxyAdvertiseCannotSendMessage$str(), (Object)address);
    }

    protected String proxyAdvertiseCannotSendMessage$str() {
        return proxyAdvertiseCannotSendMessage;
    }

    @Override
    public final void mcmpHandlerCreated() {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.mcmpHandlerCreated$str(), new Object[0]);
    }

    protected String mcmpHandlerCreated$str() {
        return mcmpHandlerCreated;
    }

    @Override
    public final void mcmpProcessingError(String type, String errString) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.mcmpProcessingError$str(), (Object)type, (Object)errString);
    }

    protected String mcmpProcessingError$str() {
        return mcmpProcessingError;
    }

    @Override
    public final void removingNode(String jvmRoute) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.removingNode$str(), (Object)jvmRoute);
    }

    protected String removingNode$str() {
        return removingNode;
    }

    @Override
    public final void registeringContext(String contextPath, String jvmRoute) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.registeringContext2$str(), (Object)contextPath, (Object)jvmRoute);
    }

    protected String registeringContext2$str() {
        return registeringContext2;
    }

    @Override
    public final void registeringContext(String contextPath, String jvmRoute, List<String> aliases) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.registeringContext3$str(), (Object)contextPath, (Object)jvmRoute, (Object)aliases);
    }

    protected String registeringContext3$str() {
        return registeringContext3;
    }

    @Override
    public final void unregisteringContext(String contextPath, String jvmRoute) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.unregisteringContext$str(), (Object)contextPath, (Object)jvmRoute);
    }

    protected String unregisteringContext$str() {
        return unregisteringContext;
    }

    @Override
    public final void nodeIsInError(String jvmRoute) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.nodeIsInError$str(), (Object)jvmRoute);
    }

    protected String nodeIsInError$str() {
        return nodeIsInError;
    }

    @Override
    public final void nodeConfigCreated(URI connectionURI, String balancer, String domain, String jvmRoute, boolean flushPackets, int flushwait, int ping, long ttl, int timeout, int maxConnections, int cacheConnections, int requestQueueSize, boolean queueNewRequests) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.nodeConfigCreated$str(), connectionURI, balancer, domain, jvmRoute, flushPackets, flushwait, ping, ttl, timeout, maxConnections, cacheConnections, requestQueueSize, queueNewRequests);
    }

    protected String nodeConfigCreated$str() {
        return nodeConfigCreated;
    }

    @Override
    public final void failedToProcessManagementReq(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToProcessManagementReq$str(), new Object[0]);
    }

    protected String failedToProcessManagementReq$str() {
        return failedToProcessManagementReq;
    }

    @Override
    public final void failedToSendPingResponse(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToSendPingResponse$str(), new Object[0]);
    }

    protected String failedToSendPingResponse$str() {
        return failedToSendPingResponse;
    }

    @Override
    public final void failedToSendPingResponseDBG(Exception e, String node, String jvmRoute) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)e, this.failedToSendPingResponseDBG$str(), (Object)node, (Object)jvmRoute);
    }

    protected String failedToSendPingResponseDBG$str() {
        return failedToSendPingResponseDBG;
    }

    @Override
    public final void registeringNode(String jvmRoute, URI connectionURI) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.registeringNode$str(), (Object)jvmRoute, (Object)connectionURI);
    }

    protected String registeringNode$str() {
        return registeringNode;
    }

    @Override
    public final void mcmpKeyValue(HttpString name, String value) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.mcmpKeyValue$str(), (Object)name, (Object)value);
    }

    protected String mcmpKeyValue$str() {
        return mcmpKeyValue;
    }

    @Override
    public final void httpClientPingTask(URI connection) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.httpClientPingTask$str(), (Object)connection);
    }

    protected String httpClientPingTask$str() {
        return httpClientPingTask;
    }

    @Override
    public final void receivedNodeLoad(String jvmRoute, String loadValue) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.receivedNodeLoad$str(), (Object)jvmRoute, (Object)loadValue);
    }

    protected String receivedNodeLoad$str() {
        return receivedNodeLoad;
    }

    @Override
    public final void mcmpSendingResponse(InetSocketAddress destination, int status, HeaderMap headers, String response) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.mcmpSendingResponse$str(), destination, status, headers, response);
    }

    protected String mcmpSendingResponse$str() {
        return mcmpSendingResponse;
    }

    @Override
    public final void potentialCrossTalking(InetAddress group, String s, String localizedMessage) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.potentialCrossTalking$str(), (Object)group, (Object)s, (Object)localizedMessage);
    }

    protected String potentialCrossTalking$str() {
        return potentialCrossTalking;
    }

    @Override
    public final void oldStylePredicateSyntax(String string) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.oldStylePredicateSyntax$str(), (Object)string);
    }

    protected String oldStylePredicateSyntax$str() {
        return oldStylePredicateSyntax;
    }

    protected String maxRestartsExceeded$str() {
        return maxRestartsExceeded;
    }

    @Override
    public final IllegalStateException maxRestartsExceeded(int maxRestarts) {
        IllegalStateException result = new IllegalStateException(String.format(this.maxRestartsExceeded$str(), maxRestarts));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void extendedAccessLogPatternParseError(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.extendedAccessLogPatternParseError$str(), new Object[0]);
    }

    protected String extendedAccessLogPatternParseError$str() {
        return extendedAccessLogPatternParseError;
    }

    @Override
    public final void extendedAccessLogUnknownToken(String token) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.extendedAccessLogUnknownToken$str(), (Object)token);
    }

    protected String extendedAccessLogUnknownToken$str() {
        return extendedAccessLogUnknownToken;
    }

    @Override
    public final void extendedAccessLogMissingClosing() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.extendedAccessLogMissingClosing$str(), new Object[0]);
    }

    protected String extendedAccessLogMissingClosing$str() {
        return extendedAccessLogMissingClosing;
    }

    @Override
    public final void extendedAccessLogCannotDecode(String chars) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.extendedAccessLogCannotDecode$str(), (Object)chars);
    }

    protected String extendedAccessLogCannotDecode$str() {
        return extendedAccessLogCannotDecode;
    }

    @Override
    public final void extendedAccessLogCannotDecodeXParamValue(String value) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.extendedAccessLogCannotDecodeXParamValue$str(), (Object)value);
    }

    protected String extendedAccessLogCannotDecodeXParamValue$str() {
        return extendedAccessLogCannotDecodeXParamValue;
    }

    @Override
    public final void extendedAccessLogBadXParam() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.extendedAccessLogBadXParam$str(), new Object[0]);
    }

    protected String extendedAccessLogBadXParam$str() {
        return extendedAccessLogBadXParam;
    }

    @Override
    public final void extendedAccessLogEmptyPattern() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.extendedAccessLogEmptyPattern$str(), new Object[0]);
    }

    protected String extendedAccessLogEmptyPattern$str() {
        return extendedAccessLogEmptyPattern;
    }

    @Override
    public final void failedToWriteJdbcAccessLog(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToWriteJdbcAccessLog$str(), new Object[0]);
    }

    protected String failedToWriteJdbcAccessLog$str() {
        return failedToWriteJdbcAccessLog;
    }

    @Override
    public final void failedToWritePreCachedFile() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.failedToWritePreCachedFile$str(), new Object[0]);
    }

    protected String failedToWritePreCachedFile$str() {
        return failedToWritePreCachedFile;
    }

    @Override
    public final void undertowRequestFailed(Throwable t, HttpServerExchange exchange) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.undertowRequestFailed$str(), (Object)exchange);
    }

    protected String undertowRequestFailed$str() {
        return undertowRequestFailed;
    }

    @Override
    public final void stuckThreadDetected(String threadName, long threadId, long active, Date start, String requestUri, int threshold, int stuckCount, Throwable stackTrace) {
        this.log.logf(FQCN, Logger.Level.WARN, stackTrace, this.stuckThreadDetected$str(), threadName, threadId, active, start, requestUri, threshold, stuckCount);
    }

    protected String stuckThreadDetected$str() {
        return stuckThreadDetected;
    }

    @Override
    public final void stuckThreadCompleted(String threadName, long threadId, long active, int stuckCount) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.stuckThreadCompleted$str(), threadName, threadId, active, stuckCount);
    }

    protected String stuckThreadCompleted$str() {
        return stuckThreadCompleted;
    }

    @Override
    public final void failedToInvokeFailedCallback(ServerSentEventConnection.EventCallback callback, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToInvokeFailedCallback$str(), (Object)callback);
    }

    protected String failedToInvokeFailedCallback$str() {
        return failedToInvokeFailedCallback;
    }

    protected String unableToResolveModClusterManagementHost$str() {
        return unableToResolveModClusterManagementHost;
    }

    @Override
    public final IllegalStateException unableToResolveModClusterManagementHost(String providedHost) {
        IllegalStateException result = new IllegalStateException(String.format(this.unableToResolveModClusterManagementHost$str(), providedHost));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void sslReadLoopDetected(SslConduit sslConduit) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.sslReadLoopDetected$str(), (Object)sslConduit);
    }

    protected String sslReadLoopDetected$str() {
        return sslReadLoopDetected;
    }

    @Override
    public final void sslBufferOverflow(SslConduit sslConduit) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.sslBufferOverflow$str(), (Object)sslConduit);
    }

    protected String sslBufferOverflow$str() {
        return sslBufferOverflow;
    }

    @Override
    public final void alpnConnectionFailed(SslConnection connection) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.alpnConnectionFailed$str(), (Object)connection);
    }

    protected String alpnConnectionFailed$str() {
        return alpnConnectionFailed;
    }

    @Override
    public final void resumedAndDispatched() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.resumedAndDispatched$str(), new Object[0]);
    }

    protected String resumedAndDispatched$str() {
        return resumedAndDispatched;
    }

    @Override
    public final void cannotProxyStartedRequest(HttpServerExchange exchange) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.cannotProxyStartedRequest$str(), (Object)exchange);
    }

    protected String cannotProxyStartedRequest$str() {
        return cannotProxyStartedRequest;
    }

    protected String cannotUseWildcardAddressAsModClusterManagementHost$str() {
        return cannotUseWildcardAddressAsModClusterManagementHost;
    }

    @Override
    public final IllegalArgumentException cannotUseWildcardAddressAsModClusterManagementHost(String providedAddress) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.cannotUseWildcardAddressAsModClusterManagementHost$str(), providedAddress));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedEndOfCompressedInput$str() {
        return unexpectedEndOfCompressedInput;
    }

    @Override
    public final IOException unexpectedEndOfCompressedInput() {
        IOException result = new IOException(String.format(this.unexpectedEndOfCompressedInput$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String dataLargerThanContentLength$str() {
        return dataLargerThanContentLength;
    }

    @Override
    public final IOException dataLargerThanContentLength(long totalToWrite, long responseContentLength) {
        IOException result = new IOException(String.format(this.dataLargerThanContentLength$str(), totalToWrite, responseContentLength));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void responseWasNotTerminated(ServerConnection connection, HttpServerExchange exchange) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.responseWasNotTerminated$str(), (Object)connection, (Object)exchange);
    }

    protected String responseWasNotTerminated$str() {
        return responseWasNotTerminated;
    }

    @Override
    public final void failedToAcceptSSLRequest(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToAcceptSSLRequest$str(), new Object[0]);
    }

    protected String failedToAcceptSSLRequest$str() {
        return failedToAcceptSSLRequest;
    }

    @Override
    public final void failedToUseServerOrder(ReflectiveOperationException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToUseServerOrder$str(), new Object[0]);
    }

    protected String failedToUseServerOrder$str() {
        return failedToUseServerOrder;
    }

    @Override
    public final void closeAsyncFailed(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.closeAsyncFailed$str(), new Object[0]);
    }

    protected String closeAsyncFailed$str() {
        return closeAsyncFailed;
    }

    protected String nullParameter$str() {
        return nullParameter;
    }

    @Override
    public final IllegalArgumentException nullParameter(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullParameter$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void handleUnexpectedFailure(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.handleUnexpectedFailure$str(), new Object[0]);
    }

    protected String handleUnexpectedFailure$str() {
        return handleUnexpectedFailure;
    }

    @Override
    public final void directBufferDeallocatorInitializationFailed(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.directBufferDeallocatorInitializationFailed$str(), new Object[0]);
    }

    protected String directBufferDeallocatorInitializationFailed$str() {
        return directBufferDeallocatorInitializationFailed;
    }

    @Override
    public final void directBufferDeallocationFailed(Throwable t) {
        this.log.logf(FQCN, Logger.Level.DEBUG, t, this.directBufferDeallocationFailed$str(), new Object[0]);
    }

    protected String directBufferDeallocationFailed$str() {
        return directBufferDeallocationFailed;
    }
}

